%% Plot_figure_10

if Flag == 1
    time = datetime(unique(loans_aggreg(:,1)),'ConvertFrom','datenum','Format','MMM-yy');
else
    time = (1:1:size(Dens,1))';
end

figure('Color',[1 1 1])
hold all
plot(time,Dens(:,1),'-b','Linewidth',1.3)
plot(time,Dens(:,2),'-r','Linewidth',1.3)
title('Density Index')
legend(['Core lends to periphery'; 'Periphery lends to core']);
grid on
if Flag == 1
    ylim([0 200])
    ax = gca;
    ax.YTick=[0 50 100 150 200];
    xlim(datetime([2005 2016],[1 12],[1 31]))
    xtickformat('MMM-yy')
    clear ax
end
hold off

clear time