% This function constructs an m*n matrix of 1's and 0's with density=d 
% (approximate since discrete number of elements in matrix) and elements 
% randomly assigned.
%
% =========================================================
% AUTHORS AND INSTITUTION INFO:
% Code written by Anthony Brassil and Gabriela Nodari
% Reserve Bank of Australia
% This version: January 2018
% ==========================================================

function [M] = mrandi(m,n,d)
% Original matrix with density = d
M = zeros(m,n,'uint64');
D = round(d*m*n);

if D>0
    if D>=n
        M(1:floor(D/n),:) = 1;
        if D>(floor(D/n)*n)
            M(floor(D/n)+1,1:(D-(floor(D/n)*n))) = 1;
        end
    else
        M(1,1:D) = 1;
    end

    % Matrix for permutation
    R = zeros(m*n,2,'uint64');
    count = 0;
    for i = 1:m
        for j = 1:n
            count = count + 1;
            R(count,1) = i;
            R(count,2) = j;
        end
    end

    % Permutated matrix
    Rtmp = randperm(m*n);
    Mtmp = zeros(m,n,'uint64');
    count = 0;
    for i = 1:m
        for j = 1:n
            count = count + 1;
            Mtmp(i,j) = M(R(Rtmp(count),1),R(Rtmp(count),2));
        end
    end

    M = Mtmp;
    
end

end
