%Function to calcualate coefficeint to iterate forward surveys for KF
%from Hambur and Finlay (2018)

function [a, b]=fit_short_coeff(rho0_cP,rho1_cP,K0P_cP,K1P_cP,mats_periods,N)

q=size(mats_periods,2);
int_yrf=zeros(1,max(mats_periods)); %matrix of intercepts
slope_yrf=zeros(N,max(mats_periods)); %matrix of slopes on cP
int_yrf(:,1)=rho0_cP; %Start iteration at current
slope_yrf(:,1)=rho1_cP;
for i = 2 : max(mats_periods) % Iterate coefficeints
    int_yrf(:,i)=int_yrf(:,i-1)+(K0P_cP'*(K1P_cP+eye(N))'^(i-2)*rho1_cP);
    slope_yrf(:,i)=(K1P_cP+eye(N))'^(i-1)*rho1_cP;
end

% Put in output matrices
a=zeros(1,q);
b=zeros(N,q);
for i=1:q
    a(:,i)=int_yrf(:,mats_periods(i));
    b(:,i)=slope_yrf(:,mats_periods(i));
end