function [x_tm1t, P_tm1t, x_tt, P_tt, K_t, llks] = kf_r(y_n, y_r, y_cash, y_infl, y_inflQ, y_inflLR,  Phi, alpha, A_n, b_n,A_r, b_r, A_cash, b_cash, A_infl, b_infl, A_inflQ, b_inflQ, A_inflLR, b_inflLR, Q, R_n, R_r, R_cash, R_infl, R_inflQ, R_inflLR, x00, P00, find_r)
% function [x_tm1t, P_tm1t, x_tt, P_tt, K_t, llks] = kf(y, Phi, alpha, A, b,  Q, R, x00, P00)
% KF from Hambur and Finlay (2018)
% Notation is as in Time Series Analysis and Its Applications by Shumway and Stoffer
% MODIFIED TO HAVE INTERCEPTS
% Code adapted from JSZ
% 
% x_t = Phi*x_{t-1} + alpha + w_t, cov(w)=Q,     x is p-dimensional
% y_t = A*x_t + b + v_t,           cov(v)=R,     y is q-dimensional
%
% y     : q*n _"" indicates type of data
% Phi   : p*1
% alpha : p*1
% A     : q*p
% b     : q*1
% Q     : p*p
% R     : q*q
% x00   : p*1  x0 is assued to be normal N(x00,P00)
% P00   : p*p
%
% x_tm1t : p*n
% P_tm1t : p*p*n
% x_tt   : p*n
% P_tt   : p*p*n
% K_t    : p*q*n
% llks   : n*1
%
% P_tm1t(tau) = P_{tau}^{tau-1}, tau=1,..,n
% x_tm1t(tau) = x_{tau}^{tau-1}, tau=1,..,n
% P_tt(tau) = P_{tau}^{tau},     tau=1,..,n
% x_tt(tau) = x_{tau}^{tau},     tau=1,..,n
% K_t(tau)  = K_{tau},           tau=1,..,n Kalman Gain
% llks(t) = log(likelihood(y(t)|y(1),...y(t-1)))  (includes 2*pi terms).
%           it is likelihood not minus log likelihood

p = size(Q,1);
[q_n,n] = size(y_n);
[q_r,n] = size(y_r);

P_tm1t = nan(p,p,n);
x_tm1t = nan(p,n);
P_tt = nan(p,p,n);
x_tt = nan(p,n);
%K_t = nan(p,q,n);
llks = nan(n,1);


% Initialize the recursion and do first step:
Ip = eye(p);
x_tm1t(:,1) = Phi*x00 + alpha; % 4.35
P_tm1t(:,:,1) = Phi*P00*Phi.' + Q; % 4.36

for t=1:n
    %One-step-ahead forecast of x (factors) and its variance
    if t==1
        x_tm1t(:,1) = Phi*x00 + alpha; % 4.35
        P_tm1t(:,:,1) = Phi*P00*Phi.' + Q; % 4.36
    else
        x_tm1t(:,t) = Phi*x_tt(:,t-1) + alpha; % 4.35
        P_tm1t(:,:,t) = Phi*P_tt(:,:,t-1)*Phi.' + Q; % 4.36
    end

    %Find and collect surveys where we have them, as well as relevant
    %coefficeints for fitted version
    cash_n=find(y_cash(:,t)~=0);
    infl_n=find(y_infl(:,t)~=0);
    inflQ_n=find(y_inflQ(:,t)~=0);
    inflLR_n=find(y_inflLR(:,t)~=0);
    
    cash=y_cash(cash_n,t);
    infl=y_infl(infl_n,t);
    inflQ=y_inflQ(inflQ_n,t);
    inflLR=y_inflLR(inflLR_n,t);

    cash_std=R_cash(cash_n);
    infl_std=R_infl(infl_n);
    inflQ_std=R_inflQ(inflQ_n);
    inflLR_std=R_inflLR(inflLR_n);
    
    % Intercept coeffcients
    atemp_cash=A_cash(cash_n,:);
    atemp_infl=A_infl(infl_n,:);
    atemp_inflQ=A_inflQ(inflQ_n,:);
    atemp_inflLR=A_inflLR(inflLR_n,:);
    % Slope coeffcients
    btemp_cash=b_cash(cash_n);
    btemp_infl=b_infl(infl_n);
    btemp_inflQ=b_inflQ(inflQ_n);
    btemp_inflLR=b_inflLR(inflLR_n);
    
    %Only take real observed and fitted coefficeints where we have an observed yield nearby
    inds_r= find(find_r(t,:)==1);
    y_r_cut=y_r(inds_r,t);
    J_r=size(y_r_cut,1);
    atemp_r=A_r(inds_r,:);
    btemp_r=b_r(inds_r);
    
    %Construct matrices for fitted values and observed
    y=[y_n(:,t); y_r_cut; cash; infl; inflQ; inflLR];
    A= [A_n; atemp_r; atemp_cash; atemp_infl; atemp_inflQ; atemp_inflLR];
    b= [b_n; btemp_r; btemp_cash; btemp_infl; btemp_inflQ; btemp_inflLR];
    R=[R_n*ones(1,q_n), R_r*ones(1,J_r), cash_std, infl_std, inflQ_std, inflLR_std];
    R= diag(R);
    
    % Fit y and step forward
    epst = (y - (A*x_tm1t(:,t) + b)); % 4.40
    Sigmat = A*P_tm1t(:,:,t)*A.' + R; % 4.41; 
    
    %Check invertability?
    if rank(Sigmat)<size(Sigmat)
        llks(t)=1e8;
    else
           
        %Update predictor
        K_t = P_tm1t(:,:,t)*A.'/Sigmat; % 4.39
        x_tt(:,t) = x_tm1t(:,t) + K_t*epst; % 4.37
        P_tt(:,:,t) = (Ip - K_t*A)*P_tm1t(:,:,t); % 4.38

        % NOTE: For strange parameters, we might have non-psd Sigmat which would be a problem
        term2 = log(det(Sigmat));
        term3 = max(epst.'*(Sigmat\epst),0);
    %     if ~isreal(term3) || ~isreal(term2), keyboard, end
        llks(t) = -size(y,1)/2*log(2*pi) - .5*term2 -.5*term3; % as in 4.67
    end
end

