%Function to citerate forward factors
%Jonathan Hambur October 2016

function fit_yrf=fit_fac(cP,K0P_cP,K1P_cP,mats_periods,N,t)

q=size(mats_periods,2);
int_yrf=zeros(t,N,max(mats_periods));
slope_yrf=zeros(t,N,max(mats_periods));
int_yrf(:,:,1)=zeros(t,N,1);
slope_yrf(:,:,1)=cP;
for i = 2 : max(mats_periods)
    int_yrf(:,:,i)=int_yrf(:,:,i-1)+ones(t,1)*(K0P_cP'*(K1P_cP+eye(N))'^(i-2));
    slope_yrf(:,:,i)=cP*(K1P_cP+eye(N))'^(i-1);
end
all_yrf=int_yrf+slope_yrf;

fit_yrf=zeros(t,N,q);
for i=1:q
    fit_yrf(:,:,i)=all_yrf(:,:,mats_periods(i));
end