%Function to calcualate fitted values of the expected future short-term
%rates for Hambur and Finlay (2018)

function fit_yrf=fit_short(cP,rho0_cP,rho1_cP,K0P_cP,K1P_cP,mats_periods,N,t)

% Inputs
% cP:    T*N     Factors
% K0P_cP     : N*1,      P-dynamics
% K1P_cP     : N*N,      P-dynamics
% mats    : 1*J,  maturities, in months 


%%
% Inital set-up
q=size(mats_periods,2); % Number of forecast periods
int_yrf=zeros(t,max(mats_periods)); % Matrix of intercepts
slope_yrf=zeros(t,max(mats_periods)); % Matrix of slope parameters
int_yrf(:,1)=ones(t,1)*rho0_cP; % Values for current period
slope_yrf(:,1)=cP*rho1_cP;
% Interate forward using the  P-dynamics - see Appendix B
for i = 2 : max(mats_periods)
    int_yrf(:,i)=int_yrf(:,i-1)+(K0P_cP'*(K1P_cP+eye(N))'^(i-2)*rho1_cP);
    slope_yrf(:,i)=cP*(K1P_cP+eye(N))'^(i-1)*rho1_cP;
end
all_yrf=int_yrf+slope_yrf; % All horizon forecast


% Pick out forecasts for relevant horizons
fit_yrf=zeros(t,q);
for i=1:q
    fit_yrf(:,i)=all_yrf(:,mats_periods(i));
end