
%This function is used to put some non-linear constraints on the
%optimisation for the Kalman filter for nominal model.
%One constraint is that the K1P_cP matrix has negative eigenvalues,
%which is needed for stationarity of the expected future interest rates.

function [c, ceq] = nonlconE_r(Z)

Small = -1e-10;
Large = -1+1e-10;

q=size(Z,1);
N=round(-5/6+sqrt(25/4-12/2*(1-q))/3); %using quadratic formula to get at nubmer of factors

try
    
    k1_p=reshape(Z(N+N*(N+1)/2+2+N:N+N*(N+1)/2+1+N+N^2),[N,N]);

    
    k1=eig(k1_p);

    
    out= sum(real(k1)>Small)+sum(real(k1)<Large);
    
    c=[];
    ceq= out;
    
catch ME
    save ME ME
    tmp = ME.stack.line;
    disp(['Line ' int2str(tmp) ': ' ME.message ' ' datestr(clock)])
    c = [];
    ceq = 1;
        
end