% This program converts coeffcieints to calculate x-peiod ahead inflation
% into expected inflation between two points, to match survey. For KF in
% Hambur and finlay (2018)
%The 'horizons' are when the relevant  inflation period ends. Calclauted from now to then.
%Jonathan Hambur October 2016

function [a,b] = infl_q_coeff(a_mon,b_mon, s_infl_hor,N)

%Inputs 
% a_mon:     1*F     intercept coefficients
% b_mon:     N*F     slope coefficients
% s_infl_hor 1*F     Horizons


[~, F] = size(s_infl_hor);

a=zeros(1,F);
b=zeros(N,F);


for j=1:F;
            a(1,j)=sum(a_mon(1,2:s_infl_hor(j)+1));
            b(:,j)=sum(b_mon(:,2:s_infl_hor(j)+1),2);

end

