%This is the log-likeihood function for th the cash rate for 
%  RDP Hambur and Finlay (2018)
% Forecasts are for period in future

function [llk, s_cash_std] = llk_fun_cash(yields, W, K1P_cP, K0P_cP, rho0_cP, rho1_cP, dt, surveys_cash, s_cash_hor, s_cash_std)

% INPUTS:
% W       : N*J,  weights for the yield portfolios measured without error
% yields  : T*J,  annualized zero coupon yields
% mats    : 1*J,  maturities, in years 
% dt      : scalar, time in years for each period
% K0P_cP     : N*1,      P-dynamics
% K1P_cP     : N*N,      P-dynamics
% s_cash     : T*F       Surveys
% s_cash_hor : 1*F       Survey horizons
% s_cash_std : scalar    Calibrated error variance (optional)
%

%   r(t) = rho0_cP + rho1_cP'*cPt - one period nominal rate


[t, ~] = size(yields);
[~, F] = size(surveys_cash);
N=size(W,1);

cP = yields*W'; % Observed factors.

s_cash_hor_p=round(s_cash_hor/dt); %horizon in months

max_for=max(s_cash_hor_p)+1; %longest horizon forecast - add one due to shift in fitting program

mats_all= 1:max_for; %Matrix with all the months we need fo making forecast equivalents to surveys

%Use calibrated or not?
if isempty(s_cash_std)
    calibrate=0;
else
    calibrate=1;
end

%% Log-liklihood function for forecasts of cash rate
yfit=zeros(t,F); % Matrix to store fitted values
yerr=zeros(t,F); % Matrix to store errors

ysum=zeros(1,F); %matrix to sum errors
ycount=zeros(1,F); %matrix to count errors for llk

yfit_all=fit_short(cP,rho0_cP,rho1_cP,K0P_cP,K1P_cP,mats_all,N,t); %monthly annualised nominal short rate


% For each period, iterate over the forecast horizons,
% picking out relevant forecast
for i=1:t
    for j=1:F;
        if surveys_cash(i,j)==0
        else
            yfit(i,j)=yfit_all(i,s_cash_hor_p(j)+1);
            yerr(i,j)=log(surveys_cash(i,j)+1)-yfit(i,j); % Calculate error - accounts for fact forecast in for 1+x, buy model in terms exp()
            if calibrate==1
                ysum(1,j)=ysum(1,j)+(yerr(i,j)).^2/(s_cash_std(j));
            end
            ycount(1,j)= ycount(1,j)+1;
        end
    end
end

% Calculate llk either using calibrated, or calculated variance
if calibrate==1
    llk=0.5*sum(ysum');
else 
    yerrsq=yerr.^2;
    s_cash_std=sqrt(sum(yerrsq(:))/sum(ycount(:)));
    llk=sum(0.5*sum(yerrsq.')/s_cash_std^2)+sum(ycount(:))*.5*((log(2*pi)+log(s_cash_std^2)));
end


