/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  **/
/*  April 2016. It creates a STATA database of the WPI micro **/
/*  data.                                                    **/

/**************************************************************/

clear all

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\jobdata"

use jobdata_master_final, clear

* Merge mujaa90 (edited job data) to jobdata (unedited job data)

cd "\\sasnasprd\SASData\W386\RBA\dta_files\mujaa90"

merge 1:1 merge_id surveyq using mujaa90_master
drop _merge

* Merge euewt90 (final matched sample file) to jobdata (unedited job data)

cd "\\sasnasprd\SASData\W386\RBA\dta_files\euewt90"

merge 1:1 merge_id surveyq using euewt90_master
drop _merge

gen merge_id_job = merge_id

* Merge empdata (unedited firm data) to job file

cd "\\sasnasprd\SASData\W386\RBA\dta_files\empdata"

replace merge_id=substr(merge_id,1,16)

merge m:1 merge_id surveyq using empdata_panel
tab surveyq _merge
drop if _merge==2
drop    _merge 

* Merge mueaa90 (edited firm data) to job file

cd "\\sasnasprd\SASData\W386\RBA\dta_files\mueaa90"

merge m:1 merge_id surveyq using mueaa90_panel
tab surveyq _merge
drop if _merge==2
drop    _merge merge_id
rename  merge_id_job merge_id

cd "\\sasnasprd\SASData\W386\RBA\dta_files\master"

save master, replace
clear

* end of do file
