/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  **/
/*  April 2016. It creates a STATA database of the WPI micro **/
/*  data.                                                    **/

/*  NB: Run extract_data.sas first                           **/
/**************************************************************/

clear all

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\mujaa90"


***************
* Only keep neccessary variables

foreach z in Mar Jun Sep Dec {

use mujaa90_`z', clear

/* Identify redundant jobs

   Use majaa90 rather than jobdata, because the former are more complete

  Extract relevant information from strings

* redun1: relates to cessation/redundancy of the entire job
* redun2: also includes cases where employee left and temporarily vacant

* Identify redundant jobs using Def/Nil indicators
* C - job ceased due to redundant, significant change in job task, etc.
* M - job ceased because created in error
* T - job vacant but likely to be filled in another quarter so only 'temporarily dead'
*/

gen     redun1 = 0
foreach x in dfnilcmt offcmt1 offcmt2 offcmt3 rspcmt1 rspcmt2 rspcmt3 rspcmt4 {
replace redun1 = 1 if defnilqt=="C" & (strpos(lower(`x'), "redundant")   | strpos(lower(`x'), "cease")              | strpos(lower(`x'), "closed")  | strpos(lower(`x'), "abolished")  /// 
                                     | strpos(lower(`x'), "restructure") | strpos(lower(`x'), "no longer required") | strpos(lower(`x'), "downsiz") | strpos(lower(`x'), "no longer exists") ///
                                     | strpos(lower(`x'), "closed down") | strpos(lower(`x'), "retrench")           | strpos(lower(`x'), "no longer filled"))
}
									 
gen     redun2 = redun1
foreach x in dfnilcmt offcmt1 offcmt2 offcmt3 rspcmt1 rspcmt2 rspcmt3 rspcmt4 {
replace redun2 = 1 if defnilqt=="C" & (strpos(lower(`x'), "terminate")	  | strpos(lower(`x'), "temp nil")		      | strpos(lower(`x'), "vacant")  | strpos(lower(`x'), "unoccupied")	///											 
									 | strpos(lower(`x'), "left")	      | strpos(lower(`x'), "resigned"))
replace redun2 = 1 if defnilqt=="T" & (strpos(lower(`x'), "terminate")	  | strpos(lower(`x'), "temp nil")		      | strpos(lower(`x'), "vacant")  | strpos(lower(`x'), "unoccupied")	///											 
									 | strpos(lower(`x'), "left")	      | strpos(lower(`x'), "resigned"))
}

gen exclude = 0
foreach x in dfnilcmt offcmt1 offcmt2 offcmt3 rspcmt1 rspcmt2 rspcmt3 rspcmt4 {								   
replace exclude = 1 if defnilqt=="C" & (strpos(lower(`x'), "duties")       | strpos(lower(`x'), "responsibility")     | strpos(lower(`x'), "role")               | strpos(lower(`x'), "not the same job")  /// 
									  | strpos(lower(`x'), "different")    | strpos(lower(`x'), "not doing same job") | strpos(lower(`x'), "invalid selection")  | strpos(lower(`x'), "change") ///
									  | strpos(lower(`x'), "new position") | strpos(lower(`x'), "reclassified")       | strpos(lower(`x'), "incorrect")          | strpos(lower(`x'), "wrong") ///
									  | strpos(lower(`x'), "error")        | strpos(lower(`x'), "duplicate")          | strpos(lower(`x'), " P/T ")              | strpos(lower(`x'), " F/T ") ///
									  | strpos(lower(`x'), " pt ")         | strpos(lower(`x'), " ft ")               | strpos(lower(`x'), "promoted")           | strpos(lower(`x'), "burden") ///
									  | strpos(lower(`x'), "scope")) 
}
	
replace redun1 = 0 if exclude ==1
replace redun2 = 0 if exclude ==1
*


gen     temp_dead=1 if defnilqt=="T"
replace temp_dead=. if strpos(lower(dfnilcmt), "leave")          | strpos(lower(dfnilcmt), "did not work") | strpos(lower(dfnilcmt), "did not wrk") | ///
                       strpos(lower(dfnilcmt), "still employed") | strpos(lower(dfnilcmt), "didnt work")   | strpos(lower(dfnilcmt), "didn't work") | ///
					   strpos(lower(dfnilcmt), "return")         | strpos(lower(dfnilcmt), "no hours")     | strpos(lower(dfnilcmt), "holiday")     | ///
					   strpos(lower(dfnilcmt), "lwop")           | strpos(lower(dfnilcmt), "lsl")          | strpos(lower(dfnilcmt), "no hrs")      | ///
					   strpos(lower(dfnilcmt), "not required")


#delimit ;

keep 

unitid 
psi 
defnilqt
dfnilcmt
ordge 
hordge 
reordge 
hreordge 
shfalw 
hshfalw 
totoalw 
htotoalw 
hdtalw 
hhdtalw 
basepay 
hbsep 
ordgefq 
ordgefqo 
ordgewk
stdhrsd 
ordhrsd 
ordhrswk 
pqhbsep 
q_4hbsep 
pmekflg 
pmekcmt 
payfreq 
payfreqo 
payhour 
payann 
pti 
casload
ftptflg
signiflg 
signiflg_score 
signiflg_cutoff 
imprc 
splice 
splicerc
survey
redun1
redun2
changeei
vpayflg
temp_dead;

#delimit cr


*
* Variable that will be used to merge to jobdata and empdata
gen merge_id = unitid

* Survey year/quarter variables
gen quarter = substr(survey,1,3)
gen year    = substr(survey,4,2)
drop survey

destring year, replace
replace  year=year+1900 if year>=96 & year<=99
replace  year=year+2000 if year >=0 & year<=20

replace  quarter="1" if quarter=="Mar"
replace  quarter="2" if quarter=="Jun"
replace  quarter="3" if quarter=="Sep"
replace  quarter="4" if quarter=="Dec"
destring quarter, replace

gen surveyq = yq(year, quarter)
format surveyq %tq

save mujaa90_`z'_temp, replace

clear
}
*



