/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  
    April 2016. 
    It appends the quarterly empdata files, seperately for   
    each survey quarter                                     
***************************************************************/

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\empdata"

* append quarterly files together

  use Mar16dta, clear
  quietly compress
  gen survey =  "Mar16"
  save empdata_Mar, replace
  clear
  erase Mar16dta.dta

  foreach x in 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 {
    use Mar`x'dta, clear
    quietly compress
    append using empdata_Mar
	replace survey = "Mar`x'" if survey==""
    save empdata_Mar, replace
    clear
	erase Mar`x'dta.dta
}
*

foreach q in Jun  {

  use `q'16dta, clear
  quietly compress
  gen survey =  "`q'16"
  save empdata_`q', replace
  clear
  erase `q'16dta.dta

  foreach x in 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 98 {
    use `q'`x'dta, clear
    quietly compress
    append using empdata_`q'
	replace survey = "`q'`x'" if survey==""
    save empdata_`q', replace
    clear
	erase `q'`x'dta.dta
}
}
*

foreach q in Sep Dec {

  use `q'15dta, clear
  quietly compress
  gen survey =  "`q'15"
  save empdata_`q', replace
  clear
  erase `q'15dta.dta

  foreach x in 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 98 {
    use `q'`x'dta, clear
    quietly compress
    append using empdata_`q'
	replace survey = "`q'`x'" if survey==""
    save empdata_`q', replace
    clear
	erase `q'`x'dta.dta
}
}
*

* end of do file
