/**************************************************************
 This program uses data on award classifications from the FWO to construct Figure 1
 **************************************************************/

clear all

/*Import Classifications Data from FWO

 Data contains: 
 
 An extract of the base rates for the approximately 1,500 awards as at 31 Dec 2009 
 (capturing the last annual wage review prior to the introduction of the MAs and the 
 transitional system). 
 
 An extract of the base rates for the 122 modern awards as at 1 July 2014 (post 
 transition).
 
 Classification mappings between the two data sets.
 
 Please note that the classification mapping will not be complete  FWA provided some 
 initial guidance on classification translation in 2010, and the FWO used this as a 
 baseline and did additional work when developing PayCheck Plus. The classification 
 mapping we have done was designed to address the majority of workers so it is 
 comprehensive, but it is not complete. While sometimes there is a direct correspondence 
 between, for example, a level 2 in a PMA and a level 2 in a MA, this is not always the case. 
 
 
 Some MAs do not map to PMAs (e.g. the Black Coal Mining Award).
 
   Variables include:
 
     Classification ID: a system generated number. It as useful when, for example, youre 
     looking at multiple PMA classifications mapping to the same MA classification. 

	 The description and classification level, and any sub-levels (for example, juniors 
	 have age sub-levels)
	 
	 State in which the PMA operated (note: AO is the State when the PMA operated in 
	 multiple or all States).
	 
	 Base rate of pay: the hourly rate derived from the award. The only allowance that 
	 has been added to the base rate is any allowance that would apply to all employees 
	 for all purposes. This may be expressed in the award as an all up, all purpose, 
	 or industry allowance. Where the allowance is not expressed to apply to all employees 
	 (e.g., an industry allowance that applies to employees performing a particular role, 
	 or under certain conditions) it has not been added to the base rate.
	 	 
	 Casual rate: has the casual loading factored into the base rate */

cd "G:\Research\JamesB\ABS_project\data\FWO\PCS Data Extract for James Bishop"

import excel using "PCS Classification Data Extract for James Bishop - 14-01-2015.xlsx", firstrow sheet("Classification Mapping")

rename MACode                         ma_code
rename MAIndustrialInstrumentTitle    ma_name
rename MAClassificationId             ma_id
rename MAClassificationWageCategory   ma_catg
rename MAClassificationDescription    ma_clas
rename MALevelDescription             ma_lev
rename MASubLevelDescription1         ma_sublev1
rename MASubLevelDescription2         ma_sublev2
rename MASubLevelDescription3         ma_sublev3 
rename MASubLevelDescription4         ma_sublev4 
rename MASubLevelDescription5         ma_sublev5 
rename L                              ma_ftrate_1jul14
rename M                              ma_ptrate_1jul14
rename MAPartTimeQualifier            ma_ptqual
rename O                              ma_csrate_1jul14
rename MACasualQualifier              ma_csqual 
rename Code                           pm_code
rename IndustrialInstrumentTitle      pm_name 
rename ClassificationId               pm_id 
rename ClassificationDescription      pm_clas 
rename ClassificationWageCategory     pm_catg 
rename ClassificationState            pm_state 
rename LevelDescription               pm_lev 
rename SubLevelDescription1           pm_sublev1 
rename SubLevelDescription2           pm_sublev2 
rename SubLevelDescription3           pm_sublev3 
rename SubLevelDescription4           pm_sublev4 
rename SubLevelDescription5           pm_sublev5 
rename AC                             pm_ftrate_31dec09 
rename AD                             pm_ptrate_31dec09  
rename PartTimeQualifier              pm_ptqual 
rename AF                             pm_csrate_31dec09   
rename CasualQualifier                pm_csqual 

compress 

* Type of award
gen pm_type = substr(pm_code,1,2)
tab pm_type
replace pm_type="NAPSA"      if pm_type=="AN"
replace pm_type="Pre reform" if pm_type=="AP"


/*
In some cases, an adult rate is mapped to a junior rate etc. 

 The FWO indicated that this can lead to large differences between the PMA and the MA. It 
 could be that no junior classification existed under the PMA that matched the MA 
 classification, which could indicate that the role under the PMA for that State was not 
 performed by a junior.
 
 Drop these cases
*/

tab     ma_catg  pm_catg
keep if ma_catg==pm_catg


drop ma_id
duplicates drop ma_*, force

* Extend to 1 July 2017
gen ma_ftrate_1jul17 = ma_ftrate_1jul14 * 1.025 * 1.024 * 1.033

* replace ma rate with FMW is ma rate < FMW
replace ma_ftrate_1jul17 = 18.29 if ma_ftrate_1jul17<=18.29 & ma_ftrate_1jul17!=.

twoway__histogram_gen ma_ftrate_1jul17  if ma_ftrate_1jul17<=60  & ma_catg=="Adult", generate(bin_height bin_centre) start(18) width(1)

keep    bin_height bin_centre
keep if bin_height!=.

* end of do file
