/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  **/
/*  April 2016. It creates a STATA database of the WPI micro **/
/*  data.                                                    **/

/*  NB: Run extract_data.sas first                           **/
/**************************************************************/

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\jobdata"


* unitid naming conventions changed from 2003q3 (moved to AT, MU prefix). 
* Change historical data so that only one unitid relates to any single job

use unitid old_unit using jobdata_Mar, clear
keep if old_unit!=""
duplicates drop
rename  unitid   unitid_future
rename  old_unit unitid 
save unitid_historic_jobdata, replace
clear

foreach c in Jun Sep Dec {
use unitid old_unit using jobdata_`c', clear
keep if old_unit!=""
duplicates drop
rename  unitid   unitid_future
rename  old_unit unitid 
append using unitid_historic_jobdata
duplicates drop
save unitid_historic_jobdata, replace
clear
}
*

***************
* Dump useful strings in another file 
foreach z in Mar Jun Sep Dec {

use unitid survey offcmt* offcmtd rspcmt* rspjbid* jobtitle jobgrade jobtskl* jobfdbk* pmekflg pmekcmt chgpeba chgpind chgprev using jobdata_`z', clear

gen quarter = substr(survey,1,3)
gen year    = substr(survey,4,2)
drop survey

destring year, replace
replace  year=year+1900 if year>=96 & year<=99
replace  year=year+2000 if year >=0 & year<=20

replace  quarter="1" if quarter=="Mar"
replace  quarter="2" if quarter=="Jun"
replace  quarter="3" if quarter=="Sep"
replace  quarter="4" if quarter=="Dec"
destring quarter, replace

gen surveyq = yq(year, quarter)
format surveyq %tq

gen     post_2006q4 = 0 
replace post_2006q4 = 1 if surveyq>=tq(2007q1)

compress

save jobdata_`z'_string, replace
clear
}
use jobdata_Mar_string, clear
append using jobdata_Jun_string
append using jobdata_Sep_string
append using jobdata_Dec_string

compress
save jobdata_string, replace



***************
* Drop unecessary variables

foreach z in Mar Jun Sep Dec {

use jobdata_`z', clear

#delimit ;

drop 

pid
cid
state_of
response
delete_f
date_la0
export_c
date_la1
import_c
usi_sour
usi_feed
usi_regi
usi_resp
usi_dacc
usi_esti
usi_sel_
chkdigit
unitflg
offcmt1
offcmt2
offcmt3
offcmtd
rspcmt1
rspcmt2
rspcmt3
rspcmt4
editflg
person
bundno
formtype
attflg
attcmt
rspjbid1
rspjbid2
jobfdbk
jobfdbki
wkstdrc
salsac
piecewk
ordgewk
ordgerc1
ordgerc2
hdtalwrc
shfalwrc
bonmth
bonmthrc
bonqtr
bonqtrrc
bonbia
bonbiarc
bonann
bonannrc
bonoth
bonothfq
bonothw
bonothrc
bonwk
bonwkrc
bonft
bonftrc
bonpaid
bonsplc
bonwkcom
bonwkbon
bonftcom
bonftbon
bonmthcm
bonmthbn
bonqtrcm
bonqtrbn
bonbiacm
bonbiabn
bonanncm
bonannbn
bonothcm
bonothbn
bonsplrc
bonsplfl
splicerc
splice
splcfwd
oalw1rc
oalw2rc
oalw3rc
oalw1des
oalw2des
oalw3des
voalw
voalwdes
voalwrc
vprov_1
vstdhr_1
stdhrs_1
stdmin_1
vcheck
abn
alind
alrc
alamtwks
alamthrs
alamtmin
alamtdec
alspind
alspl
alsplrc
supind
suprc
supemppc
supempam
dbind
dbrate
supspind
supspl
supsplrc
supeepct
supeeamt
supcomm1
supcomm2
supcomm3
rf_db_y
sgind
alcomm1
alcomm2
alcomm3
acflag
datemarkin
formamended
vdesc1
vdesc2
vdesc3
vdesc4
vhrdsc1
vhrdsc2
vhrdsc3
vhrdsc4 
formpsi 
ipsform
payoth
payothfq
newunemp;

#delimit cr


* Variable that will be used to merge to empdata
gen merge_id = unitid

* Replace the historical unitid with the updated version, where relevant
merge m:1 unitid using unitid_historic_jobdata
drop if _merge==2
drop    _merge
replace unitid=unitid_future if unitid_future!=""
drop unitid_future old_unit old_dig

* Survey year/quarter variables
gen quarter = substr(survey,1,3)
gen year    = substr(survey,4,2)
drop survey

destring year, replace
replace  year=year+1900 if year>=96 & year<=99
replace  year=year+2000 if year >=0 & year<=20

replace  quarter="1" if quarter=="Mar"
replace  quarter="2" if quarter=="Jun"
replace  quarter="3" if quarter=="Sep"
replace  quarter="4" if quarter=="Dec"
destring quarter, replace

gen surveyq = yq(year, quarter)
format surveyq %tq

save jobdata_`z'_temp, replace

* Dump all the award-identifying information in another file (for memory considerations)
keep unitid surveyq jobtitle jobgrade jobloc jobtskl* pmekflg pmekcmt 
save jobinfo_`z', replace

use  jobdata_`z'_temp
drop jobtitle jobgrade jobloc jobtskl*
save jobdata_`z'_temp, replace
clear
}
*

* end of do file
