/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  **/
/*  April 2016. It creates a STATA database of the WPI micro **/
/*  data.                                                    **/

/**************************************************************/

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\mueaa90"

***************
* Only keep neccessary variables

foreach z in Mar Jun Sep Dec {

use mueaa90_`z', clear

#delimit ;

keep 

unitid 
ruid
psi 
dateload 
dateamnd 
defnilqt 
dfnilcmt 
totempee 
toemdate 
totemp_1
name1
name2
sector 
industry 
dateocc 
c_status 
seatemp 
abn 
seas_emp 
industry06 
repempee 
survey;

#delimit cr


*
* Variable that will be used to merge to jobdata and empdata
replace unitid = ruid if unitid!=ruid
gen merge_id   = unitid
drop ruid

* Survey year/quarter variables
gen quarter = substr(survey,1,3)
gen year    = substr(survey,4,2)
drop survey

destring year, replace
replace  year=year+1900 if year>=96 & year<=99
replace  year=year+2000 if year >=0 & year<=20

replace  quarter="1" if quarter=="Mar"
replace  quarter="2" if quarter=="Jun"
replace  quarter="3" if quarter=="Sep"
replace  quarter="4" if quarter=="Dec"
destring quarter, replace

gen surveyq = yq(year, quarter)
format surveyq %tq

save mueaa90_`z'_temp, replace

clear
}
*

* append files together
use mueaa90_Mar_temp, clear
append using mueaa90_Jun_temp
append using mueaa90_Sep_temp
append using mueaa90_Dec_temp


format psi %10.0g
format abn totempee totemp_1 %15.0g

sort unitid surveyq

* Employment, excluding seasonal and temporary

rename dateload date_loa
rename dateamnd date_las

gen     empl = .
replace empl = totempee if totempee>=0 & toemdate>=date_loa & toemdate<=date_las & (toemdate!=. & date_loa!=. & date_las!=.)
replace empl = totempee if totempee>=0 & toemdate==date_loa                      & (toemdate!=. & date_loa!=. & date_las==.)

/*
The above measure of employment will only have non-missing in quarters in which employment data are newly updated. 
In general, this is the September quarter (see tabulations below). There are some non-missing employment
data in other quarters given that employment is also collected upon initialisation and sometimes in a later quarter
if the firm does not respond to the employment questions in September.
*/
gen     empl_nonmiss = 0
replace empl_nonmiss = 1 if empl!=.
tab     empl_nonmiss quarter

* Employment, including seasonal and temporary
gen     empl_st =  empl + seas_emp
replace empl_st =  repempee if empl_st==. & totempee>=0 & toemdate>=date_loa & toemdate<=date_las & (toemdate!=. & date_loa!=. & date_las!=.) 
replace empl_st =  repempee if empl_st==. & totempee>=0 & toemdate==date_loa                      & (toemdate!=. & date_loa!=. & date_las==.)

/*
renempee = totempee + seas_emp 
 
 Prior to 2003q3 instead of asking for the specific number of seasonal/temp employes, we asked a more general 
 question about  what percentage of the total employees were seasonal/temp (over 10%, up to 10% or Nil). 'seatemp'
 Totempee should always have excluded seasonal/temp employees but it looks like previously we altered the figure 
 manually rather than calculating it in the system.
*/

/**************************************************************
 Sector (not available in empdata)
 
 1 - private
 
 3 - public, Commonwealth
		All public sector units controlled by the Australian Government, including 
		(i)   Government units controlled by the Australian Government, 
		(ii)  Public financial corporations controlled by the Australian Government, 
		(iii) Public non-financial corporations controlled by the Australian Government

 4 - public, State
		All public sector units controlled by state / territory governments, similar to 
		(i)-(iii) above
 
 5 - public, Local
		All public sector units controlled by a local government i.e. councils
 
 http://www.abs.gov.au/ausstats/abs@.nsf/Lookup/E6FFA0D1E4D74798CA257BDD001164F0?opendocument
  
 **************************************************************/

gen     public = 0 if sector!=. 
replace public = 1 if sector==3 | sector==4 | sector==5     
 
gen     public_cwh = 0 if sector!=. 
replace public_cwh = 1 if sector==3    

gen     public_sta = 0 if sector!=. 
replace public_sta = 1 if sector==4    

gen     public_loc = 0 if sector!=. 
replace public_loc = 1 if sector==5

* keep only relevant variables
keep  merge_id surveyq empl empl_st public public_cwh public_sta public_loc defnilqt dfnilcmt
order merge_id surveyq empl empl_st public public_cwh public_sta public_loc defnilqt dfnilcmt
 
 * Give all firm-level variables from mueaa90 an e_ prefix
foreach var of varlist _all {
rename `var' e_`var'
}
*
rename e_surveyq  surveyq
rename e_merge_id merge_id

sort merge_id surveyq

* generate a variable for the quarter of firm death

gen exclude = 1 if strpos(lower(e_dfnilcmt), "unit rolled forward as frame death") | strpos(lower(e_dfnilcmt), "duplicate") | strpos(lower(e_dfnilcmt), "split")  | ///
                   strpos(lower(e_dfnilcmt), "incorrect") | strpos(lower(e_dfnilcmt), "error") | strpos(lower(e_dfnilcmt), "proxy")  | strpos(lower(e_dfnilcmt), "out of scope")

gen      e_death_qtr = .
replace  e_death_qtr = 1 if e_defnilqt=="D" & exclude!=1

gen      e_death_qtrXsurveyq = e_death_qtr*surveyq

bysort merge_id: egen e_death_qtrXsurveyq_min = min(e_death_qtrXsurveyq)

drop e_defnilqt e_death_qtr e_death_qtrXsurveyq exclude e_dfnilcmt

rename e_death_qtrXsurveyq_min e_death_qtr

format e_death_qtr %tq

tab e_death_qtr 

replace e_death_qtr = . if e_death_qtr==tq(1998q2)

sort merge_id surveyq

save mueaa90_panel, replace

clear

* end of do file
