/*******************************************************************************

	8_graphs.do
	
	This file contains code to generate data for Figures 3 and 6 in Bishop J and
	I Chan (2019), Is Declining Union Membership Contributing to Low Wages
	Growth?, RBA Research Discussion Paper No 2019-02.
		
*******************************************************************************/

clear all
set more off   
set maxvar 10000

local dir  "<path for 'data' folder here>"

cd "`dir'"

/* Measures the AAWI per employee for all quantifiable federal wage agreements that are current on the final day of the quarter (i.e. neither terminated nor expired)

   For graphs, follow DOE definition of 'current' (i.e. certified but not yet expired or terminated)

   An agreement that expires on a given date is deemed to be current on that date. */

use wad_extract_final_RDP, clear

gen first = cert_date
gen last  = min(term_date, expi_date) 

format first %td
format last  %td

foreach h in first last {
gen `h'_qy = yq(year(`h'), quarter(`h'))
format `h'_qy %tq
}
*
* if start date is after finish date, set finish date to start date

gen duration_qy=last_qy-first_qy
replace last_qy=first_qy if duration_qy<0

* Generate dummies for agreements still active on the final day of the quarter

forvalues z = 1991(1)2017 {

foreach c in jun sep {
  gen active_`c'`z' = 0 
  replace active_`c'`z' = 1 if first<=td(30`c'`z') & last>=td(30`c'`z') & first!=. & last!=.
 }
foreach p in mar dec {
  gen active_`p'`z' = 0 
  replace active_`p'`z' = 1 if first<=td(31`p'`z') & last>=td(31`p'`z') & first!=. & last!=.
 }
}
*

* Construct data for Fig 3 and 6 (stock measures)

matrix C = J(108,6,0)
matrix colnames C = un_share_ag un_share_emp aawi_pr_n aawi_pr_u aawi_pu_n aawi_pu_u  
matrix rownames C = Mar1991 Jun1991 Sep1991 Dec1991 Mar1992 Jun1992 Sep1992 Dec1992 Mar1993 Jun1993 Sep1993 Dec1993 Mar1994 Jun1994 Sep1994 Dec1994 ///
                    Mar1995 Jun1995 Sep1995 Dec1995 Mar1996 Jun1996 Sep1996 Dec1996 Mar1997 Jun1997 Sep1997 Dec1997 Mar1998 Jun1998 Sep1998 Dec1998 ///
                    Mar1999 Jun1999 Sep1999 Dec1999 Mar2000 Jun2000 Sep2000 Dec2000 Mar2001 Jun2001 Sep2001 Dec2001 Mar2002 Jun2002 Sep2002 Dec2002 ///
					Mar2003 Jun2003 Sep2003 Dec2003 ///
                    Mar2004 Jun2004 Sep2004 Dec2004 Mar2005 Jun2005 Sep2005 Dec2005 Mar2006 Jun2006 Sep2006 Dec2006 Mar2007 Jun2007 Sep2007 Dec2007 ///
                    Mar2008 Jun2008 Sep2008 Dec2008 Mar2009 Jun2009 Sep2009 Dec2009 Mar2010 Jun2010 Sep2010 Dec2010 Mar2011 Jun2011 Sep2011 Dec2011 ///
					Mar2012 Jun2012 Sep2012 Dec2012 Mar2013 Jun2013 Sep2013 Dec2013 Mar2014 Jun2014 Sep2014 Dec2014 Mar2015 Jun2015 Sep2015 Dec2015 ///
					Mar2016 Jun2016 Sep2016 Dec2016 Mar2017 Jun2017 Sep2017 Dec2017 
		
local j = 1

foreach q in mar jun sep dec {

local i = `j'

forvalues z = 1991(1)2017 {
qui sum union if active_`q'`z'==1              
matrix C[`i',1]=r(mean)
qui sum union if active_`q'`z'==1                                 [weight=employees_combined] 
matrix C[`i',2]=r(mean)
qui sum aawi if active_`q'`z'==1 & aawi!=. & union==0 & public==0 [weight=employees_combined] 
matrix C[`i',3]=r(mean)
qui sum aawi if active_`q'`z'==1 & aawi!=. & union==1 & public==0 [weight=employees_combined] 
matrix C[`i',4]=r(mean)
qui sum aawi if active_`q'`z'==1 & aawi!=. & union==0 & public==1 [weight=employees_combined] 
matrix C[`i',5]=r(mean)
qui sum aawi if active_`q'`z'==1 & aawi!=. & union==1 & public==1 [weight=employees_combined] 
matrix C[`i',6]=r(mean)
local i = `i'+4
}
local j = `j'+1
}

* Output data for Figure 6 and RH panel of Figure 3

putexcel A1=matrix(C, names) using current_ag_output, replace

* LH panel of Figure 3 (hardpaste)

tabstat union                             , by(first_qy)
tabstat union  [weight=employees_combined], by(first_qy)

* end of do file
