% Generate cells for Macro and Financial data from xlsx files. 
% Last modified by Dora Xia March 24, 2017

clc
close all
clear all
addpath(genpath('./function')); 

MacroFin_data = cell(1,36); 
MacroFin_name = cell(1,36); 
%% global variables
FileName = '../data/global_dora.xlsx'; 
[~,Sheets] = xlsfinfo(FileName); 
for l = 1:2
    z = xlsread(FileName,Sheets{l});
    D = z(:,1); data_out = padding(z(:,end));  
    MacroFin_name{l} = Sheets{l}; 
    MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out;
end
l = 3; 
load data_M.mat
D = T(2:end); 
data_temp = squeeze(data_M(:,end,1)); data_num = padding(data_temp); data_temp = data_temp(2:end) - data_num(1:end-1); data_out = padding(data_temp)*100; 
MacroFin_name{l} = '10y Treasury yield'; 
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out;
%% financial variables
l = 4; 
load data_M.mat
D = T; data_out = squeeze(data_M(:,end,:)); 
b = xlsread('../data/CountryOrder_alpha.xlsx'); data_out = data_out(:,b);
data_out = padding(data_out); 
MacroFin_name{l} = '10y yield';
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out;

FileName = '../data/countryfinancial_dora.xlsx'; 
[~,Sheets] = xlsfinfo(FileName); 
for l = 1:3 
    z = xlsread(FileName,Sheets{l});
    D = z(:,1); data_out = z(:,3:end); 
    if l == 3
        data_out = padding(data_out);
    end
    MacroFin_name{l+4} = Sheets{l};   
    MacroFin_data{l+4}.D = D; MacroFin_data{l+4}.data_out = data_out;
end
%% Financial openness variables
l = 8; 
CountryMatch = xlsread('../data/Copy of kaopen_2014_dora.xls','Sheet2'); CountryMatch = [CountryMatch(:,1) CountryMatch(:,4)]; CountryMatch = CountryMatch(1:54,:); 
z = xlsread('../data/Copy of kaopen_2014_dora.xls','Sheet1');
D = NaN(45,1); data_out = NaN(45,54); 
for t = 1970:1:2014    
    ind_1 = find(z(:,4)==t,1,'first'); ind_2 = find(z(:,4)==t,1,'last'); 
    data = z(ind_1:ind_2,:); 
    [~,locb] = ismember(CountryMatch(:,2),data(:,1)); 
    D(t-1970+1) = t*10000+1200+31;  
    for j = 1:length(locb)
        if locb(j) ~= 0
            data_out(t-1970+1,j) = data(locb(j),5);
        end
    end  
end
MacroFin_name{l} = 'Chinn-Ito Index'; 
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out;

z = xlsread('../data/EWN19702015_dora.xls','data') ;
z(1:2,:) = []; 
NameString = {'Portfolio Equity Assets','Portfolio Equity Liabilities','FDI Assets','FDI Liabilities', 'Portfolio Debt Assets', 'Portfolio Debt Liabilities', 'Financial Derivatives Assets', 'Financial Derivative Liabilities'}; 
Country_index = xlsread('../data/EWN19702015_dora.xls','CountryIndex');
Equity_temp = []; FDI_temp = []; Debt_temp = []; FinDer_temp = []; GDP_temp = []; 
for i = 1:54
    ind1 = find(z(:,1)==Country_index(i),1,'first'); ind2 = find(z(:,1)==Country_index(i),1,'last'); 
    if (ind2-ind1+1) ~= 46
        i
    else
        Equity_temp = [Equity_temp z(ind1:ind2,3:4)]; FDI_temp = [FDI_temp z(ind1:ind2,5:6)]; Debt_temp = [Debt_temp z(ind1:ind2,7:8)]; FinDer_temp = [FinDer_temp z(ind1:ind2,9:10)]; 
        GDP_temp = [GDP_temp z(ind1:ind2,17)];
    end 
end
D = [1970:1:2015]*10000+12*100+30; D = D';
data_out_temp = NaN(46,54,8); 
data_out_temp(:,:,1) = Equity_temp(:,1:2:end); data_out_temp(:,:,2) = Equity_temp(:,2:2:end); 
data_out_temp(:,:,3) = FDI_temp(:,1:2:end); data_out_temp(:,:,4) = FDI_temp(:,2:2:end); 
data_out_temp(:,:,5) = Debt_temp(:,1:2:end); data_out_temp(:,:,6) = Debt_temp(:,2:2:end); 
data_out_temp(:,:,7) = FinDer_temp(:,1:2:end); data_out_temp(:,:,8) = FinDer_temp(:,2:2:end); 
for l = 1:8
    data_out = data_out_temp(:,:,l); data_out = data_out./GDP_temp*100; 
    MacroFin_name{l+8} = NameString{l}; 
    MacroFin_data{l+8}.D = D; MacroFin_data{l+8}.data_out = data_out;  
end
%% macro variables
FileName = '../data/macro_final_dora.xlsx'; 
[~,Sheets] = xlsfinfo(FileName); 
for l = 1:8    
    z = xlsread(FileName,Sheets{l});
    D = z(:,1); data_out = padding(z(:,3:end));  
    MacroFin_name{l+16} = Sheets{l};   
    MacroFin_data{l+16}.D = D; MacroFin_data{l+16}.data_out = data_out;
end
GDP = MacroFin_data{24}.data_out; GDP = GDP(31:end-1,:); % from 2000 to 2015
for l = 9:10   
    z = xlsread(FileName,Sheets{l});
    D = z(:,1); data = z(:,3:end);
    data_out = NaN(54,7,length(D));
    for j = 1:7
        data_temp = data(:,j:7:end);
        for t = 1:length(D)
            data_out(:,j,t) = data_temp(t,:)'./GDP(t,:)'/1000*100;
        end
    end
    MacroFin_name{l+22} = Sheets{l};
    MacroFin_data{l+22}.D = D; MacroFin_data{l+22}.data_out = data_out;   
end
%% bilateral financial relation data
GDP = MacroFin_data{24}.data_out; GDP = GDP(31:end,:); % from 2000 to 2016
l = 25; 
z = xlsread('../data/borrowingInGlobalFundingCur_20170323_dora.xlsx','data') ;
b = xlsread('../data/borrowingInGlobalFundingCur_20170323_dora.xlsx','order') ;
D = z(:,1); data = z(:,8:end); 
data_out = NaN(54,7,length(D));
ind = [7;3;4;5;6];
for j = 1:5
    data_temp = data(:,j:5:end);
    for i = 1:54
        if ~isnan(b(i))
            for t = 1:length(D)
                data_out(i,ind(j),t) = data_temp(t,b(i))/GDP(ceil(t/4),i)/1000*100;
            end
        end
    end
end
MacroFin_name{l} = 'Foreign currency debt';
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out;

GDP = MacroFin_data{24}.data_out; GDP = GDP([32;38;46],:); % 2001; 2007 and 2015
l = 26;
data_out = NaN(54,54,3,2);
sheetname = {'FDI2001';'FDI2007';'FDI2015'};
for t = 1:1:3
    z = xlsread('../data/bilateral_financial_dora.xlsx',sheetname{t}); 
    for i = 1:54
        for j = 1:54
            ind_1 = find(z(:,2)==i); ind_2 = find(z(:,3)==j); ind = intersect(ind_1,ind_2);
            if ~isempty(ind)
                data_out(i,j,t,1) = z(ind,1)/GDP(t,i)*100;
                data_out(i,j,t,2) = z(ind,1)/GDP(t,j)*100;
            end
        end
    end
end
MacroFin_name{l} = 'FDI';
MacroFin_data{l}.D = [20011231; 20071231; 20151231]; MacroFin_data{l}.data_out = data_out; 

GDP = MacroFin_data{24}.data_out; GDP = GDP(32:46,:); % from 2001 to 2015
l = 27;
data_out = NaN(54,54,15,2);
z = xlsread('../data/bilateral_financial_dora.xlsx','PDebt');
for t = 1:15
    for i = 1:54
        for j = 1:54
            ind_1 = find(z(:,end-1)==i); ind_2 = find(z(:,end)==j); ind = intersect(ind_1,ind_2);
            if ~isempty(ind)
                data_out(i,j,t,1) = z(ind,t)/GDP(t,i)*100;
                data_out(i,j,t,2) = z(ind,t)/GDP(t,j)*100;
            end
        end
    end
end
D = [2001:2015]'*10000+1200+31; 
MacroFin_name{l} = 'Portfolio Debt';
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out; 

l = 28;
data_out = NaN(54,54,15,2);
z = xlsread('../data/bilateral_financial_dora.xlsx','PEquity');
for t = 1:15
    for i = 1:54
        for j = 1:54
            ind_1 = find(z(:,end-1)==i); ind_2 = find(z(:,end)==j); ind = intersect(ind_1,ind_2);
            if ~isempty(ind)
                data_out(i,j,t,1) = z(ind,t)/GDP(t,i)*100;
                data_out(i,j,t,2) = z(ind,t)/GDP(t,j)*100;
            end
        end
    end
end
D = [2001:2015]'*10000+1200+31; 
MacroFin_name{l} = 'Portfolio Equity';
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out; 

l = 29;
data_out = NaN(54,54,15,2);
z = xlsread('../data/bilateral_financial_dora.xlsx','Loans');
for t = 1:15
    for i = 1:54
        for j = 1:54
            ind_1 = find(z(:,end-1)==i); ind_2 = find(z(:,end)==j); ind = intersect(ind_1,ind_2);
            if ~isempty(ind)
                data_out(i,j,t,1) = z(ind,t)/GDP(t,i)*100;
                data_out(i,j,t,2) = z(ind,t)/GDP(t,j)*100;
            end
        end
    end
end
D = [2001:2015]'*10000+1200+31; 
MacroFin_name{l} = 'Loans';
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out; 

l = 30; 
z = xlsread('../data/fxrates_dora.xlsx','data');  
D = z(:,1); z = z(:,3:end); 
z_num = padding(z); 
D = D(2:end); fx_chg = (z(2:end,:)./z_num(1:end-1,:)-1)*100; fx_vol = NaN(size(fx_chg));
for t = 365:length(D)
    fx_chg_temp = fx_chg(t-364:t,:).^2;
    fx_vol(t,:) = sqrt(nanmean(fx_chg_temp));
end
data_out = NaN(length(D), 54, 7); 
for i = 1:7
    data_out(:,:,i) = fx_vol(:,(i-1)*54+1:(i-1)*54+54); 
end
load ind_EU.mat
data_out(:,ind_EU,3)=0; 
MacroFin_name{l} = 'FX_vol';
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out; 
%% Trade model data
l = 33; 
MacroFin_name{l} = 'Trade model variables';
z = xlsread('../data/countryspecific_dora.xlsx','countryspec');
z(1:2,:) = []; 
country_o = z(:,1); country_d = z(:,2); time = z(:,3); data = z(:,4:end); data = data(:,[3;6;15;47]);  

data_out = NaN(54,54,4,16);
[~,ind_1] = unique(time,'first'); [~,ind_2] = unique(time,'last');
for t = 1:16
    data_temp = data(ind_1(t):ind_2(t),:);
    country_d_temp = country_d(ind_1(t):ind_2(t)); 
    for i = 1:54
        data_temp_temp = data_temp((i-1)*54+1:(i-1)*54+54,:);
        country_d_temp_temp = country_d_temp((i-1)*54+1:(i-1)*54+54); 
        [~,loc] = sort(country_d_temp_temp);
        for j = 1:54
            for k = 1:4
                data_out(i,j,k,t) = data_temp_temp(loc(j),k);
            end
        end
    end
end
D = [2000:2015]'*10000+1200+31;
MacroFin_data{l}.D = D; MacroFin_data{l}.data_out = data_out; 
save MacroFin.mat MacroFin_name MacroFin_data
%% inflation and growth correlation
clc
close all
clear all

load MacroFin.mat

FileName = '../data/macro_final_long_dora.xlsx'; 
z = xlsread(FileName,'cpi_pctNEW'); 
D = z(:,1); z = z(:,3:end); 
data_out = NaN(54,7,length(D)); 
ind_originator = [4;7;13;27;8;19;51]; 
for t = 80:1:length(D)
    for i = 1:54
        for j = 1:7
            data_out(i,j,t) = [0 1]*corrcoef(z(t-79:t,i),z(t-79:t,ind_originator(j)))*[1;0];
        end
    end
end
MacroFin_name{34} = 'CPI correlation';
MacroFin_data{34}.D = D; MacroFin_data{34}.data_out = data_out;  

z = xlsread(FileName,'realGDP_pctNEW'); 
D = z(:,1); z = z(:,3:end); 
data_out = NaN(54,7,length(D)); 
ind_originator = [4;7;13;27;8;19;51]; 
% generate annual GDP series for originator countries
data_originator_annual = NaN(length(D),7);
data_originator_annual = z(4:end,ind_originator)+z(3:end-1,ind_originator)+z(2:end-2,ind_originator)+z(1:end-3,ind_originator); 
data_originator_annual = [NaN(3,7); data_originator_annual];     
for t = 80:1:length(D)
    for i = 1:54
        for j = 1:7
            data_temp_i = z(t-79:t,i); data_temp_j = z(t-79:t,ind_originator(j)); data_annual_temp_j = data_originator_annual(t-79:t,j); 
            ind = find(~isnan(data_temp_i)); 
            if length(ind)==80
                data_out(i,j,t) = [0 1]*corrcoef(data_temp_i,data_temp_j)*[1;0];
            elseif length(ind)==20
                data_out(i,j,t) = [0 1]*corrcoef(data_temp_i(ind),data_annual_temp_j(ind))*[1;0];
            end
        end
    end
end
MacroFin_name{35} = 'GDP correlation';
MacroFin_data{35}.D = D; MacroFin_data{35}.data_out = data_out;  

save MacroFin.mat MacroFin_name MacroFin_data
%%
clc
close all
clear all

load MacroFin.mat
            
CountryMatch = xlsread('../data/FX classification/Monthly_classification_1940-2016_dora.xlsx','CountryMatch'); 
CountryMatch = CountryMatch(1:54,1); ind_NA = find(isnan(CountryMatch)); CountryMatch(ind_NA) = 1; 
z = xlsread('../data/FX classification/Monthly_classification_1940-2016_dora.xlsx','Coarse'); z(1:7,:) = []; 
D = repmat([1946:1:2016],12,1)*10000 + repmat([1:12]',1,71)*100 + 31; D = D(:); 
data_out = z(:,CountryMatch); 
data_out(:,ind_NA) = NaN; 
ind = find(data_out==6); data_out(ind) = NaN; 
ind = find(data_out<3); data_out(ind) = 0; 
ind = find(data_out>=3); data_out(ind) = 1; 

FX.D = D; FX.data_out = data_out;

MacroFin_name{36} = 'FX classification';
MacroFin_data{36}.D = D; MacroFin_data{36}.data_out = data_out;  
save MacroFin.mat MacroFin_name MacroFin_data




        
    
    


