% Generate the data matrix data_M with the dimension: longest possible time span x number of interest rates x number of countries
% Last modified: March 10, 2017 

clc
close all
clear all

FileName = '../data/bb_policy_ois_bonds_PXLAST_dora.xlsx'; 
[~,sheets] = xlsfinfo(FileName); 
CountryName = sheets(2:end-1) 
%%
data = cell(1,length(CountryName));
m = NaN(1,length(CountryName)); 
n = NaN(1,length(CountryName));

for i = 1:length(CountryName);    
    i     
    z_temp = xlsread(FileName,CountryName{i});  
    [m(i),n(i)] = size(z_temp);
    data{i} = z_temp;  
end
%%
unique(m)
% delete countries without any observations for PX_LAST
ind_delete = find(m==1); 
disp('Countries without observations')
CountryName(ind_delete)
CountryName(ind_delete) = []; 
data(ind_delete) = [];
m(ind_delete) = [];
n(ind_delete) = [];
% flag countries with different number of observations
unique(n)
disp('Countries with observations for two interest rates')
CountryName(find(n==2))
disp('Countries with observations for three interest rates')
CountryName(find(n==3))
disp('Countries with observations for four interest rates')
CountryName(find(n==4))
disp('Countries with observations for seven interest rates')
CountryName(find(n==7))
% make special cases for countries without policyrate observations
ind_treatment = find(n==4); 
data_M = NaN(max(m),5,length(CountryName));
for i = 1:length(CountryName)
    
    z_temp = data{i};
    if ismember(i,ind_treatment)
        data_M(1:size(z_temp,1),2:end,i) = z_temp; 
    else
        data_M(1:size(z_temp,1),1:min(n(i),5),i) = z_temp(:,1:min(n(i),5)); 
    end
end
T = xlsread('../data/time.xlsx');
save data_M.mat T CountryName data_M
%% summary statistics
clc
close all
clear all

load data_M.mat
ind_beg = find(T>20040000,1,'first'); ind_end = find(T<20160000,1,'last'); 

 z = squeeze(data_M(ind_beg:ind_end,end,:));
 Avg = nanmean(z)'; Std = nanstd(z)'; Obs = NaN(length(CountryName),3);
 for i = 1:length(CountryName)
 
     ind1 = find(~isnan(z(:,i)),1,'first');  ind2 = find(~isnan(z(:,i)),1,'last');
     if ~isempty(ind1)
        Obs(i,1) = T(ind1+ind_beg-1); 
     end
     if ~isempty(ind2)
        Obs(i,2) = T(ind2+ind_beg-1); 
     end
     Obs(i,3) = sum(~isnan(z(:,i)));
 
 end
 zout = [Avg Std Obs]; 




    
    
    





    


