%%
clear all
close all
load shock.mat

load Regression_country_10y.mat
z = squeeze(RFN_Three_Reorder(2,:,:)); z = z'; 
% remove self-spillover
z(16,1) = 1000; z(18,2) = 1000; z(14,4) = 1000; z(17,5) = 1000; z(15,6) = 1000; z(14,7) = 1000; 
% remove non-observation
ind = find(sum(isnan(z),2)==7); z(ind,:) = []; RegionCode(ind) = []; CountryName_Reorder(ind) = []; 
% remove XM as a area
z(1,:) = []; RegionCode(1) = []; CountryName_Reorder(1) = []; 
count_giver_10y = sum(z<0.1); count_giver_ByRegion_10y = NaN(6,7); count_giver_ByRegion_10y_fraction = NaN(6,7);
for i = 1:6
    ind = find(RegionCode==i);
    count_giver_ByRegion_10y(i,:) = sum(z(ind,:)<0.1); 
    count_giver_ByRegion_10y_fraction(i,:) = count_giver_ByRegion_10y(i,:)/length(ind); 
end

load Regression_country_2y.mat
z = squeeze(RFN_Three_Reorder(2,:,:)); z = z'; 
% remove self-spillover
z(16,1) = 1000; z(18,2) = 1000; z(14,4) = 1000; z(17,5) = 1000; z(15,6) = 1000; z(14,7) = 1000; 
% remove non-observation
ind = find(sum(isnan(z),2)==7); z(ind,:) = []; RegionCode(ind) = []; CountryName_Reorder(ind) = []; 
% remove XM as a area
z(1,:) = []; RegionCode(1) = []; CountryName_Reorder(1) = []; 
count_giver_2y = sum(z<0.1); count_giver_ByRegion_2y = NaN(6,7); count_giver_ByRegion_2y_fraction = NaN(6,7);
for i = 1:6
    ind = find(RegionCode==i);
    count_giver_ByRegion_2y(i,:) = sum(z(ind,:)<0.1); 
    count_giver_ByRegion_2y_fraction(i,:) = count_giver_ByRegion_2y(i,:)/length(ind); 
end

load Regression_country_6m.mat
z = squeeze(RFN_Three_Reorder(2,:,:)); z = z'; 
% remove self-spillover
z(16,1) = 1000; z(18,2) = 1000; z(14,4) = 1000; z(17,5) = 1000; z(15,6) = 1000; z(14,7) = 1000; 
% remove non-observation
ind = find(sum(isnan(z),2)==7); z(ind,:) = []; RegionCode(ind) = []; CountryName_Reorder(ind) = []; 
% remove XM as a area
z(1,:) = []; RegionCode(1) = []; CountryName_Reorder(1) = []; 
count_giver_6m = sum(z<0.1); count_giver_ByRegion_6m = NaN(6,7); count_giver_ByRegion_6m_fraction = NaN(6,7);
for i = 1:6
    ind = find(RegionCode==i);
    count_giver_ByRegion_6m(i,:) = sum(z(ind,:)<0.1); 
    count_giver_ByRegion_6m_fraction(i,:) = count_giver_ByRegion_6m(i,:)/length(ind); 
end

load Regression_country_1m.mat
z = squeeze(RFN_Three_Reorder(2,:,:)); z = z'; 
% remove self-spillover
z(16,1) = 1000; z(18,2) = 1000; z(14,4) = 1000; z(17,5) = 1000; z(15,6) = 1000; z(14,7) = 1000; 
% remove non-observation
ind = find(sum(isnan(z),2)==7); z(ind,:) = []; RegionCode(ind) = []; CountryName_Reorder(ind) = []; 
% remove XM as a area
z(1,:) = []; RegionCode(1) = []; CountryName_Reorder(1) = []; 
count_giver_1m = sum(z<0.1); count_giver_ByRegion_1m = NaN(6,7); count_giver_ByRegion_1m_fraction = NaN(6,7);
for i = 1:6
    ind = find(RegionCode==i);
    count_giver_ByRegion_1m(i,:) = sum(z(ind,:)<0.1); 
    count_giver_ByRegion_1m_fraction(i,:) = count_giver_ByRegion_1m(i,:)/length(ind); 
end

[a,b] = sort(count_giver_10y,'ascend'); 
ShockString = {'RBA','BoC','ECB','BoJ','SNB','BoE','Fed'}; ShockString = ShockString(b); 
RegionString = {'AE-Euro area','AE-other','EME-Asia','EME-Europe','EME-Latam','EME-other'}; 
count_giver_ByRegion_10y = count_giver_ByRegion_10y(:,b); count_giver_ByRegion_10y_fraction = count_giver_ByRegion_10y_fraction(:,b); 
count_giver_ByRegion_2y = count_giver_ByRegion_2y(:,b); count_giver_ByRegion_2y_fraction = count_giver_ByRegion_2y_fraction(:,b); 
count_giver_ByRegion_6m = count_giver_ByRegion_6m(:,b); count_giver_ByRegion_6m_fraction = count_giver_ByRegion_6m_fraction(:,b);
count_giver_ByRegion_1m = count_giver_ByRegion_1m(:,b); count_giver_ByRegion_1m_fraction = count_giver_ByRegion_1m_fraction(:,b);


figure
bar([count_giver_ByRegion_1m_fraction(:,1) count_giver_ByRegion_6m_fraction(:,1) count_giver_ByRegion_2y_fraction(:,1) count_giver_ByRegion_10y_fraction(:,1) ]); ylim([0 1])
set(gca,'XTickLabel',RegionString,'FontSize',20);
legend('3m','6m','2y','10y'); 

figure
bar([count_giver_ByRegion_2y_fraction(:,1) count_giver_ByRegion_10y_fraction(:,1)]); ylim([0 1])
set(gca,'XTickLabel',RegionString,'FontSize',20);
legend('2y','10y'); 

figure
bar([count_giver_ByRegion_2y_fraction(:,2) count_giver_ByRegion_10y_fraction(:,2)]); ylim([0 1])
set(gca,'XTickLabel',RegionString,'FontSize',20);
legend('2y','10y'); 

figure
% subplot(2,2,1)
bar3(count_giver_ByRegion_1m_fraction); 
zlim([0 1]); 
set(gca,'XTickLabel',ShockString);
set(gca,'YTickLabel',RegionString);
set(gca,'FontSize',15); 
figure
% subplot(2,2,2)
bar3(count_giver_ByRegion_6m_fraction); 
zlim([0 1]); 
set(gca,'XTickLabel',ShockString);
set(gca,'YTickLabel',RegionString);
set(gca,'FontSize',15); 
figure
% subplot(2,2,3)
bar3(count_giver_ByRegion_2y_fraction); 
zlim([0 1]); 
set(gca,'XTickLabel',ShockString);
set(gca,'YTickLabel',RegionString);
set(gca,'FontSize',15); 
figure
% subplot(2,2,4)
bar3(count_giver_ByRegion_10y_fraction); 
zlim([0 1]); 
set(gca,'XTickLabel',ShockString);
set(gca,'YTickLabel',RegionString);
set(gca,'FontSize',15); 



