% Generate the monetary policy shock cells 
% For each cell/country, the MP shock matrix containes the following
% columns: [day hour target path] or [day hour expectation term premium] or [day hour target path term premium]
% For days with mulitple shocks occuring at different times, take the last observation
% Last modified by Dora Xia May 04, 2017
%% compute the time adjustment - from local time to Europe/Zurich for CAD, GBP, JPY and USD
clc
close all
clear all

CountryName_adjust = {'CAD'; 'GBP'; 'JPY'; 'USD'}; 
TimeZone = {'America/New_York';'Europe/London';'Asia/Tokyo';'America/New_York'}; 
AdjustTime_TargetPath = cell(1,length(CountryName_adjust));
AdjustTime_ExpectationPremium = cell(1,length(CountryName_adjust));

% calculate the off-set time for MP shocks of CAD, GBP, JPY and USD
for i = 1:length(CountryName_adjust)
    z_temp = xlsread('../data/TargetVSPath_final_dora.xls',CountryName_adjust{i});
    ind = find(~isnan(z_temp(1,:))); 
    if ind(1) ~=1
        z_temp(:,1:ind(1)-1)=[];
    end
    year_temp = z_temp(:,10); month_temp = z_temp(:,11); day_temp = z_temp(:,12);
    d1 = tzoffset(datetime(year_temp,month_temp,day_temp,'TimeZone',TimeZone{i}));
    d2 = tzoffset(datetime(year_temp,month_temp,day_temp,'TimeZone','Europe/Zurich'));
    AdjustTime_TargetPath{i} = hour(d2-d1); 
end

for i = 1:length(CountryName_adjust)
    z_temp = xlsread('../data/ExpVSTP_final_dora.xls',CountryName_adjust{i});
    ind = find(~isnan(z_temp(1,:))); 
    if ind(1) ~=1
        z_temp(:,1:ind(1)-1)=[];
    end
    year_temp = z_temp(:,10); month_temp = z_temp(:,11); day_temp = z_temp(:,12);
    d1 = tzoffset(datetime(year_temp,month_temp,day_temp,'TimeZone',TimeZone{i}));
    d2 = tzoffset(datetime(year_temp,month_temp,day_temp,'TimeZone','Europe/Zurich'));
    AdjustTime_ExpectationPremium{i} = hour(d2-d1); 
end

%% generate monetary policy shock cells
CountryName_temp = {'AUD';'CAD';'EUR';'JPY';'CHF';'GBP';'USD'};
CountryName_shock = {'AU';'CA';'XM';'JP';'CH';'GB';'US'};
shock_TargetPath = cell(1,length(CountryName_shock));
shock_ExpectationPremium = cell(1,length(CountryName_shock));
shock_Three = cell(1,length(CountryName_shock));

for i = [1:2 4:7]
    
    z_temp = xlsread('../data/TargetVSPath_final_dora.xls',CountryName_temp{i});
    ind = find(~isnan(z_temp(1,:))); 
    if ind(1) ~=1
        z_temp(:,1:ind(1)-1)=[];
    end
    [D_temp,ind_first,~] = unique(z_temp(:,15),'first'); [~,ind_last,~] = unique(z_temp(:,15),'last');
    if length(D_temp) == size(z_temp,1)
        shock_TargetPath{i} =  [z_temp(:,15) z_temp(:,14) z_temp(:,4) z_temp(:,5)];
        OneMon_temp = z_temp(:,8); TwoYear_temp = z_temp(:,6); TenYear_temp = z_temp(:,7); 
        [~,~,r_TwoYear] = regress(TwoYear_temp,[ones(length(TwoYear_temp),1) OneMon_temp]); 
        [~,~,r_TenYear] = regress(TenYear_temp,[ones(length(TwoYear_temp),1) TwoYear_temp]);
        shock_Three{i} =  [z_temp(:,15) z_temp(:,14) OneMon_temp r_TwoYear r_TenYear];
    else
        H_temp = NaN(length(D_temp),1); 
        Target_temp = NaN(length(D_temp),1); Path_temp = NaN(length(D_temp),1); 
        OneMon_temp = NaN(length(D_temp),1); TwoYear_temp = NaN(length(D_temp),1); TenYear_temp = NaN(length(D_temp),1); 
        for t = 1:length(D_temp)
            [~,ind_select] = max(z_temp(ind_first(t):ind_last(t),14));
            ind_select = ind_first(t) + ind_select - 1; 
            H_temp(t) = z_temp(ind_select,14); 
            Target_temp(t) = z_temp(ind_select,4); Path_temp(t) = z_temp(ind_select,5);
            OneMon_temp(t) = z_temp(ind_select,8); TwoYear_temp(t) = z_temp(ind_select,6); TenYear_temp(t) = z_temp(ind_select,7);
        end
        shock_TargetPath{i} =  [D_temp H_temp Target_temp Path_temp];
        [~,~,r_TwoYear] = regress(TwoYear_temp,[ones(length(TwoYear_temp),1) OneMon_temp]); 
        [~,~,r_TenYear] = regress(TenYear_temp,[ones(length(TwoYear_temp),1) TwoYear_temp]);
        shock_Three{i} =  [D_temp H_temp OneMon_temp r_TwoYear r_TenYear]; 
    end
        
end

for i = [1:2 4:7]
    
    z_temp = xlsread('../data/ExpVSTP_final_dora.xls',CountryName_temp{i});
    ind = find(~isnan(z_temp(1,:))); 
    if ind(1) ~=1
        z_temp(:,1:ind(1)-1)=[];
    end
    [D_temp,ind_first,~] = unique(z_temp(:,15),'first'); [~,ind_last,~] = unique(z_temp(:,15),'last');
    if length(D_temp) == size(z_temp,1)
        shock_ExpectationPremium{i} =  [z_temp(:,15) z_temp(:,14) z_temp(:,4) z_temp(:,5)];
    else
        H_temp = NaN(length(D_temp),1); 
        Expectation_temp = NaN(length(D_temp),1); Premium_temp = NaN(length(D_temp),1); 
        for t = 1:length(D_temp)
            [~,ind_select] = max(z_temp(ind_first(t):ind_last(t),14));
            ind_select = ind_first(t) + ind_select - 1; 
            H_temp(t) = z_temp(ind_select,14); 
            Expectation_temp(t) = z_temp(ind_select,4); Premium_temp(t) = z_temp(ind_select,5);
        end
        shock_ExpectationPremium{i} =  [D_temp H_temp Expectation_temp Premium_temp];
    end
        
end

for i = 3
    
%     z_temp = xlsread('../data/MTS/shock_EUR_15mins','data_new');
    z_temp = xlsread('../data/MTS/shock_EUR','data_new');
    ind = find(~isnan(z_temp(1,:))); 
    if ind(1) ~=1
        z_temp(:,1:ind(1)-1)=[];
    end
    ind = find(isnan(z_temp(:,6))); z_temp(ind,:) = []; 
    
    [D_temp,ind_first,~] = unique(z_temp(:,15),'first'); [~,ind_last,~] = unique(z_temp(:,15),'last');
    if length(D_temp) == size(z_temp,1)
        shock_TargetPath{i} =  [z_temp(:,15) z_temp(:,14) z_temp(:,4) z_temp(:,5)];
        OneMon_temp = z_temp(:,8); TwoYear_temp = z_temp(:,6); TenYear_temp = z_temp(:,7); 
        [~,~,r_TwoYear] = regress(TwoYear_temp,[ones(length(TwoYear_temp),1) OneMon_temp]); 
        [~,~,r_TenYear] = regress(TenYear_temp,[ones(length(TwoYear_temp),1) TwoYear_temp]);
        shock_Three{i} =  [z_temp(:,15) z_temp(:,14) OneMon_temp r_TwoYear r_TenYear];
    else
        H_temp = NaN(length(D_temp),1); 
        Target_temp = NaN(length(D_temp),1); Path_temp = NaN(length(D_temp),1); 
        OneMon_temp = NaN(length(D_temp),1); TwoYear_temp = NaN(length(D_temp),1); TenYear_temp = NaN(length(D_temp),1); 
        for t = 1:length(D_temp)
            [~,ind_select] = max(z_temp(ind_first(t):ind_last(t),14));
            ind_select = ind_first(t) + ind_select - 1; 
            H_temp(t) = z_temp(ind_select,14); 
            Target_temp(t) = z_temp(ind_select,4); Path_temp(t) = z_temp(ind_select,5);
            OneMon_temp(t) = z_temp(ind_select,8); TwoYear_temp(t) = z_temp(ind_select,6); TenYear_temp(t) = z_temp(ind_select,7);
        end
        shock_TargetPath{i} =  [D_temp H_temp Target_temp Path_temp];
        [~,~,r_TwoYear] = regress(TwoYear_temp,[ones(length(TwoYear_temp),1) OneMon_temp]); 
        [~,~,r_TenYear] = regress(TenYear_temp,[ones(length(TwoYear_temp),1) TwoYear_temp]);
        shock_Three{i} =  [D_temp H_temp OneMon_temp r_TwoYear r_TenYear]; 
    end
        
end

for i = 3
    
%     z_temp = xlsread('../data/MTS/shock_EUR_15mins','data_new');
    z_temp = xlsread('../data/MTS/shock_EUR','data_new');
    ind = find(~isnan(z_temp(1,:))); 
    if ind(1) ~=1
        z_temp(:,1:ind(1)-1)=[];
    end
    ind = find(isnan(z_temp(:,6))); z_temp(ind,:) = []; 
    
    [D_temp,ind_first,~] = unique(z_temp(:,15),'first'); [~,ind_last,~] = unique(z_temp(:,15),'last');
    if length(D_temp) == size(z_temp,1)
        shock_ExpectationPremium{i} =  [z_temp(:,15) z_temp(:,14) z_temp(:,6) z_temp(:,7)-z-temp(:,6)];
    else
        H_temp = NaN(length(D_temp),1); 
        Expectation_temp = NaN(length(D_temp),1); Premium_temp = NaN(length(D_temp),1); 
        for t = 1:length(D_temp)
            [~,ind_select] = max(z_temp(ind_first(t):ind_last(t),14));
            ind_select = ind_first(t) + ind_select - 1; 
            H_temp(t) = z_temp(ind_select,14); 
            Expectation_temp(t) = z_temp(ind_select,6); Premium_temp(t) = z_temp(ind_select,7) - z_temp(ind_select,6);
        end
        shock_ExpectationPremium{i} =  [D_temp H_temp Expectation_temp Premium_temp];
    end
        
end

save shock.mat CountryName_shock shock_TargetPath shock_ExpectationPremium shock_Three
%% Check the correlation between two measures of term premium
for i = 1:length(CountryName_shock)
    z1_temp = shock_ExpectationPremium{i}; T1_temp = z1_temp(:,1);
    z2_temp = shock_Three{i}; T2_temp = z2_temp(:,1);
    [T_temp,i1,i2] = intersect(T1_temp,T2_temp);
    corr_temp = corrcoef([z1_temp(i1,end) z2_temp(i2,end)]);
    CountryName_shock{i}
    corr_temp(1,2)
end
% note: correlation numbers show that two measures of term premium are highely corrlated (~0.99) for most countries except EUR (0.75), JPY (0.73) and GBP (0.78). 
%% Summary statistics and plot of shocks
clc
clear all
close all

load shock.mat

stat_out = NaN(7,9);
for i = 1:length(CountryName_shock)
    z_temp = shock_Three{i};
    avg_temp = mean(z_temp(:,3:end)); std_temp =  std(z_temp(:,3:end));
    stat_out(i,:) = [avg_temp std_temp z_temp(1,1) z_temp(end,1) size(z_temp,1)];
end

zout = NaN(7,9);
TitleString = {'RBA';'BoC';'ECB';'BoJ';'SNB';'BoE';'Fed'}; 
ColorString = {'c','r','g'}; 
LegendString = {'Target shock (bp)','Path shock (bp)','Premium shock (bp)'}; 
%for i = 1:length(CountryName_shock)
 for i = 1   
    
    data_temp = shock_Three{i}; 
    time_temp = data_temp(:,1); [C,ia,~] = unique(floor(time_temp/10000)); 
    XTickString = cellstr(num2str(C));
    XTickString = [cell(1,1);cellstr(num2str(C(2:end)))]; 
%     XTickString = [cell(3,1);cellstr(num2str(C(4:end)))]; 

    for j = 1:3
        figure
%         bar(data_temp(:,2+j),'FaceColor',ColorString{j}); hold on
%         ind = find(data_temp(:,1)< 20081231,1,'last');
%         lb_temp = min(data_temp(:,2+j))*1.1; ub_temp = max(data_temp(:,2+j))*1.1; 
%         if ~isempty(ind)
%             plot((ind+1)*ones(length(lb_temp:0.1:ub_temp)),lb_temp:0.1:ub_temp,'k:','LineWidth',2); 
%         end
%         ylim([lb_temp ub_temp]); 
        bar(data_temp(:,2+j)); 
%         if j == 1
%             title(TitleString{i})
%         end
        xlim([1 length(time_temp)])
        set(gca,'XTick',ia,'XTickLabel',XTickString,'fontsize',15);
        set(gca,'XTickLabelRotation',90);
        set(gca,'XGrid','on'); 
        ylabel(LegendString{j},'fontsize',18); 
    end
    
end
