'Program written by Trent Saunders
'--------------------------------
'Extension: The probability of a crisis also depends on the credit-to-GDP gap. 
'This program puts together the results in Section 5.1.2. in Saunders and Tulip (2019).
'--------------------------------

'Create a matrix to store the results
matrix(1000, 5) extension_credit_gap		
extension_credit_gap.setcollabels creditgdpgap prob_peak loss cost benefit  'Column headers

'Save temporary values for series/strings so that the original values can be restored at the end of this program
scalar creditgdpgap_temp = creditgdpgap
%prob_temp = %prob

'Estimate the baseline model for different credit-to-GDP gaps and save the key results in a matrix
for !g_temp = 1 to 1000

	'Credit gap assumption
	scalar creditgdpgap = !g_temp/1000*40 - 20 - 1/1000*40 'Calculate results for a credit-to-GDP gap from -20 to 20, for increments of 0.04ppts.

	'Run programs
	%prob = "gap_fe"		'Estimate the probability of a crisis using a linear probability model that includes the credit-to-GDP gap and fixed effects
	include 2_crisis_probability		'Estimate probability of a crisis
	include 3_cost_benefit		'Estimate costs/benefits of LAW

	'Column 1: Credit gap
	extension_credit_gap(!g_temp,1) =  creditgdpgap

	'Column 2: Peak effect on the probability of a crisis
	smpl 2018:1 2023:1
	if @max(p_diff) > -@min(p_diff) then
		extension_credit_gap(!g_temp,2) = @max(p_diff)*100 
	endif
	if @max(p_diff) <= -@min(p_diff) then
		extension_credit_gap(!g_temp,2) = @min(p_diff)*100
	endif

	extension_credit_gap(!g_temp,3) = loss1_sum(last)		'Column 3: Difference between cumulative sum of costs and benefits
	extension_credit_gap(!g_temp,4) = cost1_sum(last)		'Column 4: Cumulative sum of costs
	extension_credit_gap(!g_temp,5) = benefit1_sum(last)	'Column 4: Cumulative sum of benefits

next 

'Restore inititial estimates
scalar creditgdpgap = creditgdpgap_temp
%prob = %prob_temp
include 2_crisis_probability		'Estimate probability of a crisis
include 3_cost_benefit		'Estimate costs/benefits of LAW


