'Program written by Trent Saunders
'--------------------------------
'Sensitivity analysis 
'This program estimates the sensitivity of the results to different assumptions for the size and duration of the crisis unemployment gap. 
'--------------------------------

'Crisis unemployment gap
'--------------------------------

'Find the row for the last observation in the evaluation period (this is used find the cost-benefit ratio at the end of the evaluation period)
%ser = "cost1_sum"
smpl @first %fored
series temp = @recode({%ser}<>na,@trend,na)+1 
scalar last = @max(temp)

'Create a matrix to store the results
matrix(500, 4) sensitivity_crisis_gap
sensitivity_crisis_gap.setcollabels severity cost benefit bc_ratio

'Save temporary value for crisis unemployment gap so that the original series can be restored at the end of this program
scalar ur_crisis_temp = ur_crisis

'Estimate the baseline model for different crisis unemployment gaps and save the key results in a matrix
for !ur_temp = 1 to 500
	scalar ur_crisis 	= (!ur_temp-1)/500*10
	include 3_cost_benefit
	sensitivity_crisis_gap(!ur_temp,1) = ur_crisis
	sensitivity_crisis_gap(!ur_temp,2) = cost1_sum(last)
	sensitivity_crisis_gap(!ur_temp,3) = benefit1_sum(last)
	sensitivity_crisis_gap(!ur_temp,4) = benefit1_sum(last) / cost1_sum(last)
next 

'Restore original series
scalar ur_crisis = ur_crisis_temp
include 3_cost_benefit

'--------------------------------
'Crisis duration
'How much longer would the crisis need to last to justify LAW (for a given unemployment gap)? 
'--------------------------------

'Create a matrix to store the results
matrix(500, 4) sensitivity_crisis_duration
sensitivity_crisis_duration.setcollabels duration cost benefit ratio

'Save temporary value for crisis duration so that the original series can be restored at the end of this program
scalar ur_crisis_temp = duration_y

'Estimate the baseline model for different crisis durations and save the key results in a matrix
for !ur_temp = 1 to 500
	scalar duration_y  = (!ur_temp-1)/500*22
	scalar duration_q = duration_y * 4 	'quarters	
	include 2_crisis_probability
	include 3_cost_benefit
	sensitivity_crisis_duration(!ur_temp,1) = duration_q/4
	sensitivity_crisis_duration(!ur_temp,2) = cost1_sum(last)
	sensitivity_crisis_duration(!ur_temp,3) = benefit1_sum(last)
	sensitivity_crisis_duration(!ur_temp,4) = benefit1_sum(last)/cost1_sum(last)
next 


'Restore original series
scalar duration_y = ur_crisis_temp
scalar duration_q = duration_y * 4 	'quarters
include 2_crisis_probability
include 3_cost_benefit


