'-----------------------------------------------------------------------------------------------------------------------------------
'Program written by Trent Saunders and Peter Tulip
'-----------------------------------------------------------------------------------------------------------------------------------
'This is the main program for the estimates discussed in Saunders and Tulip (2019), "Cost-Benefit Analysis of Leaning Against the Wind".
'This program sets up the EViews workfile and reads in the data. It then calls a succession of sub-programs.
'The program also defines the values for a number of important strings that are used in the sub-programs.
'See readme.docx for more details .
'-----------------------------------------------------------------------------------------------------------------------------------

'--------------------------------
' 	Workfile setup
'--------------------------------

'Run in quiet mode
mode quiet

'Set directory
%directory = @runpath
cd %directory

'Make workfile and read in the data
wfclose(noerr)
%wfname = "cost_benefit_results"	'Workfile name
workfile %wfname q 1980:1 2050:4	'Create workfile
import "eviews.xlsx"  "range=responses!a4" @smpl	'Read in the model multipliers used for the calculation of costs and benefits.

'--------------------------------
'	Model inputs
'--------------------------------

'Specify start and end dates
'--------------
%sd= "1990:1" 
%ed= "2015:1"
%forsd= "2015:2"		
%fored = "2024:3"	

'Assumptions
'--------------
scalar duration_y = 6	'Duration of crisis (years)
scalar duration_q = duration_y * 4 	'Duration of crisis (quarters)
scalar ur_gap = 0		'Unemployment gap in baseline scenario (%)
scalar ur_crisis = 5		'Unemployment gap in crisis (%)
scalar g_baseline = 5 	'Baseline real credit growth (%) (Baseline = 5%)
scalar scale_p = 1		'This scales the marginal effect of interest rates on the probability of a crisis (1 = baseline, 1.1 is 10% larger, etc). The scaling factor needs to be 3.26 for costs = benefits.
scalar scale_ur = 1		'This scales the effect of interest rates on the non-crisis unemployment rate  (1 = baseline, 1.1 is 10% larger, etc). The scaling factor needs to be 0.554 for costs = benefits.
scalar discount = 1		'Discount rate (1 = 0% discount rate, 0.99 = 1% discount rate, etc.)
scalar creditgdpgap = 0 'Assumed credit-GDP-gap. This is only used if you choose "%prob = gap_fe" or "%prob = gap_pool" below.

'Probability of a crisis
'--------------
%prob = "logit_fe"			'Logit - Fixed effects - Schularick and Taylor (2012) (DEFAULT)
'%prob = "logit_pool" 		'Logit - Pooled - Schularick and Taylor (2012) - Table 3, p1045 
'%prob = "quadratic_fe" 	'Quadratic - Fixed effects
'%prob = "quadratic_pool"	'Quadratic - Pooled
'%prob = "gap_fe" 			'Gap - Fixed effects
'%prob = "gap_pool"			'Credit-to-GDP gap - Pooled

'Choose VAR to be used for the effect of interest rates on credit.
'--------------
series cred_diff = cred_diff_jacobs_rayner 	'This is the response as estimated by Jacobs and Rayner (2012) (DEFAULT)
'series cred_diff = cred_diff_stone				'A VAR of the Australian housing market developed by Tahlee Stone for an internal RBA research project
'series cred_diff = cred_diff_hamilton_white 'A VAR developed by Adam Hamilton and Graham White for an internal RBA research project

'--------------------------------
'	Run sub-programs
'--------------------------------

'Put together forecasts and cost-benefit estimates
include 1_credit_and_unemployment
include 2_crisis_probability
include 3_cost_benefit

'Model extensions and sensitivity analysis
include 4_extension_credit_growth
include 5_extension_credit_gap
include 6_extension_cost_benefit

'Graphs and tables in the paper
include 7_graphs_and_tables

'Other sensitivity analysis 
include 8_sensitivity_responses_to_interest_rates 	'Estimates how much larger/smaller the responses of the crisis probability and unemployment rate would need to be for costs to equal benefits. Results saved as 'scale_p_equal' and 'scale_ur_equal'.
include 9_sensitivity_crisis_size_and_duration 		'Estimates the sensitivity of the results to different assumptions for the size and duration of the crisis unemployment gap. Results are saved in 'sensitivity_crisis_gap' and 'sensitivity_crisis_duration'


