'Program written by Trent Saunders
'--------------------------------
' Extension: Estimate the sensitivity of cost-benefit analysis to different rates of real credit growth. 
'This program puts together the results in Section 5.1.1 in Saunders and Tulip (2019).
'--------------------------------

'Create a matrix to store the results
matrix(1000, 8) graphit_5a
graphit_5a.setcollabels credit_growth logit_prob_net_benefit logit_prob_net_loss logit_threshold quadr_prob_net_benefit quadr_prob_net_loss quadr_threshold baseline_assumption 'Column headers

'Save temporary values for series/strings so that the original values can be restored at the end of this program
smpl @all
series g_b_temp = g_b
series g_s_temp = g_s
%prob_temp = %prob

'Find the row for the last observation in the evaluation period (this is used find the cost-benefit ratio at the end of the evaluation period)
%ser = "loss1_sum"
smpl @first %fored
series temp = @recode({%ser}<>na,@trend,na)+1 
scalar last = @max(temp)

'Estimate the baseline model for different rates of credit growth and save the key results in a matrix
for !g_temp = 1 to 1000

	'Credit growth assumptions
	series g_b 	= (!g_temp-1)/1000*0.20		'Calculate results for baseline real credit growth between 0 to 20%, for increments of 0.02ppts.
	series g_s 	= g_b + g_s_temp - g_b_temp	'LAW scenario
	
	'---------
	'Logit
	'---------
	'Run programs
	%prob = %prob_temp
	include 2_crisis_probability		'Estimate probability of a crisis
	include 3_cost_benefit		'Estimate costs/benefits of LAW

	'Column 1: Credit growth
	graphit_5a(!g_temp,1) =  (!g_temp-1)/1000*20

	'Column 2: Peak effect on the probability of a crisis (costs are greater than benefits, solid line in Figure 5a)
	if benefit1_sum(last) >= cost1_sum(last) then
		graphit_5a(!g_temp,2) =  @min(p_diff)*100 
	else
		graphit_5a(!g_temp,2) =  na
	endif

	'Column 3: Peak effect on the probability of a crisis (benefits are greater than costs, dashed line in Figure 5a)
	if benefit1_sum(last) < cost1_sum(last) then
		graphit_5a(!g_temp,3) =  @min(p_diff)*100
	else
		graphit_5a(!g_temp,3) =  na
	endif

	'Column 4: Peak effect on the probability of a crisis (benefits =~ costs, marker in Figure 5a)
	if 	!g_temp = 1 then
		graphit_5a(!g_temp,4) =  na
	else if graphit_5a(!g_temp,2) =  @min(p_diff)*100  and graphit_5a(!g_temp-1,2) =  na then
		graphit_5a(!g_temp,4) =  @min(p_diff)*100
	else
		graphit_5a(!g_temp,4) =  na
	endif
	endif

	'Column 8: Baseline assumption (5% real credit growth)
	if 	graphit_5a(!g_temp,1) = g_baseline then
		graphit_5a(!g_temp,8) = @min(p_diff)*100 
	else
		graphit_5a(!g_temp,8) =  na
	endif
	
	'---------
	'Quadratic
	'---------
	'Run programs
	%prob = "quadratic_fe"		'Estimate the probability of a crisis using a quadratic specification with fixed effects
	include 2_crisis_probability		'Estimate probability of a crisis
	include 3_cost_benefit		'Estimate costs/benefits of LAW

	'Column 5: Peak effect on the probability of a crisis (costs are greater than benefits, solid line in Figure 5a)
	if benefit1_sum(last) >= cost1_sum(last) then
		smpl 2021 2022q3
		graphit_5a(!g_temp,5) =  @min(p_diff)*100 
		smpl @all
	else
		graphit_5a(!g_temp,5) =  na
	endif

	'Column 6: Peak effect on the probability of a crisis (benefits are greater than costs, dashed line in Figure 5)
	if benefit1_sum(last) < cost1_sum(last) then
		smpl 2021 2022q3
		graphit_5a(!g_temp,6) =  @min(p_diff)*100
		smpl @all
	else
		graphit_5a(!g_temp,6) =  na
	endif

	'Column 7: Peak effect on the probability of a crisis (benefits =~ costs, marker in Figure 5a)
	if 	!g_temp = 1 then
		graphit_5a(!g_temp,7) =  na
	else if graphit_5a(!g_temp,5) =  @min(p_diff)*100  and graphit_5a(!g_temp-1,5) =  na then
		graphit_5a(!g_temp,7) =  @min(p_diff)*100
	else
		graphit_5a(!g_temp,7) =  na
	endif
	endif
next 

'Restore inititial estimates
smpl @all
series g_b = g_b_temp
series g_s = g_s_temp
%prob = %prob_temp
include 2_crisis_probability
include 3_cost_benefit


