'Program written by Trent Saunders
'--------------------------------
'Sensitivity analysis 
'--------------------------------

'This program estimates how much larger/smaller the responses of the crisis probability and unemployment rate would need to be for costs to equal benefits. 

'It answers three questions:
'1. 	How much larger would the estimated response of the crisis probability to interest rates have to be to justify LAW? (Answer: around 3.3 times larger)
'2.	How much smaller would the estimated response of the unemployment to interest rates have to be to justify LAW? (Answer: slightly larger than half the size -- scaling factor = 0.554)
'3. What are the combinations of the crisis probability and unemployment rate responses that result in benefits equalling costs? 

'--------------------------------
'1.	Probability of crisis
'	How much larger would the estimated response of the crisis probability to interest rates have to be to justify LAW? 
'--------------------------------

'Find the row for the last observation in the evaluation period (this is used find the cost-benefit ratio at the end of the evaluation period)
%ser = "cost1_sum"
smpl @first %fored
series temp = @recode({%ser}<>na,@trend,na)+1 
scalar last = @max(temp)

'Estimate the baseline model for different responses of the crisis probability until benefits = costs
'Save the scaling factor ( '_scale_p_equal') that results in benefits=costs 

smpl %forsd %fored
series loss_temp0 = loss1_sum
scalar scale_p0 = scale_p

for !i = 1 to 1000
	!k = !i-1
	scalar scale_p{!i} = 1 + !i / 100
	series benefit1_temp 	= (p_b - p_s)* scale_p{!i}	*((ur_crisis)^2 - (ur_diff)^2)
	series benefit1_sum = @cumsum(benefit1_temp) 
	series loss_temp{!i} = abs(benefit1_sum-cost1_sum)
		if loss_temp{!i}(last) >=  loss_temp{!k}(last) then
			scalar scale_p_equal = scale_p{!k}
			exitloop
		endif
	delete loss_temp{!k}
	delete scale_p{!k}
next

delete loss_temp{!i}
delete scale_p{!i}
delete loss_temp{!k}
delete scale_p{!k}

'--------------------------------
'2.	Non-crisis unemployment rate
'	How much smaller would the estimated response of the unemployment to interest rates have to be to justify LAW? 
'	(Answer: slightly larger than half the size -- scaling factor = 0.554)
'--------------------------------

'Estimate the baseline model for different responses of the unemployment rate to interest rates until benefits = costs
'Save the scaling factor ( '_scale_ur_equal') that results in benefits=costs 	

smpl %forsd %fored
series loss_temp_ur0 =  loss1_sum

scalar scale_ur0 = scale_ur

for !i = 1 to 1000
	!k = !i-1
	scalar scale_ur{!i} = 1 - !i / 1000
	series cost1_temp = (1 - p_b)*(scale_ur{!i}*ur_diff)^2
	series benefit1_temp 	= (p_b - p_s)*((ur_crisis)^2 - (scale_ur{!i}*ur_diff)^2)
	series cost1_sum = @cumsum(cost1_temp) 
	series benefit1_sum = @cumsum(benefit1_temp) 
	series loss_temp_ur{!i} = abs(benefit1_sum-cost1_sum)
		if loss_temp_ur{!i}(last) >=  loss_temp_ur{!k}(last) then
			scalar scale_ur_equal = scale_ur{!k}
			exitloop
		endif
	delete loss_temp_ur{!k}
	delete scale_ur{!k}
next

delete loss_temp_ur{!i}
delete scale_ur{!i}
delete loss_temp_ur{!k}
delete scale_ur{!k}

'
'--------------------------------
'3.	Probability of crisis and non-crisis unemployment rate
'	What are the combinations of the crisis probability and unemployment rate responses that result in benefits equalling costs? 
' 	NOTE: THIS CODE MAY TAKE A WHILE TO RUN. YOU SHOULD COMMENT OUT THIS SECTION IF YOU ARE ONY INTERESTED IN THE ANSWERS TO (1) AND (2) ABOVE.
'--------------------------------

matrix(200, 2) sensitivity_interest_rates = na ''Create a matrix to store the results
sensitivity_interest_rates.setcollabels scale_crisis_prob scale_ur	'Column headers
sensitivity_interest_rates(1,1) = 0
sensitivity_interest_rates(1,2) = 0

for !f = 1 to 200
	smpl %forsd %fored
	scalar scale_p{!f} = {!f} / 40 - 1 / 40
	series loss_temp_ur0 = loss1_sum
	scalar scale_ur0 = 1

	for !i = 1 to 200
		!k = !i-1
		scalar scale_ur{!i} = 1 - !k / 200
		series cost1_temp = (1 - p_b)*(scale_ur{!i}*ur_diff)^2
		series benefit1_temp 	= scale_p{!f}*(p_b - p_s)*((ur_crisis)^2 - (scale_ur{!i}*ur_diff)^2)
		series cost1_sum = @cumsum(cost1_temp)
		series benefit1_sum = @cumsum(benefit1_temp)
		series loss_temp_ur{!i} = abs(benefit1_sum-cost1_sum)
			if loss_temp_ur{!i}(last) >=  loss_temp_ur{!k}(last) and loss_temp_ur{!i}(last) < 0.1 then
				sensitivity_interest_rates(!f,1) = scale_p{!f}
				sensitivity_interest_rates(!f,2) = scale_ur{!i}
				exitloop
			endif
		delete loss_temp_ur{!k}
		delete scale_ur{!k}
	next
	delete scale_p{!f}
next

include 3_cost_benefit

