##### Preamble ################################################################
# Project: Credit Spreads, Monetary Policy, and the Price Puzzle
# File: Collect US Data from FRED
# Creator: Ben Beckers
# Date: 09 December 2019
# Description: This file collects data from FRED
###############################################################################


##### Step 1: Load Data #######################################################
### Obtain metadata
fred.series <- filter(metadata, str_detect(Mnemonic, "us_") & is.na(`Gertrude Series Code`)
                      & !is.na(`Series ID`))

### Each FRED series is retrieved separately they must be merged
# Get the first series
FRED.xts <- getSymbols(as.character(fred.series$`Series ID`[1]), src = 'FRED', 
                       auto.assign = FALSE)
# Get and merge the remaining FRED series
for (fr in 2:nrow(fred.series)) {
  FRED.xts <- merge(FRED.xts, getSymbols(as.character(fred.series$`Series ID`[fr]), 
                                         src = 'FRED', auto.assign = FALSE), 
                    all = TRUE)
}

### Correct the US bond titles
colnames(FRED.xts) <- fred.series$Mnemonic

### Select sample and convert to data frame
FRED.xts <- FRED.xts[paste0(smplstart, "::", smplmax)]
fred <- data.frame(index(FRED.xts), as.data.frame(FRED.xts))
fred <- fred %>% 
  rename(Date = index.FRED.xts.) %>% 
  as_tibble()

### Lag US financial data by one day (reflect time-difference)
fred <- fred %>% 
  mutate_at(vars(starts_with("us_ir | us_vix")), list(~ lag(.)))

### Create Corporate Bond Spreads
fred <- fred %>% 
  mutate(us_sprd_ir_cba_gb10 = us_ir_cba - us_ir_gb10,
         us_sprd_ir_cbb_gb10 = us_ir_cbb - us_ir_gb10)

fred_names <- names(fred)
rm(fred.series, FRED.xts)


##### Step 2: Save data #######################################################
save(fred, file = file.path(data_dir, "fred.RData"))
