##### Preamble ################################################################
# Project: Credit Spreads, Monetary Policy, and the Price Puzzle
# File: Master file
# Creator: Ben Beckers
# Date: 09 December 2019
##### Housekeeping ############################################################
### Clear console
cat("\014")

###############################################################################


##### Step 1: Set Directories #################################################
### Set the data directory
data_dir <- "Data/"
results_dir <- "Results/"


##### Step 2: Load functions and packages #####################################
# Source functions
source("Code/functions/funcs.R")
source("Code/functions/rr_regress.R")

# Load necessary packages
rbaverse::update()
check_and_install_packs(c('arphit', 'dynlm', 'lubridate', 'zoo', 'rvest', 'httr', 
                          'vars', 'plyr', 'quantmod', 'writexl', 'readxl', 
                          'stargazer', 'tidyverse'))


##### Step 3: Run files in order ##############################################

### Collect and Plot Data #####################################################
# source("Code/00_collect_data.R")
# rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))
source("Code/01_plot_data.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

### Romer and Romer type Regressions ##########################################
source("Code/02a_rr_regression.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/02b_rr_regression_anticipation_effects.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/02c_rr_regression_crexp.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/02d_rr_regression_subsample.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/02e_rr_regression_alternbase.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

### Forecast Error Evaluation #################################################
source("Code/03a_fc_err_cpii.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/03b_fc_err_cpii_exgfc.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/03c_fc_err_cpii_allhor.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/03d_fc_err_ur_allhor.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/03e_fc_err_gdp_allhor.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

### SVAR Results ##############################################################
source("Code/04a_svar_cr_vs_bt.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/04b_svar_bt_vs_btcs.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/04c_svar_unant.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/04d_svar_fincon.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/04e_svar_robust.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/04f_svar_altbase.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/04g_svar_btcs.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

### Local Projections #########################################################
source("Code/05a_lp_base.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))

source("Code/05b_lp_ex_gfc.R")
rm(list = setdiff(ls(), c("data_dir", "results_dir", lsf.str())))