lp_func <- function(data, dep.var, transf, horizon, lpp, x_var, lpq_x, h0x, controls, lpq_c, cholx, alpha = 0.9) {
  
  numc <- length(controls)
  IRF <- list()
  IRF$irf <- rep(0,horizon)
  IRF$irf_lwr <- rep(0,horizon)
  IRF$irf_upr <- rep(0,horizon)
  for (h in 1:horizon) {
    l.dep.var <- paste(transf, 3, ".", dep.var, sep="")
    dep.var.h <- paste(transf, as.character(3*h), ".", dep.var, sep="")
    if (lpp>0) {
      x0 <- paste(dep.var.h, " ~ L(", l.dep.var, ", ", as.character(h+cholx), ":", as.character(h+lpp+cholx-1), ") + L(",
                  x_var, ", ", as.character(h-1+h0x), ":", as.character(h-1+h0x+lpq_x-1), ")", sep="")
    } else {
      x0 <- paste(dep.var.h, " ~ L(", x_var, ", ", as.character(h-1+h0x), ":", as.character(h-1+h0x+lpq_x-1), ")", sep="")
    }
    if (numc>0 & lpq_c>0) {
      x1 <- paste(" + L(", controls[1], ", ", as.character(h-1+cholx), ":", as.character(h+lpq_c-1+cholx-1), ")", sep="")
      for (j in 2:numc) {
        x1 <- paste(x1, " + L(", controls[j], ", ", as.character(h-1+cholx), ":", as.character(h+lpq_c-1+cholx-1), ")", sep="")
      }
      x0 <- paste(x0, x1, sep="")
    }
    if (lpp>0 & h>1) {
      temp <- na.omit(data[, c(dep.var.h, l.dep.var, x_var, controls)])
    } else {
      temp <- na.omit(data[, c(dep.var.h, x_var, controls)])
    }
    lph <- dynlm(as.formula(x0), data = temp)
    coef <- summary(lph)$coefficients
    if (h>1) {
      coef <- unclass(coeftest(lph, vcov. = NeweyWest(lph, prewhite = F)))
    }
    # Extract coefficient on monetary policy shock
    if (lpq_x>1) {
      str_shk <- paste("L(", x_var, ", ", as.character(h-1+h0x), ":", as.character(h-1+h0x+lpq_x-1), ")", 
                       as.character(h-1+h0x), sep = "")
    } else if (lpq_x>1) {
      str_shk <- paste("L(", x_var, ", ", as.character(h-1+h0x), ":", as.character(h-1+h0x+lpq_x-1), ")"
                       , sep = "")
    } else {
      str_shk <- paste("L(", x_var, ", ", as.character(h-1+h0x), ":", as.character(h-1+h0x), ")"
                       , sep = "")
    }
    IRF$irf[h] <- coef[str_shk, 1]
    IRF$irf_lwr[h] <- IRF$irf[h] + coef[str_shk, 2]*qnorm((1-alpha)/2, 0, 1)
    IRF$irf_upr[h] <- IRF$irf[h] + coef[str_shk, 2]*qnorm(1-(1-alpha)/2, 0, 1)
  }
  
  return(IRF = IRF)
}

