differential_response_run <- function(core_logic_data_raw, monetary_policy_shocks_raw, grouping_variables, opts){
  
  
  # 1. Manipulate data ------------------------------------------------------------------------------------------------
  # filter, group, join shock
  corelogic_sa3_data <- build_combined_data(core_logic_data_raw, monetary_policy_shocks_raw, grouping_variables, opts)
  
  # 2. prepare regression data -------------------------------------------------------------------
  # add in decile interactions +  controls
  reg_data_pre <- build_regression_data(corelogic_sa3_data , opts)
  
  # 3. Run regression --------------------------------------------------------------------------
  reg_output_all <- lapply(1:opts$horizon,  function(x) panel_reg_lfe(reg_data_pre, x, opts )) # run regressions
  reg_output_tidy <- lapply(reg_output_all, function(x) { return(x$tidy_output)}) %>% bind_rows # tidy and print
  
  # 4. Plot ------------------------------------------------------------------------------------
  plot <- differentials_graphs(reg_output_tidy)
  
  # Make excel data
  graph_data <- reg_output_tidy %>% 
    filter(str_detect(term, "agg", negate = T), horizon %in% c(1,3,6,12)) %>% 
    mutate(significant = case_when(p.value > 0.05 & p.value <= 0.1 ~ "10% level",
                                   p.value > 0.01 & p.value <= 0.05 ~ "5% level",
                                   p.value <= 0.01 ~ "1% level",
                                   TRUE ~ "Insignificant")) %>%
    filter(mp_shock_lag == 0, str_detect(term, "_mp_")) %>%
    mutate(final_group = paste0(interaction_var_level, "_", significant) ) %>%
    select(horizon, decile = interaction_var_level, estimate, significant) %>%
    group_by(horizon) %>%
    nest() %>%
    mutate(data = map(data, function(x) x %>%
                        pivot_wider(
                          names_from = significant, values_from = estimate)))
  
  excel_data <- graph_data$data %>% setNames(glue::glue("quarter_{graph_data$horizon}")) 
  
  # # Summary stats -----------------------------------------------------------
  # # Peak effects -----------------------------------------------------------
  summary_stats <- reg_output_tidy %>% filter(str_detect(term, "agg", negate = T),
                                              horizon %in% c(5,6,7), 
                                              interaction_var_level %in% c(7:10), 
                                              mp_shock_lag == 0) %>%
    group_by(horizon) %>% summarise(estimate = mean(estimate))
  
  
  return(list(reg_output_tidy = reg_output_tidy, plot = plot, plot_data = excel_data, summary_stats = summary_stats))
  
}