# Title: Figure 1
# Creator: Calvin He
# Date Created: 04 November 2019
# Description:
# Outputs: 

library(lfe)
library(rGertrude) # RBA package to access internal database
library(data.table)
library(zoo)
library(dummies)
library(rlang)
library(ggplot2)
library(broom)
library(lubridate)
library(tidyverse)

# Step 0: Import functions and data ---------------------------------------

# Import Functions
user.defined.functions<- c(list.files(path = "./R", pattern = ".R",  full.names= T) )
if (length(user.defined.functions)>0){invisible(lapply(user.defined.functions, source))}

# Import Data
corelogic_data_raw <- readRDS("./data/corelogic_data_raw.RDS")
monetary_policy_shocks_raw <- readRDS("./data/monetary_policy_shocks.RDS")
grouping_variables <- readRDS("./data/grouping_variables.RDS")



# Step 1: Create within city level indicies -----------------------------------------------------
cl_within_city_graph <- corelogic_data_raw %>% 
  filter(!STATE_NAME_2016 %in%  c("Other Territories", NA), year(Date) > 2005) %>% 
  group_by(STATE_NAME_2016) %>% 
  nest() %>%
  mutate(data_price_group = map(data, core_logic_add_price_groups, group_no = 5, years = 2018),
         index = map(data_price_group, 
                     function(x) x %>% 
                       dplyr::filter(metric_name == "hedonic_index", property_type == "D") %>% 
                       dplyr::arrange(region_name, Date) %>% 
                       dplyr::group_by(region_name) %>% 
                       dplyr::mutate(base = head(calculation_value ,1), 
                                     value_new = 100*calculation_value/base ) %>% 
                       ungroup %>% 
                       dplyr::group_by(price_group, Date) %>% 
                       dplyr::summarise(value_new = mean(value_new, na.rm =T) )) ) %>% 
  unnest(index)


# Step 2: Plot ------------------------------------------------------------
graph_data <- cl_within_city_graph %>%  
  select(-data, -data_price_group) %>% 
  filter(price_group %in% c(1,3, 5)) %>% 
  mutate(price_group = str_to_title(paste0(english::ordinal(price_group), " quintile")))

graph_data <- readRDS("./data/figure-data/figure-1.RDS")


p <- ggplot(graph_data, aes(x = Date, y = value_new, colour = price_group))+
  facet_wrap(~ STATE_NAME_2016) +
 
  geom_line(size = 0.8) + 
  ylab("index") +
  scale_y_continuous(limits =c(80, 239.99), sec.axis = dup_axis())+
  rba_theme(multipanel = T) +
  labs(captions = "Sources: Authors' calculations; CoreLogic data" )

p

ggsave_rba(p, filename = "./analysis/figures/figure-1.png")
