# Title: Calculate rental growth using corelogic data
# Creator: Calvin He

corelogic_rental_growth <- function(core_logic_data_raw, start_year, end_year, prop_type = "D" , deflate = T){
  
  rental_growth <- core_logic_data_raw %>% 
    arrange(region_name, Date) %>% 
    filter(metric_name %in% "median_rental_rate", 
           property_type == prop_type , 
           year(Date) >= start_year, year(Date) <= end_year ) %>%
    {if (deflate == TRUE) {
      deflate_series(. , "calculation_value") %>%  # deflate calculation value
        mutate(calculation_value_orig = calculation_value,
               calculation_value = real_calculation_value) # keep orig cal value, and replace if metric name matches options
      
    }else {.} } %>% 
    arrange(region_name,Date) %>% 
    group_by(region_name) %>%  
    filter(Date %in% range(Date)) %>% 
    mutate(rental_growth = 100*(calculation_value - dplyr::lag(calculation_value))/ dplyr::lag(calculation_value) ) %>% 
    filter(!is.na(rental_growth)) %>% ungroup %>% select(SA3_CODE_2016, rental_growth)
  
  
  
  return(rental_growth)
  
}

# Title: Calculate price growth using corelogic data
# Creator: Calvin He

corelogic_price_growth <- function(core_logic_data_raw, start_year, end_year, prop_type = "D" , deflate = T){
  
  price_growth <- core_logic_data_raw %>% 
    arrange(region_name, Date) %>% 
    filter(metric_name %in% "hedonic_index", 
           property_type == prop_type, 
           year(Date) >= start_year, year(Date) <= end_year ) %>%
    {if (deflate == TRUE) {
      deflate_series(. , "calculation_value") %>%  # deflate calculation value
        mutate(calculation_value_orig = calculation_value,
               calculation_value = real_calculation_value) # keep orig cal value, and replace if metric name matches options
      
    }else {.} } %>% 
    arrange(region_name,Date) %>% 
    group_by(region_name) %>%  
    filter(Date %in% range(Date)) %>% 
    mutate(price_growth = 100*(calculation_value - dplyr::lag(calculation_value))/ dplyr::lag(calculation_value) ) %>% 
    filter(!is.na(price_growth)) %>% 
    ungroup %>% 
    select(SA3_CODE_2016, price_growth)
  
  return(price_growth)
  
}