# Title: Graphing functions
# Creator: Calvin He
# Date Created: 09 December 2019
# Description:
# Outputs: 


# RBA ggplot theme

rba_theme<- function(multipanel=FALSE){
  RBATheme <- theme_bw()+ theme( #axes, margins, gridlines
    # axis titles
    axis.title.y = element_text(angle = 0, vjust=1.0, hjust=5, margin=unit(c(0,-1,0,0.75), "cm"), size=16),
    axis.title.y.right = element_text(angle = 0, vjust=1.0, hjust=5, margin=unit(c(0,0.75,0,-0.5), "cm"),  size= 16),
    axis.title.x =element_text(size=rel(2)),
    # axis text
    axis.text.x = element_text(margin=unit(c(0.4,0.5,0.1,0.5), "cm"), size=16),
    axis.text.y = element_text(margin=unit(c(0.5,0.4,0.5,0.6), "cm"), size=16),
    axis.text.y.right = element_text(margin=unit(c(0.5,0.0,0.5,0.4), "cm"), size=16),
    axis.text = element_text(angle = 0,colour="black"),
    
    # axis ticks
    axis.ticks.y=element_blank(),
    axis.ticks.length=unit(-0.17, "cm"),
    
    # plot margin + other
    plot.margin = unit(c(0.2,0.6,0.2,0.2), "lines"),
    panel.border=element_rect(colour="black"),
    panel.grid.major.x = element_blank(),
    panel.grid.minor.x = element_blank(),
    panel.grid.minor.y = element_blank(),
    panel.grid.major.y = element_line(size = .5, color = "grey"),
    
    #legend
    legend.position = "bottom",
    legend.key = element_rect(fill = "white", colour = "white"),
    legend.title =element_blank(),
    legend.margin = margin(0,0,0,0),
    legend.background=element_blank(),
    legend.text=element_text(size= rel(1.2)),
    #titles
    plot.caption=element_text(hjust=0, size = rel(1.2)),
    plot.subtitle=element_text(hjust=0.5, size=rel(2.1)),
    plot.title = element_text(size=rel(3), face = "bold", vjust = -0.5,hjust=0.5)
  )
  
  if (multipanel==TRUE){
    # RBATheme <- RBATheme +
    #   theme(strip.background = element_blank(), strip.text = element_blank(),panel.spacing = unit(0, "lines"))
    RBATheme <- RBATheme +
      theme(strip.background = element_blank(), strip.text= element_text(size=rel(1.5)), panel.spacing = unit(0, "lines"))
  }
  return(RBATheme)
}



# Determine axis sizes -------------------------------------------------------------
graph_y_units <- function(graph_data,increment_size, y_name = "value", increments= 3, epsilon=1e-6 ){
  
  y_units <- list()
  y_units$increments <- pretty(graph_data[[y_name]], min.n = increments)
  y_units$min_point <- min( y_units$increments, na.rm = T)
  y_units$max_point <- max( y_units$increments, na.rm=T) - epsilon
  
  if(!missing(increment_size) ){
    y_units$increments <- c(y_units$min_point + c(0:increments)*increment_size)
    y_units$max_point <- y_units$min_point + (increments+1)*increment_size
  }
  

  
  return(y_units)
}

graph_x_units <- function(graph_data, x_name = "variable", increments = 3, integer = TRUE, x_gap_divisor = 2){
  
  x_units <- list()
  x_units$increments <- pretty(graph_data[[x_name]], min.n = increments)
  
  
  
  if (integer){
    x_units$increments <- round(x_units$increments) %>% unique
    x_units$min_point <-  min( x_units$increments, na.rm = T) - max(1, ( x_units$increments[2] -  x_units$increments[1])/x_gap_divisor)
    x_units$max_point <- max( x_units$increments, na.rm = T) + max(1, ( x_units$increments[2] -  x_units$increments[1])/x_gap_divisor )
  } else{
    x_units$min_point <-  min( x_units$increments, na.rm = T) - ( x_units$increments[2] -  x_units$increments[1])/x_gap_divisor
    x_units$max_point <- max( x_units$increments, na.rm = T) + ( x_units$increments[2] -  x_units$increments[1])/x_gap_divisor
  }
  
  
  return(x_units)
  
  
}


# ggsave_rba --------------------------------------------------------------

ggsave_rba <- purrr::partial(ggplot2::ggsave, units = "mm", width = 280, height = 238, dpi = 350)
