
# Aus real GDP
aus_gdp <- function(){
  # Read in Data
  aus_gdp <- read.csv(url("https://www.rba.gov.au/statistics/tables/csv/h1-data.csv"), skip=1, stringsAsFactors = FALSE) 
  
  # change column names
  colnames(aus_gdp) <- gsub("\\.","",colnames(aus_gdp)) %>% gsub("Title","Date",.)
  
  # convert data types
  aus_gdp[,2:ncol(aus_gdp)] <- sapply(aus_gdp[,2:ncol(aus_gdp)], as.numeric) # to numeric
  aus_gdp$Date <- as.Date(paste0("1-", aus_gdp$Date), format = "%d-%b-%Y")
  
  # remove rows with date as na
  aus_gdp <- aus_gdp %>% filter(!is.na(Date))
  aus_gdp$Date <- aus_gdp$Date  %>% last_day_month %>% as.Date  
  # remove column if all na
  aus_gdp <- aus_gdp[,apply(aus_gdp,2,function(x) !all(is.na(x)))]
  
  # remove row if all na
  aus_gdp <- aus_gdp[apply(aus_gdp%>% select(-Date), 1, function(x) !all(is.na(x))) ,]
  
  # take logs
  aus_gdp$ln_aus_real_gdp <- log(aus_gdp$RealGDP)
  
  # only keep logs
  aus_gdp <- aus_gdp %>% select(Date, ln_aus_real_gdp)
  
  return(aus_gdp)
}


# Australia unemployment rate -----------------------------------------------------------------------
# uses gertrude: internal RBA database
# notice monthly frequency
aus_unemployment <- function(){
  unemployment<- gertrude_timeseries( "AUU10000000.PS0","unemploy") %>%
    fortify.zoo() %>%
    rename(Date=Index) %>%
    mutate(Date= last_day_month(Date) %>%as.Date(.))
}