
#' Remove variables that are in levels or are counts
#' @description This function removes variables from the model selection process as they are in levels or are counts.
#' Most of these variables are converted to shares or logs. 

model_select_remove_vars <- function(df){
  
  df %>% select(
          - starts_with("persons_"), 
          -contains("year"),
          -ends_with("dollars") ,
          -ends_with("count"), 
          -ends_with("stock"), 
          -mortgage_owners,
          -households, 
          -outright_owners, 
          -renters, 
          -working_age_pop, 
          -pop_2006_2016, 
          -investment_income_earners, 
          -newstart_allowance, 
          -parenting_payment_single, 
          -parenting_payment_partnered,
          -total_income_earners_excl_government_pensions,
          -population,
          -value, 
          -investment_income_as_main_source_of_income)
  
}