# Title: Graph 3
# Creator: Calvin He
# Date Created: 04 November 2019
# Description:
# Outputs: 

library(lfe)
library(rGertrude) # RBA package to access internal database
library(data.table)
library(zoo)
library(dummies)
library(rlang)
library(ggplot2)
library(broom)
library(lubridate)
library(tidyverse)

# Step 0: Import functions and data ---------------------------------------

# Import Functions
user.defined.functions<- c(list.files(path = "./R", pattern = ".R",  full.names= T) )
if (length(user.defined.functions)>0){invisible(lapply(user.defined.functions, source))}

# Import Data
corelogic_data_raw <- readRDS("./data/corelogic_data_raw.RDS")
monetary_policy_shocks_raw <- readRDS("./data/monetary_policy_shocks.RDS")
grouping_variables <- readRDS("./data/grouping_variables.RDS")


# Step 1:  Choose your options --------------------------------------------
opts <- set_options(figure = 3)


# filter, group, join shock
corelogic_sa3_data <- build_combined_data(core_logic_data_raw, monetary_policy_shocks_raw, grouping_variables,  opts)

# 2. Create Regression data ----------------------------------
# Join to core_logic data to chosen monetary policy shock; add in decile interactions
reg_data_pre <- corelogic_sa3_data  %>%
  arrange(region_name, Date) %>%
  add_shock_lag(. , opts) %>%
  add_controls(., opts) %>%   # add in controls based on options
  add_agg_controls(., opts ) %>% 
  add_ar_y(., opts) %>%
  {if(opts$remove_gfc){ . %>% filter(Date < "2007-12-31"| Date > "2010-01-01") }else{.} } %>%
  mutate(calculation_value = replace(calculation_value, calculation_value == 0 , 1)) %>%
  arrange(region_name, Date) %>%
  group_by(region_name) %>%
  mutate(obs = sum(!is.na(calculation_value))) %>%
  filter(obs > 30)

# 3. Run Local Projections for each SA3 -------------------------------------------
output <- reg_data_pre  %>% 
  group_by( STATE_NAME_2016, SA3_CODE_2016) %>% 
  nest() %>% 
  mutate(output = map(data, individual_reg, m = opts$horizon  )) 

# 4. Extract Responses ----------------------------------------------------
effects <- output %>% unnest(output) %>% 
  filter(term == "mp_shock")

# Distribution of estimates -----------------------------------------------
dist_effects <- effects %>% group_by(horizon) %>% 
  nest() %>% 
  mutate(quantile = map(data, ~ as_tibble(t(-quantile( -(.$estimate), probs = c(0.1, 0.25, 0.5, 0.75, 0.9), na.rm =T ))  )) ) %>% 
  unnest(quantile)

# Plot --------------------------------------------------------------------
graph_data <- dist_effects %>% select(-data) %>% gather(key = "quantile", value = "estimate", - horizon) 


graph_data <- readRDS("./data/figure-data/figure-3.RDS") # read in actual data

p <- ggplot(graph_data,  aes (x= horizon, y = estimate, colour = quantile)) +
  geom_line(size = 0.8) +
  rba_theme() +
  xlab("Quarters") +
  scale_y_continuous(name = "%", sec.axis = dup_axis()) +
  labs(caption= "Sources: ABS; Authors' calculations, CoreLogic data, RBA")

p
