# Author: Michelle Bergmann
# Research Economist, Economic Research Department, Reserve Bank of Australia
# Last modified: July 2020
# Code to estimate cumulative baseline hazards post-Cox model estimation, contained in RDP 'The Determinants of Mortgage Defaults in Australia'



#######################################################################################################
# 1. Estimate baseline hazards
#######################################################################################################

library(survival)


# estimate via Kalbfleisch-Prentice

fit_mining <- survfit(cox_arrears_mining, newdata = means_prediction_single,data=subset(data,data$MiningRegion=="Mining"))

fit_non_mining <- survfit(cox_arrears_non_mining, newdata = means_prediction_single,data=subset(data,data$MiningRegion!="Mining"))


# extract cumulative hazards

cumhaz_mining<-data.frame(haz=fit_mining$cumhaz,time=seq(1,75,1),region=rep("Mining",75))

cumhaz_non_mining<-data.frame(haz=fit_non_mining$cumhaz,time=seq(1,75,1),region=rep("Non-mining",75))


# Form dataframe 

fit_regions<-bind_rows(cumhaz_mining,cumhaz_non_mining)

fit_regions$haz<-fit_regions$haz*100




