# Author: Michelle Bergmann
# Research Economist, Economic Research Department, Reserve Bank of Australia
# Last modified: July 2020
# Code to estimate second stage hazard models contained in RDP 'The Determinants of Mortgage Defaults in Australia'



################################################################################################################################
# 1. Model specifications
################################################################################################################################


regressors_base<-"
#LVR
    indexed_LVR_buckets+
    original_LVR_buckets+
    turnover_ratio+
#unemployment
    unemployment_rate_residents_5_years_ago+
    I(unemployment_rate_residents_5_years_ago^2)+
#serviceability
    serviceability_ratio_buckets+
    high_income+
#age
    origination_year_buckets+
#loan controls
    investment+
    IO_type_switching_12m+
    multiple_debtors+
    self_employed_na+
    loan_purpose2+
    loan_origination_channel+
    fixed_rate+
    low_doc+
#performance
    previous_discharge+
    event_restructuring_arrangement+
#regional characteristics
    mining_share_employment_SA3+
    remoteness+
    state+
#time FE
    factor(report_month)+
#deal characteristics
    type.short+
    deal_type"





################################################################################################################################
# 2. Estimating Cox model - competing risks proportional hazards
################################################################################################################################

# Loans either: cure, are withdrawn, foreclose, or are right censored ie were still in arrears the last time that they were observed (either the current month or the month they were cleaned up)
# time variable is time since entered 90 days arrears
# model is competing risks hazard model
# standard errors are clustered at the SA3 region level


### Base model

## foreclosures - all

cox_foreclosure<-coxph(as.formula(paste("Surv(hazard_time,foreclosed)","~",regressors_base,"+SEIFA_IRSAD","+cluster(SA3)")),data=events_first_NA)
summary(cox_foreclosure)


## foreclosures - mining regions 

cox_foreclosure_mining<-coxph(as.formula(paste("Surv(hazard_time,foreclosed)","~",regressors_base,"+SEIFA_IRSAD","+cluster(SA3)")),data=events_first_NA,subset = (MiningRegion=="Mining"))


## foreclosures - non-mining regions 

cox_foreclosure_non_mining<-coxph(as.formula(paste("Surv(hazard_time,foreclosed)","~",regressors_base,"+SEIFA_IRSAD","+cluster(SA3)")),data=events_first_NA,subset = (MiningRegion!="Mining"))


## foreclosures - negative equity

events_first_NA$indexed_LVR_buckets<-relevel(events_first_NA$indexed_LVR_buckets,ref="(100,110]")

cox_foreclosure_neg<-coxph(as.formula(paste("Surv(hazard_time,foreclosed)","~",regressors_base,"+SEIFA_IRSAD","+cluster(SA3)")),data=events_first_NA,subset = (indexed_LVR>100))

events_first_NA$indexed_LVR_buckets<-relevel(events_first_NA$indexed_LVR_buckets,ref="(60,70]")


## cured - all

cox_cured<-coxph(as.formula(paste("Surv(hazard_time,cured)","~",regressors_base,"+SEIFA_IRSAD","+cluster(SA3)")),data=events_first_NA)


## repaid - all

cox_repaid<-coxph(as.formula(paste("Surv(hazard_time,repaid)","~",regressors_base,"+SEIFA_IRSAD","+cluster(SA3)")),data=events_first_NA)




### Ex SEIFA model

## foreclosures - all

cox_foreclosure_ex_seifa<-coxph(as.formula(paste("Surv(hazard_time,foreclosed)","~",regressors_base,"+cluster(SA3)")),data=events_first_NA)




















