*************************** 3. UNEMPLOYMENT MODEL *****************************
**************************** DATE: AUGUST 2020 ********************************
**************************** AUTHOR: MIKE MAJOR *******************************
*************** ADAPTED FROM BILSTON, JOHNSTON AND READ (2015) ****************

****************************************************************************
*Options                          					   
****************************************************************************
	clear all
	set memory 600m
	set maxvar 15000
	set type double
	set more off
	pause on
	loc show_marginal_effects = 0 		// 1 show marginal effects; 0 do not show marginal effects
	loc sensitivity = 0.001				// calibration sensitivity for loop
	
****************************************************************************
*Bring in data                                
****************************************************************************
*Import person-level data
if ${year} == 2018 {
	use "${hes_location}SIH2017_18\sih17bp.dta", clear
	}
if ${year} == 2016 & ${hes} == 1 {
	use "${hes_location}SIH2015_16\hes15bp.dta", clear
	}
if ${year} == 2016 & ${hes} == 0 {
	use "${hes_location}SIH2015_16\sih15bp.dta", clear
	}
if ${year} == 2010 {
	use "${hes_location}SIH2009_10\hes10bp.dta", clear
	}
if ${year} == 2004 {
	use "${hes_location}2003_04\data_third_edition\hes03bp.dta", clear
	}
	rename *, lower	
	
*Merge with household-level data
if ${hes} == 1 {	
	destring abshid , generate(new_abshid) ignore("HES" "B")
	merge m:1 new_abshid using "Data\hh_${year}_${hes}.dta", generate(merge1) 
	gen pwt = hespswt // person-weight
}
if ${hes} == 0 {	
	destring abshid , generate(new_abshid) ignore("SIH" "B")
	merge m:1 new_abshid using "Data\hh_${year}_${hes}.dta", generate(merge1) 
	gen pwt = sihpswt // person-weight	
}

*Drop household variables that have  person variables with same name
drop age

*********************************************************************************
*Format variables for probit model
*********************************************************************************
*Generate dependent variable (1 if unemployed, 0 if employed, otherwise missing)
	recode lfscp (2 = 1) (1 = 0) (else=.), gen (unempl) label (unemployed) 		

*Recode variables to be consistent across years
if ${year} == 2016 | ${year} == 2018  {
	gen age = ageec

	*Education	
	recode lvledua (1 2 3 = 1) (else=0), gen (uni) label(has a university qualification) 				
	recode lvledua (4 5 6 7 = 1) (else=0), gen (diploma) label(has a diploma or certificate qualification) 	
	recode lvledua (8 = 1) (else=0), gen (justyear12) label(completed highschool) 						
	recode disbper (1 = 1) (else=0), gen (health) label(health condition) 
	}

if ${year} == 2010 {
	gen age = agebc		
	gen cobcb = cobl // country of birth by main language

	*Education	
	recode lvledubc (1 2 = 1) (else=0), gen (uni) label(has a university qualification) 			
	recode lvledubc (3 4 5 6 = 1) (else=0), gen (diploma) label(has a diploma or certificate qualification) 	
	recode lvledubc (7 = 1) (else=0), gen (justyear12) label(completed highschool) 					
	recode disbper (1 = 1) (else=0), gen (health) label(health condition) 
	}		
if ${year} == 2004 {
	gen age = agebc		
	gen cobcb = cobl // country of birth by main language

	*Education	
	recode hqualbc (1 2 = 1) (else=0), gen (uni) label(has a university qualification) 					
	recode hqualbc (3 4 5 6 = 1) (else=0), gen (diploma) label(has a diploma or certificate qualification)
	gen justyear12 = 0
	replace justyear12 = 1 if secqlcf==1 & uni==0 & diploma==0
	gen health = 0 
	replace health = 1 if idisbcp + idsuppcp > 0 // receives disability pension
	}

	recode cobcb (1 2 = 1) (else=0), gen (engspeak) label(English speaking background) 		
	recode sexp (1 = 1) (else=0), gen (male) label(male)									
	recode mstatp (1 = 1) (else=0), gen (married) label(married or longterm relationship)	
	recode irnrrcpf (1 = 1) (else=0), gen (renterw2) label(earns positive rental income)			

	*Family structure
	recode iutypep (1 = 1) (else=0), gen (cpl_dep) label(couple wit dependents)				
	recode iutypep (2 = 1) (else=0), gen (cpl_ndep) label(couple without dependents)		
	recode iutypep (3 = 1) (else=0), gen (sgl_par) label(single parent)						
		
	*Has housing debt dummy
	gen housingdebt_dum = 0
	replace housingdebt_dum = 1 if propertydebt>0  & propertydebt!=.
	label variable housingdebt_dum "household has housing debt"	
	
	*Geography
	recode capcity (1 = 1) (else=0)
	recode state (1 = 1) (else=0), gen (nsw) label(nsw) 	
	recode state (2 = 1) (else=0), gen (vic) label(vic) 	
	recode state (3 = 1) (else=0), gen (qld) label(qld) 	
	recode state (4 = 1) (else=0), gen (saus) label(saus) 	
	recode state (5 = 1) (else=0), gen (waus) label(waus) 	
	recode state (6 = 1) (else=0), gen (tas) label(tas) 	
	recode state (7 8 = 1) (else=0), gen (ntact) label(ntact) 	
	
	*Proxy for previously unemployed
	gen newstart = .
	if ${year} != 2018 {
	replace newstart = 0
	replace newstart = 1 if inewstpp>0 & inewstpp!=.
	label variable newstart "unemployment benefits last year"		
	}		
****************************************************************************
*               Estimate model and some outputs	        	               
****************************************************************************		
	if ${year} != 2018 {
	probit unempl i.health i.engspeak i.married c.age c.age#c.age i.cpl_dep i.cpl_ndep i.sgl_par i.uni i.diploma i.justyear12 i.renterw2 i.housingdebt_dum i.capcity i.vic i.qld i.saus i.waus i.tas i.ntact i.newstart
		if `show_marginal_effects' == 1  {
		margins, dydx(*) at((mean) _all health=0 engspeak=0 married=0 cpl_dep=0 cpl_ndep=0 sgl_par=0 uni=0 diploma =0 renterw2=0 justyear12=0 housingdebt_dum=0 capcity=0 vic=0 qld=0 saus=0 waus=0 tas=0 ntact=0 newstart=0)
		pause
		}
	}
	if ${year} == 2018 {
	probit unempl i.health i.engspeak i.married c.age c.age#c.age i.cpl_dep i.cpl_ndep i.sgl_par i.uni i.diploma i.justyear12 i.renterw2 i.housingdebt_dum i.capcity i.vic i.qld i.saus i.waus i.tas i.ntact
		if `show_marginal_effects' == 1  {	
		margins, dydx(*) at((mean) _all health=0 engspeak=0 married=0 cpl_dep=0 cpl_ndep=0 sgl_par=0 uni=0 diploma =0 renterw2=0 justyear12=0 housingdebt_dum=0 capcity=0 vic=0 qld=0 saus=0 waus=0 tas=0 ntact=0)
		pause
		}
	}	
	*Save constant
	gen _const = _b[_cons]
	
****************************************************************************
*Predict and calibrate values	       	               
****************************************************************************	

*Generate probability of losing job based on probit model 
	gen prunempl_ = 0 								
	predict inv_prunempl, xb
	replace prunempl_ = normal(inv_prunempl)
	replace prunempl_ = . if unempl!=0 // can't lose job if already unemployed or NILF
	
*Generate probit constant
	gen _const_ = _const
*Generate flag for loop that indicates whether loop has already run
	loc flag = 0
*Save weighted mean probabilities for employed
	su prunempl_  [aweight=pwt] if unempl==0
	loc prunemplmean_ = r(mean) 

*Run loop of increasing constants to arrive at a mean probability that equals the defined employment shock
	local y = -5
	while (`prunemplmean_' <= ${shock} | `flag' == 0) { 
		loc y = `y' + `sensitivity'
		replace _const_ = _const + `y' //increase constant
		replace prunempl_ = normal(inv_prunempl + _const_) 	
		replace prunempl_ = . if unempl! = 0	
		replace prunempl_ = 0 if prunempl_ <= 0
		loc flag = 1
			
		su prunempl_ [aweight=pwt] if unempl==0
		loc prunemplmean_ = r(mean) 
		}
								
****************************************************************************
*Output data to the simulation file   	       
****************************************************************************

*Assign person ID within household
recode hhpos (1 = 1) (else = 0), gen (hh_ref) label (household reference person) 		
gsort new_abshid -hh_ref
by new_abshid: generate byte person_id = _n
label variable person_id "person ID within household"

*Gross incomes
if ${year} == 2010 | ${year} == 2016 | ${year} == 2018 {
	gen emp_inc = iwssucp8 // employment income
	gen emp_extras = iwssucp8 - iwssucp // non-salary/non-wage employment income
	gen inv_inc = invescp8 // investment income
	gen oth_inc = itgcbcp8 + iobtcp + itregcp8 // other income
	gen tot_inc = emp_inc + inv_inc + oth_inc // total income
}

if ${year} == 2004 {
	gen emp_inc = iwsucp // employment income
	gen emp_extras = iwsbucp // non-salary/non-wage employment income
	gen inv_inc = investcp // investment income
	gen oth_inc = itgcbcp + iobtcp + itregcp // other income
	gen tot_inc = emp_inc + inv_inc + oth_inc // total income
	gen itaxcp8 = itaxcp // tax
	}
	
if ${year} == 2004 | ${year} == 2010 {	
	*Generate disposable income variable 		
	gen dispscp8 = tot_inc - itaxcp8	
	}

*Derive estimates of disposable income 
	*Use estimates rather than reported to ensure consistenct treatment in post shock)
	*Apply income tax tables from https://www.ato.gov.au/Rates/Individual-income-tax-for-prior-years/
	gen tot_inc_ann = tot_inc * 52 // annualise
	gen disp_inc_ann = tot_inc_ann 
	if ${year} == 2018 {
	replace disp_inc_ann = tot_inc_ann - 0.19*(tot_inc_ann-18200) if tot_inc_ann > 18200 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 3572 - 0.325*(tot_inc_ann-37000) if tot_inc_ann > 37000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 19822 - 0.37*(tot_inc_ann-87000) if tot_inc_ann > 87000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 54232 - 0.45*(tot_inc_ann-180000) if tot_inc_ann > 180000 & tot_inc_ann!=.
	}
	if ${year} == 2016 {
	replace disp_inc_ann = tot_inc_ann - 0.19*(tot_inc_ann-18200) if tot_inc_ann > 18200 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 3572 - 0.325*(tot_inc_ann-37000) if tot_inc_ann > 37000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 17547 - 0.37*(tot_inc_ann-80000) if tot_inc_ann > 80000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 54547 - 0.45*(tot_inc_ann-180000) if tot_inc_ann > 180000 & tot_inc_ann!=.
	}
	if ${year} == 2010 {
	replace disp_inc_ann = tot_inc_ann - 0.15*(tot_inc_ann-6000) if tot_inc_ann > 6000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 4350 - 0.30*(tot_inc_ann-35000) if tot_inc_ann > 35000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 17850 - 0.38*(tot_inc_ann-80000) if tot_inc_ann > 80000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 55850 - 0.45*(tot_inc_ann-180000) if tot_inc_ann > 180000 & tot_inc_ann!=.
	}
	if ${year} == 2004 {
	replace disp_inc_ann = tot_inc_ann - 0.17*(tot_inc_ann-6000) if tot_inc_ann > 6000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 2652 - 0.30*(tot_inc_ann-21600) if tot_inc_ann > 21600 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 11772 - 0.42*(tot_inc_ann-52000) if tot_inc_ann > 52000 & tot_inc_ann!=.
	replace disp_inc_ann = tot_inc_ann - 16182 - 0.47*(tot_inc_ann-62500) if tot_inc_ann > 62500 & tot_inc_ann!=.
	}	
	
	gen disp_inc = disp_inc_ann / 52 // convert back to weekly

*Keep desired variables
keep new_abshid	person_id prunempl_ disp_inc emp_inc emp_extras inv_inc oth_inc tot_inc lfscp pwt

*Reshape to household level
reshape wide prunempl_ disp_inc emp_inc emp_extras inv_inc oth_inc tot_inc lfscp pwt, i(new_abshid) j(person_id)

*Export data
if ${hes} == 1 {
save "Data\unempl_stress_${year}_hes_${batchUR}.dta", replace
}
if ${hes} == 0 {
save "Data\unempl_stress_${year}_sih_${batchUR}.dta", replace
}