/*******************************************************************************

	0_master.do
	
	This program executes all other .do files in the correct order.

	Creators:    James Bishop and Iris Day
	Last edited: 10 November 2020 

*******************************************************************************/	

local dir_do  "S:\2020-z008 Capacity_SW\JK_analysis\RDP_documentation\programs"
local dir_out "S:\2020-z008 Capacity_SW\JK_analysis\RDP_documentation\output"

*extract and clean the raw LLFS CURF data
do "`dir_do'\1_import_data.do"

*create  key variables used in the regression analysis
do "`dir_do'\2_variables.do"

*produce the descriptive statistics cited in the paper
do "`dir_do'\3_summary_stats.do"

*estimate effect of JobKeeper worker-eligibility on employment and hours + robustness tests
do "`dir_do'\4_regressions.do"

* erase confidential unit record data from output folder
erase "`dir_out'\setup.dta"
erase "`dir_out'\skinny.dta"
erase "`dir_out'\skinny_full.dta"

clear all

* end of do file