/*******************************************************************************

	4_regressions.do
	
	This program produces estimates effect of JK worker-eligibility on 
	employment and hours. It also generates the results of the robustness tests
	and implements the alternative identifcation strategy (based on migrants)

	Creators:    James Bishop and Iris Day
	Last edited: 10 November 2020 

*******************************************************************************/	

clear all

sysdir set PLUS "C:\Users\bishjam\Documents\Stata"

cd "S:\2020-z008 Capacity_SW\JK_analysis\RDP_documentation\output"

use setup.dta, clear

*sample exclusions 
drop if sample==0

/*******************************************************************************
	1 - ABS definition of employment - baseline and robustness tests
*******************************************************************************/	

capture {
erase casual_emp.txt
erase casual_emp.xls 
}

local controls     i.recentmigrant i.onejob i.ind06div i.occ13skl i.student c.age c.age_sq i.female

*Loops over months j
	*Spec 1: DD (main specification)
forvalues j=3(-1)0{
		reg L`j'.emp i.tgroup if absmid==tm(2020m2), robust
		outreg2 using casual_emp.xls, excel append ctitle(L`j'_DD) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp i.tgroup if absmid==tm(2020m2), robust
		outreg2 using casual_emp.xls, excel append ctitle(F`j'_DD) stats(coef se tstat pval) noaster
		}
	*Spec 2: DD with controls (robustness)
forvalues j=3(-1)0{
		reg L`j'.emp i.tgroup `controls' if absmid==tm(2020m2), robust
		outreg2 using casual_emp.xls, excel append ctitle(L`j'_c) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp i.tgroup `controls' if absmid==tm(2020m2), robust
		outreg2 using casual_emp.xls, excel append ctitle(F`j'_c) stats(coef se tstat pval) noaster
		}
	*Spec 3: DD 2019 placebo (robustness)
forvalues j=3(-1)0{
		reg L`j'.emp i.tgroup `controls' if absmid==tm(2019m2), robust
		outreg2 using casual_emp.xls, excel append ctitle(L`j'_19) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp i.tgroup `controls' if absmid==tm(2019m2), robust
		outreg2 using casual_emp.xls, excel append ctitle(F`j'_19) stats(coef se tstat pval) noaster
		}
	*Spec 4: DD non-casual placebo (robustness)
forvalues j=3(-1)0{
		reg L`j'.emp i.tgroupnc if absmid==tm(2020m2) & casual==0, robust
		outreg2 using casual_emp.xls, excel append ctitle(L`j'_nc) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp i.tgroupnc if absmid==tm(2020m2) & casual==0, robust
		outreg2 using casual_emp.xls, excel append ctitle(F`j'_nc) stats(coef se tstat pval) noaster
		}
	*Spec 5: DD excluding multi job holders (robustness)
forvalues j=3(-1)0{
		reg L`j'.emp i.tgroup if absmid==tm(2020m2) & onejob==1, robust
		outreg2 using casual_emp.xls, excel append ctitle(L`j'_mult) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp i.tgroup if absmid==tm(2020m2) & onejob==1, robust
		outreg2 using casual_emp.xls, excel append ctitle(F`j'_mult) stats(coef se tstat pval) noaster
		}
	*Spec 6: DD with standard errors clustered at the 2-digit industry level (robustness)
forvalues j=3(-1)0{
		reg L`j'.emp i.tgroup if absmid==tm(2020m2), cluster(ind06_2dig_str)
		outreg2 using casual_emp.xls, excel append ctitle(L`j'_clus) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp i.tgroup if absmid==tm(2020m2), cluster(ind06_2dig_str)
		outreg2 using casual_emp.xls, excel append ctitle(F`j'_clus) stats(coef se tstat pval) noaster
		}
	*Spec 7: Tenure gradient in employment for those with <=10 months tenure in Feb (robustness)
forvalues j=3(-1)0{
		reg L`j'.emp tenurmth if absmid==tm(2020m2) & tenurmth>=1 & tenurmth<=10 & casual==1, robust
		outreg2 using casual_emp.xls, excel append ctitle(L`j'_grad) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp tenurmth if absmid==tm(2020m2) & tenurmth>=1 & tenurmth<=10 & casual==1, robust
		outreg2 using casual_emp.xls, excel append ctitle(F`j'_grad) stats(coef se tstat pval) noaster
		}
		
erase casual_emp.txt

/*******************************************************************************
	2 - Hours worked and alternative measures of employment
*******************************************************************************/	

capture {
erase casual_other.txt
erase casual_other.xls 
}

*Loops over dependent variables and months j
foreach dv in emp_broad ch_emp_narrow ch_hrs {

	*Spec 1: DD (main specification)
forvalues j=3(-1)0{
		reg L`j'.`dv' i.tgroup if absmid==tm(2020m2), robust
		outreg2 using casual_other.xls, excel append ctitle(L`j'_`dv') stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.`dv' i.tgroup if absmid==tm(2020m2), robust
		outreg2 using casual_other.xls, excel append ctitle(F`j'_`dv') stats(coef se tstat pval) noaster
		}
		}
erase casual_other.txt

/*******************************************************************************
	3 - Alternative identification strategy
*******************************************************************************/	

capture {
erase migrant_emp.xls
erase migrant_emp.txt
}
		
local controls_mig i.onejob i.ind06div i.occ13skl i.student c.age c.age_sq i.female i.tenure i.empcat

*Loops over months j
	*Spec 1: DD with controls (main specification for this approach)
forvalues j=3(-1)0{
		reg L`j'.emp i.tgroupmig `controls_mig' if absmid==tm(2020m2) & lfstatus==1, robust
		outreg2 using migrant_emp.xls, excel append ctitle(L`j') stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp i.tgroupmig `controls_mig' if absmid==tm(2020m2) & lfstatus==1, robust
		outreg2 using migrant_emp.xls, excel append ctitle(F`j') stats(coef se tstat pval) noaster
		}
	*Spec 2: DD with controls and allowing heterogenous effects by employment type, imposing constant coefficients for the controls
forvalues j=3(-1)0{
		reg L`j'.emp i.tgroupmig##i.empcat `controls_mig' if absmid==tm(2020m2) & lfstatus==1, robust
		outreg2 using migrant_emp.xls, excel append ctitle(L`j'_ccoef) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp i.tgroupmig##i.empcat `controls_mig' if absmid==tm(2020m2) & lfstatus==1, robust
		outreg2 using migrant_emp.xls, excel append ctitle(F`j'_ccoef) stats(coef se tstat pval) noaster
		}
	*Spec 3: DD with controls and allowing heterogenous effects by employment type, fully interacted
forvalues j=3(-1)0{
		reg L`j'.emp (i.tgroupmig `controls_mig')##i.empcat if absmid==tm(2020m2) & lfstatus==1, robust
		outreg2 using migrant_emp.xls, excel append ctitle(L`j'_fullint) stats(coef se tstat pval) noaster
		}
forvalues j=1/5{		
		reg f`j'.emp (i.tgroupmig `controls_mig')##i.empcat if absmid==tm(2020m2) & lfstatus==1, robust
		outreg2 using migrant_emp.xls, excel append ctitle(F`j'_fullint) stats(coef se tstat pval) noaster
		}	

erase migrant_emp.txt

clear all

*end of do file