*************************************
* Student Survey File				*
* Created by Mike Major				*
* Edited by Tanya Livermore			*
* Date modified: 22 June 2021		*
*************************************	

pause on

*Sample selection options
global full_sample= 0					
* 1 - all data including skimmers, 0 - data excluding skimmers
global drop_potential_teachers= 1 		
* 0 - include 'potential teachers', 1 - drop 'potential teachers'

*Set directories 
cd "Student Survey Data"
global datafolder "Student Survey Data\Data"
global exportfolder "rdp_replication_files"

* Install package to export tables
*ssc install latab
*ssc install labutil
*ssc install outreg2

*Import data
if ${full_sample}==1 {
	use "${datafolder}\StudentSurveyDataWithCATI.dta", clear 
	if ${drop_potential_teachers} ==1 {
		drop if Potential_Teacher==1
		}
	}

if ${full_sample}==0 {
	use "${datafolder}\StudentSurveyDataWeightedWithCATI.dta", clear
	}
	
***********************	
* DATA CLEANING	  		  
***********************		
*Correct 'unknown' school type	
replace School_Sector="Government" if School_Sector=="Unknown" & StratumFinal=="Regional Government"

*Generate dummy variables variables. Blank if not applicable (-1/-2/-3 in raw data)
gen male=0
replace male=1 if Gender_missing=="Male":Gender_missing 
*uses binary variable

gen nonbinary = 0
replace nonbinary = 1 if GENDER!="Male":GENDER & GENDER!="Female":GENDER

gen econstu=.
replace econstu=0 if ECONSTU=="No":ECONSTU	
replace econstu=1 if ECONSTU=="Yes":ECONSTU

gen bilingual=.
replace bilingual=0 if CALD=="No":CALD 
replace bilingual=1 if CALD=="Yes":CALD 

gen year10=.
replace year10=0 if YEAR!="Year 10":YEAR
replace year10=1 if YEAR=="Year 10":YEAR

gen sel_process_started = .
replace sel_process_started = 1 if YEAR=="Year 10":YEAR & Q6=="Yes":Q6
replace sel_process_started = 0 if YEAR=="Year 10":YEAR & Q6=="No":Q6	

*Generate ICSEA quartiles 
gen ICSEA_q = 1
replace ICSEA_q = 2 if ICSEA>932
replace ICSEA_q = 3 if ICSEA>999
replace ICSEA_q = 4 if ICSEA>1067
label define ICSEA_labels 1 "ICSEA q1" 2 "ICSEA q2" 3 "ICSEA q3" 4 "ICSEA q4"
label values ICSEA_q ICSEA_labels
	
*Divide ICSEA by 100 to make a one unit increase equivalent to a one s.d. increase
replace ICSEA = ICSEA / 100
	
*Generate dummies for regressions
gen school_reg = 0
replace school_reg = 1 if School_Region!="Major Cities"
label define school_reg_labels 0 "Metro" 1 "Regional"
label values school_reg school_reg_labels 
gen school_metro = 0 
replace school_metro = 1 if School_Region=="Major Cities"
gen school_innerreg = 0 
replace school_innerreg = 1 if School_Region=="Inner Regional Australia"	
gen school_outerreg = 0 
replace school_outerreg = 1 if School_Region=="Outer Regional Australia"
gen school_remote = 0 
replace school_remote = 1 if School_Region=="Remote and offshore"	
gen school_sel = 0
replace school_sel = 1 if School_School_Type=="Selective"	
gen school_nonsel = 0
replace school_nonsel = 1 if School_School_Type=="Non-selective"	
gen school_allboys = 0
replace school_allboys = 1 if School_CoEd_2018=="B"	
gen school_coed = 0
replace school_coed = 1 if School_CoEd_2018=="C"	
gen school_allgirls = 0
replace school_allgirls = 1 if School_CoEd_2018=="G" 	
gen school_singlesex = 0	
replace school_singlesex = 1 if School_CoEd_2018=="G" | School_CoEd_2018=="B" 		
gen school_catholic = 0
replace school_catholic = 1 if School_Sector=="Catholic" 	
gen school_gov = 0
replace school_gov = 1 if School_Sector=="Government"	
gen school_independent = 0
replace school_independent = 1 if School_Sector=="Independent" 	
gen school_nongov = 0
replace school_nongov = 1 if School_Sector=="Catholic" | School_Sector=="Independent" 	
gen school_ses1 = 0
replace school_ses1 = 1 if School_SES4tile_2018==1	
gen school_ses2 = 0
replace school_ses2 = 1 if School_SES4tile_2018==2	
gen school_ses3 = 0
replace school_ses3 = 1 if School_SES4tile_2018==3	
gen school_ses4 = 0
replace school_ses4 = 1 if School_SES4tile_2018==4	
gen school_icsea1 = 0
replace school_icsea1 = 1 if ICSEA_q==1	
gen school_icsea2 = 0
replace school_icsea2 = 1 if ICSEA_q==2	
gen school_icsea3 = 0
replace school_icsea3 = 1 if ICSEA_q==3	
gen school_icsea4 = 0
replace school_icsea4 = 1 if ICSEA_q==4	

*Generate variable for whether school offers/teaches Economics
gen offersOrTeaches = 0
replace offersOrTeaches = 1 if Q3a_4=="Yes":Q3a_4 | Q3b_4=="Yes":Q3b_4
label define offersOrTeaches_labels 1 "Offers" 0 "Does not offer" 
label values offersOrTeaches offersOrTeaches_labels
gen offers = 0
replace offers = 1 if Q3b_4=="Yes":Q3b_4
gen teaches = 0
replace teaches = 1 if Q3a_4=="Yes":Q3a_4
	
*Recode ranking variables to be blank if NA (add prefix 'n')
recode SS_FAC_RANK* (-1 -2 -3 = .), pre(n) label(ranklabels)

*Recode agree/disagree variables so that higher number means more agreement, recode NA/skipped/dont know to missing (add prefix 'n')
recode SS_IMP* ECON_PERC* ECON_G_PERC* (1=5 "Strongly agree") (2=4 "Tend to agree") (3=3 "Neither agree nor disagree") (4=2 "Tend to disagree") (5=1 "Strongly disagree") (-1 -2 -3 99 = .), pre(n) label(recoded)

*Recode yes/no variables
*rename text variables temporarily in order to bulk recode to other variables that follow the pattern
rename SS_FAC_OTH_TEXT textSS_FAC_OTH_TEXT 
rename SS_INFO_OTH_TEXT textSS_INFO_OTH_TEXT
rename ECON_REASON_OTH_TEXT textECON_REASON_OTH_TEXT
rename ECON_INFO_OTH_TEXT textECON_INFO_OTH_TEXT
rename SS_FAC_RANK* rankSS_FAC_RANK*
rename LANGUAGES_OTH textLANGUAGES_OTH
*remove labels with ` symbols as this complicates some exporting of tables
label variable SS_FAC_FWORK "What Id like to do for work in the future"
label variable SS_FAC_NOCHOICE "I didnt get to choose my subjects"
label variable SS_FAC_DK "Dont know/not answered"

recode Y10* SS_FAC* SS_INFO* TOPICS_INT* ECON_REASON* ECON_INFO* LANGUAGES* (-1 -2 -3 = .) (0 = 0 "No") (1 = 1 "Yes"), pre(n) label(yesnolabels)

*Restore variable naming for rank
rename rankSS_FAC_RANK*	  SS_FAC_RANK* 
			
*Rename variables 
foreach x of varlist Y10* SS_FAC* SS_INFO* TOPICS_INT* ECON_REASON* ECON_INFO* SS_FAC_RANK* SS_IMP* ECON_PERC* ECON_G_PERC* {
	local n : var label `x'
	local newvar = "n" + "`x'"
	label var `newvar' "`n'"
	}

*Reasons for choosing subjects, ranked #1,
recode nSS_FAC_RANK* (0 2 3 4 5 = 0), pre(first) label(ranklabels)

*Restore variable naming for text variables
rename textSS_FAC_OTH_TEXT SS_FAC_OTH_TEXT
rename textSS_INFO_OTH_TEXT SS_INFO_OTH_TEXT
rename textECON_REASON_OTH_TEXT ECON_REASON_OTH_TEXT
rename textECON_INFO_OTH_TEXT ECON_INFO_OTH_TEXT
rename textLANGUAGES_OTH LANGUAGES_OTH

*Create dummy variables for each subject
forval x = 101(1)153 {
	gen subj`x' = 0 if CERT_SUBJ1>0 | CERT_SUBJ2>0 | CERT_SUBJ3>0 | CERT_SUBJ4>0 | CERT_SUBJ5>0 | CERT_SUBJ6>0 | CERT_SUBJ7>0 | CERT_SUBJ8>0 
	*gen variable only if they have reported at least 1 subject
	replace subj`x' = 1 if CERT_SUBJ1==`x' | CERT_SUBJ2==`x' | CERT_SUBJ3==`x' | CERT_SUBJ4==`x' | CERT_SUBJ5==`x' | CERT_SUBJ6==`x' | CERT_SUBJ7==`x' | CERT_SUBJ8==`x' 
	}
forval x = 201(1)254 {
	gen subj`x' = 0 if CERT_SUBJ1>0 | CERT_SUBJ2>0 | CERT_SUBJ3>0 | CERT_SUBJ4>0 | CERT_SUBJ5>0 | CERT_SUBJ6>0 | CERT_SUBJ7>0 | CERT_SUBJ8>0
	replace subj`x' = 1 if CERT_SUBJ1==`x' | CERT_SUBJ2==`x' | CERT_SUBJ3==`x' | CERT_SUBJ4==`x' | CERT_SUBJ5==`x' | CERT_SUBJ6==`x' | CERT_SUBJ7==`x' | CERT_SUBJ8==`x'
	}		

*Recode school as offering Economics where a student has recorded that they are an Economics student, but school is recorded as not teaching Economics from administrative data 
destring SchoolID, replace
list SchoolID econstu Econ_tot if econstu==1 & Econ_tot==0
replace Econ_tot=1 if SchoolID==6570|SchoolID==3004|SchoolID==8663|SchoolID==3488|SchoolID==3353

*Recode school as not offering Economics where not merged from NESA data but recorded as not offering Economics in CATI data 
replace Econ_tot=0 if SchoolID==5032|SchoolID==8504
 
save "${datafolder}\survey_data_recoded.dta", replace


***********************	
**Table A1 and A2: Sample, by School and Student Characteristics		  
***********************	
*Preferred sample
if ${full_sample}==0 {
	*Unweighted data
	tabout YEAR using "${exportfolder}\coverage.xls", f(0) h3(nil) replace 
	tabout GENDER using "${exportfolder}\coverage.xls", f(0) h3(nil) append 
	tabout School_CoEd_2018 using "${exportfolder}\coverage.xls", f(0) h3(nil) append 
	tabout ICSEA_q using "${exportfolder}\coverage.xls", f(0) append 
	tabout School_Sector using "${exportfolder}\coverage.xls", f(0) h3(nil) append 
	tabout School_Region using "${exportfolder}\coverage.xls", f(0) h3(nil) append 
	tabout School_School_Type using "${exportfolder}\coverage.xls", f(0) h3(nil) append 	
	tabout school_reg using "${exportfolder}\coverage.xls", f(0) append 	
	tabout ECONSTU using "${exportfolder}\coverage.xls", f(0) append 	
	tabout ECONSTUPAST using "${exportfolder}\coverage.xls", f(0) append 	
	tabout CALD using "${exportfolder}\coverage.xls", f(0) append 			
	tabout YEAR GENDER using "${exportfolder}\coverage.xls", f(0) h3(nil) append
	tabout YEAR ECONSTU using "${exportfolder}\coverage.xls"  if YEAR=="Year 12":YEAR | YEAR=="Year 11":YEAR, f(0) h3(nil) append
	tabout GENDER ECONSTU using "${exportfolder}\coverage.xls"  if YEAR=="Year 12":YEAR | YEAR=="Year 11":YEAR, f(0) h3(nil) append	 	
	*Weighted data
	tabout YEAR using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) h3(nil) replace 
	tabout GENDER using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) h3(nil) append 
	tabout School_CoEd_2018 using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) h3(nil) append 
	tabout ICSEA_q using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0)  append 
	tabout School_Sector using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) h3(nil) append 
	tabout School_Region using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) h3(nil) append 
	tabout School_School_Type using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) h3(nil) append 	
	tabout school_reg using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) append 		
	tabout ECONSTU using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) append 	
	tabout ECONSTUPAST using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0)  append 	
	tabout CALD using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0)  append 			
	tabout YEAR GENDER using "${exportfolder}\coverageB.xls" [aw=WeightB], f(0) h3(nil) append
	tabout YEAR ECONSTU using "${exportfolder}\coverageB.xls"  if YEAR=="Year 12":YEAR | YEAR=="Year 11":YEAR [aw=WeightB], f(0) h3(nil) append
	tabout GENDER ECONSTU using "${exportfolder}\coverageB.xls"  if YEAR=="Year 12":YEAR | YEAR=="Year 11":YEAR [aw=WeightB], f(0) h3(nil) append
	}

*Include potential skimmers	
if ${full_sample}==1 & ${drop_potential_teachers} == 0 {
	tabout YEAR using "${exportfolder}\coverageFull.xls", f(0) h3(nil) replace 
	tabout GENDER using "${exportfolder}\coverageFull.xls", f(0) h3(nil) append 
	tabout School_CoEd_2018 using "${exportfolder}\coverageFull.xls", f(0) h3(nil) append 
	tabout ICSEA_q using "${exportfolder}\coverageFull.xls", f(0) append 
	tabout School_Sector using "${exportfolder}\coverageFull.xls", f(0) h3(nil) append 
	tabout School_Region using "${exportfolder}\coverageFull.xls", f(0) h3(nil) append 
	tabout School_School_Type using "${exportfolder}\coverageFull.xls", f(0) h3(nil) append 	
	tabout school_reg using "${exportfolder}\coverageFull.xls", f(0) append 	
	tabout ECONSTU using "${exportfolder}\coverageFull.xls", f(0) append 	
	tabout ECONSTUPAST using "${exportfolder}\coverageFull.xls", f(0) append 	
	tabout CALD using "${exportfolder}\coverageFull.xls", f(0) append 			
	tabout YEAR GENDER using "${exportfolder}\coverageFull.xls", f(0) h3(nil) append
	tabout YEAR ECONSTU using "${exportfolder}\coverageFull.xls"  if YEAR=="Year 12":YEAR | YEAR=="Year 11":YEAR, f(0) h3(nil) append
	tabout GENDER ECONSTU using "${exportfolder}\coverageFull.xls"  if YEAR=="Year 12":YEAR | YEAR=="Year 11":YEAR, f(0) h3(nil) append		
	}

*Include potential skimmers and potential teachers	
if ${full_sample}==1 & ${drop_potential_teachers} == 1 {
	tabout YEAR using "${exportfolder}\coverageFullNoTeachers.xls", f(0) h3(nil) replace 
	tabout GENDER using "${exportfolder}\coverageFullNoTeachers.xls", f(0) h3(nil) append 
	tabout School_CoEd_2018 using "${exportfolder}\coverageFullNoTeachers.xls", f(0) h3(nil) append 
	tabout ICSEA_q using "${exportfolder}\coverageFullNoTeachers.xls", f(0) append 
	tabout School_Sector using "${exportfolder}\coverageFullNoTeachers.xls", f(0) h3(nil) append 
	tabout School_Region using "${exportfolder}\coverageFullNoTeachers.xls", f(0) h3(nil) append 
	tabout School_School_Type using "${exportfolder}\coverageFullNoTeachers.xls", f(0) h3(nil) append 	
	tabout school_reg using "${exportfolder}\coverageFullNoTeachers.xls", f(0) append 	
	tabout ECONSTU using "${exportfolder}\coverageFullNoTeachers.xls", f(0) append 	
	tabout ECONSTUPAST using "${exportfolder}\coverageFullNoTeachers.xls", f(0) append 	
	tabout CALD using "${exportfolder}\coverageFullNoTeachers.xls", f(0) append 			
	tabout YEAR GENDER using "${exportfolder}\coverageFullNoTeachers.xls", f(0) h3(nil) append
	tabout YEAR ECONSTU using "${exportfolder}\coverageFullNoTeachers.xls"  if YEAR=="Year 12":YEAR | YEAR=="Year 11":YEAR, f(0) h3(nil) append
	tabout GENDER ECONSTU using "${exportfolder}\coverageFullNoTeachers.xls"  if YEAR=="Year 12":YEAR | YEAR=="Year 11":YEAR, f(0) h3(nil) append		
	}	
	
***********************	
*Table 2: Likelihood of Studying Economics		  
***********************	
*NESA ADMIN DATA
import excel using "NESA and ACARA 2019 Data.xlsx", firstrow clear
replace EconShare = EconShare * 100
replace ICSEA = ICSEA/100
label variable ICSEA "ICSEA"
label variable EconSchool "School teaches Economics"
label variable EconShare "Share of students studying Economics"

*Generate same variable names as survey data
gen school_nongov = Nongov
label variable school_nongov "Non-government"
gen school_reg = Reg
label variable school_reg "Regional"
gen school_allboys = AllB
label variable school_allboys "All-boys"
gen school_allgirls = AllG
label variable school_allgirls "All-girls"

*Run probit models. Save average marginal effects
* Probit - EconSchool (Column 1)
probit EconSchool school_nongov school_reg ICSEA school_allboys school_allgirls Courses HSCSIZE, ro
margins, dydx(*) post
outreg2 using "${exportfolder}\reg_likelihood.xls", replace label stats(coef) dec(2) addtext(Method, Probit1)

* Heckman - EconShare (Column 2)
recode EconShare (0=.), gen(CEconShare)
heckman CEconShare school_nongov school_reg ICSEA school_allboys school_allgirls Courses, select (school_nongov school_reg ICSEA school_allboys school_allgirls HSCSIZE Courses) vce(robust)  
outreg2 using "${exportfolder}\reg_likelihood.xls", append label stats(coef) dec(2) addtext(Method, Heckman2)
* [DELETE] margins, dydx(school_nongov school_reg ICSEA school_allboys school_allgirls Courses) predict(ycond) post

***********************************************

* SURVEY DATA 
use "Data\survey_data_recoded.dta", clear
* Limit to Year 11 and 12 students only 
drop if YEAR==1
gen EconSchool = Econ_tot 
rename HSCawards HSCSIZECAT 

*** MAIN ESTIMATES

*Heckman probit - school variables (Column 3)
heckprobit econstu male bilingual ICSEA school_reg school_nongov school_allboys school_allgirls Courses, select (EconSchool = male bilingual ICSEA school_reg school_nongov school_allboys school_allgirls Courses ib1.HSCSIZECAT) vce(cluster CATI_Serial)  
margins, dydx(*) post
outreg2 using "${exportfolder}\reg_likelihood.xls", append label stats(coef) dec(2) addtext(Method, Heckprob3)

* Probit - school variables (Column 4)
probit econstu male bilingual ICSEA school_reg school_nongov school_allboys school_allgirls Courses if EconSchool==1, vce(cluster CATI_Serial) 
margins, dydx(*) post
outreg2 using "${exportfolder}\reg_likelihood.xls", append label stats(coef) dec(2) addtext(Method, Probit4)

*Heckman probit - school and individual variables (Column 5)
heckprobit econstu male bilingual ICSEA school_reg school_nongov school_allboys school_allgirls Courses nECON_PERC_INT nECON_PERC_UND nECON_PERC_ATAR, select (EconSchool = male bilingual ICSEA school_reg school_nongov school_allboys school_allgirls Courses ib1.HSCSIZECAT nECON_PERC_INT nECON_PERC_UND nECON_PERC_ATAR) vce(cluster CATI_Serial) 
margins, dydx(*) post
outreg2 using "${exportfolder}\reg_likelihood.xls", append label stats(coef) dec(2) addtext(Method, Heckprob5)

* Probit - school and individual variables (Column 6)
probit econstu male bilingual ICSEA school_reg school_nongov school_allboys school_allgirls Courses nECON_PERC_INT nECON_PERC_UND nECON_PERC_ATAR if EconSchool==1, vce(cluster CATI_Serial) 
margins, dydx(*) post
outreg2 using "${exportfolder}\reg_likelihood.xls", append label stats(coef) dec(2) addtext(Method, Probit6)

* Robustness: The results are also robust to the inclusion of controls for the other subjects studied. 
*rename Economics so it is not included
rename subj116 TEMPsubj116 
probit econstu male bilingual ICSEA school_reg school_nongov school_allboys school_allgirls ib2.Courses nECON_PERC_INT nECON_PERC_UND nECON_PERC_ATAR subj*,  vce(cluster CATI_Serial) 
margins, dydx(*) post
outreg2 using "${exportfolder}\reg_likelihood.xls", append label stats(coef) dec(2) addtext(Method, Heckprob)
rename TEMPsubj116 subj116 





***********************	
*Table 3: Perceptions of Economics – Descriptive Statistics
***********************			
use "Data\survey_data_recoded.dta", clear

*Create dummies for each response on 5-point Likert scale
foreach x of varlist nECON_PERC_UND nECON_PERC_INT nECON_PERC_WELL nECON_PERC_GOOD nECON_PERC_KNOW nECON_PERC_RISK nECON_PERC_TEACHER nECON_PERC_INTEL nECON_PERC_MATH nECON_PERC_WLOAD nECON_PERC_ATAR nECON_PERC_IMP nECON_PERC_EVERYDAY nECON_G_PERC_SOC nECON_G_PERC_MONEY nECON_PERC_BUSEASY nECON_PERC_BUSUSE nECON_PERC_BUSINT nECON_PERC_CAREER nECON_G_PERC_CAREER nECON_G_PERC_MEN  {

	*Generate dummies for SA,A,N,D,SD,DK
	gen sa_`x' = 0 if `x' >= 1 & `x' <= 5 // strongly agree
	replace sa_`x' = 1 if `x'==5
	gen a_`x' = 0 if `x' >= 1 & `x' <= 5  // agree
	replace a_`x' = 1 if `x'==4
	gen n_`x' = 0 if `x' >= 1 & `x' <= 5  // neither
	replace n_`x' = 1 if `x'==3	
	gen d_`x' = 0 if `x' >= 1 & `x' <= 5  // disagree
	replace d_`x' = 1 if `x'==2
	gen sd_`x' = 0 if `x' >= 1 & `x' <= 5 // strongly disagree
	replace sd_`x' = 1 if `x'==1
	}	

foreach x of varlist  nECON_PERC_UND nECON_PERC_INT nECON_PERC_WELL nECON_PERC_GOOD nECON_PERC_KNOW nECON_PERC_RISK nECON_PERC_TEACHER nECON_PERC_INTEL nECON_PERC_MATH nECON_PERC_WLOAD nECON_PERC_ATAR nECON_PERC_IMP nECON_PERC_EVERYDAY nECON_G_PERC_SOC nECON_G_PERC_MONEY nECON_PERC_BUSEASY nECON_PERC_BUSUSE nECON_PERC_BUSINT nECON_PERC_CAREER nECON_G_PERC_CAREER nECON_G_PERC_MEN {
	ttest sa_`x'=sd_`x'
	scalar p_stnb_`x' = r(p)
	gen asa_`x' = sa_`x' + a_`x'
	gen dsd_`x' = sd_`x' + d_`x'
	ttest asa_`x'=dsd_`x'
	scalar p_nb`x' = r(p)	
	tabstat sa_`x' a_`x' d_`x' sd_`x' [aw=WeightB], save
	mat nb_means = r(StatTotal) 
	gen tot_sa_`x' = nb_means[1,1]
	gen tot_a_`x' = nb_means[1,2]
	gen tot_d_`x' = nb_means[1,3]
	gen tot_sd_`x' = nb_means[1,4]
	scalar snb_`x' = tot_sa_`x' - tot_sd_`x'
	scalar nb_`x' = tot_sa_`x' + tot_a_`x' - tot_d_`x' - tot_sd_`x'	
	}
scalar list _all

***********************	
*Table 4: Perceptions of Economics – Regression Results
***********************	

*Create blank export files with 'replace' option
gen ones = 1
oprobit subj101 ones, ro
outreg2 using "${exportfolder}\reg_perceptions.xls", replace label stats(coef) 
outreg2 using "${exportfolder}\reg_perceptions_marginal.xls", replace label stats(coef)
outreg2 using "${exportfolder}\reg_perceptions_under.xls", replace label stats(coef) 
outreg2 using "${exportfolder}\reg_perceptions_under_marginal.xls", replace label stats(coef)
outreg2 using "${exportfolder}\reg_perceptions_marginal_1.xls", replace label stats(coef)

*Default regression table
foreach x of varlist nECON_PERC_UND nECON_PERC_INT nECON_PERC_WELL nECON_PERC_GOOD nECON_PERC_KNOW nECON_PERC_RISK nECON_PERC_TEACHER nECON_PERC_INTEL nECON_PERC_MATH nECON_PERC_WLOAD nECON_PERC_ATAR nECON_PERC_IMP nECON_PERC_EVERYDAY nECON_G_PERC_SOC nECON_G_PERC_MONEY nECON_PERC_BUSEASY nECON_PERC_BUSUSE nECON_PERC_BUSINT nECON_PERC_CAREER nECON_G_PERC_CAREER nECON_G_PERC_MEN {
	local varlab = "`x'"
	oprobit `x' male ICSEA bilingual  school_nongov school_allboys school_allgirls, ro cluster(CATI_Serial)
	outreg2 using "${exportfolder}\reg_perceptions.xls", append label stats(coef) drop(`x' i.CATI_Serial cut) dec(2) addtext(Cluster, School) addstat(Pseudo R2, e(r2_p))
	oprobit `x' male ICSEA bilingual  school_nongov school_allboys school_allgirls, ro cluster(CATI_Serial)	
	margins, dydx(*) predict(outcome(5)) post
	estimates store y
	outreg2 y using "${exportfolder}\reg_perceptions_marginal.xls", append stats(coef) dec(2) ctitle(`varlab')	
	}

*Robustness: Re-estimate the regressions controlling for students’ perceived understanding of Economics
foreach x of varlist  nECON_PERC_INT nECON_PERC_WELL nECON_PERC_GOOD nECON_PERC_KNOW nECON_PERC_RISK nECON_PERC_TEACHER nECON_PERC_INTEL nECON_PERC_MATH nECON_PERC_WLOAD nECON_PERC_ATAR nECON_PERC_IMP nECON_PERC_EVERYDAY nECON_G_PERC_SOC nECON_G_PERC_MONEY nECON_PERC_BUSEASY nECON_PERC_BUSUSE nECON_PERC_BUSINT nECON_PERC_CAREER nECON_G_PERC_CAREER nECON_G_PERC_MEN {
	local varlab = "`x'"
	oprobit `x' male ICSEA bilingual school_nongov school_allboys school_allgirls nECON_PERC_UND, ro cluster(CATI_Serial)
	outreg2 using "${exportfolder}\reg_perceptions_under.xls", append label stats(coef) drop(`x' i.CATI_Serial cut) dec(2) addtext(Cluster, School) addstat(Pseudo R2, e(r2_p))
	oprobit `x' male ICSEA bilingual school_nongov school_allboys school_allgirls nECON_PERC_UND, ro cluster(CATI_Serial)	
	margins, dydx(*) predict(outcome(5)) post
	estimates store y
	outreg2 y using "${exportfolder}\reg_perceptions_under_marginal.xls", append stats(coef) dec(2) ctitle(`varlab')	
	}
	
*Robustness: Calculated at ‘5 - Strongly agree’. Results are robust to calculating at ‘1 – Strongly disagree’
	foreach x of varlist nECON_PERC_UND nECON_PERC_INT nECON_PERC_WELL nECON_PERC_GOOD nECON_PERC_KNOW nECON_PERC_RISK nECON_PERC_TEACHER nECON_PERC_INTEL nECON_PERC_MATH nECON_PERC_WLOAD nECON_PERC_ATAR nECON_PERC_IMP nECON_PERC_EVERYDAY nECON_G_PERC_SOC nECON_G_PERC_MONEY nECON_PERC_BUSEASY nECON_PERC_BUSUSE nECON_PERC_BUSINT nECON_PERC_CAREER nECON_G_PERC_CAREER nECON_G_PERC_MEN {
	local varlab = "`x'"
	oprobit `x' male ICSEA bilingual  school_nongov school_allboys school_allgirls, ro cluster(CATI_Serial)	
	margins, dydx(*) predict(outcome(1)) post
	estimates store y
	outreg2 y using "${exportfolder}\reg_perceptions_marginal_1.xls", append stats(coef) dec(2) ctitle(`varlab')		
	}

	
	