cd "<place directory here>\excel"
use "<place directory here>\data\long-file-cleaned.dta", clear

** Figure 1
	preserve
	collapse firedprob [aw=hhwth], by(year)
	export excel using "figure1", sheetreplace
	restore

** Figure 2

	hist jlbucket
	tab2xl jlbucket using "figure2", col(1) row(1) replace

** Figure 3
	hist suitbucket if unemp == 1
	tab2xl suitbucket if unemp == 1 using "figure3", col(1) row(1) replace

** Figure 4
	preserve
	g fired100 = fired*100
	g ljob100 = leftjob*100
	g ljoborfired = fired100 + ljob100
	g line45deg = 5 if lagjlbucket == 10
	forvalues i = 2(1)10 {
		replace line45deg = `i'*10-5 if lagjlbucket == `i'*10
	}
	collapse (mean) ljoborfired (mean) fired100 (mean) line45deg [aw=hhwth], by(lagjlbucket)
	twoway line ljoborfired lagjlbucket || line fired100 lagjlbucket || line line45deg lagjlbucket
	drop if lagjlbucket == . 
	export excel using "figure4", sheetreplace firstrow(varlabels)
	restore

** Figure 5
	*Stage 1
	qui logit fired lfiredprob female healthprob l1.jtenure l1.jtenuresq l1.parttime l1.casual l1.fixedterm l1.lpdinc uni tafe age age2 urate l1.i.industry , 
	predict pfired, pr 
	g difference = lfiredprob/100 - pfired 
	
	*Stage 2
	qui xtreg difference i.year, fe cl(xwaveid)
	predict deviation, u 
	replace deviation = deviation+_b[_cons]

	preserve 
	collapse(mean) deviation, by(xwaveid)
	drop if deviation == .
	egen category = cut(deviation), at(-1(0.1)1.1)
	g count = 1 
	collapse(sum) count, by(category)
	egen tot = sum(count)
	g pct = count*100/tot
	drop count tot
	
	export excel using "figure5" , sheetreplace firstrow(varlabels)
	restore
	
	drop pfired deviation
	
** Figure 6
	qui xtreg difference i.year, fe cl(xwaveid)
	g cons = _b[_cons]
	qui margins, dydx(i.year)
	matrix B = r(b)
	matrix V = r(V)
	gen dydx = .
	gen se_dydx = .
	forvalues g = 2/18 {
		replace dydx = B[1, `g'] if year == `g'+2001
		replace se_dydx = sqrt(V[`g', `g']) if year == `g'+2001
	}
	preserve 
	replace lfiredprob=lfiredprob/100
	collapse(mean) fired lfiredprob difference dydx se_dydx cons, by(year)
	twoway line dydx year 
	export excel using "figure6" , sheetreplace firstrow(varlabels)
	restore 

** Figure 7
	preserve
	g find = (f.esbrd == 1)
	replace find=1 if f.lefrd == 2
	replace find = . if unemp!=1
	g find100 = find*100
	g line45deg = 5 if suitbucket == 10
	forvalues i = 2(1)10 {
		replace line45deg = `i'*10-5 if suitbucket == `i'*10
	}
	collapse (mean) find100 (mean) line45deg [aw=hhwth], by(suitbucket)
	twoway line find100 suitbucket || line line45deg suitbucket
	drop if suitbucket == . 
	export excel using "$excel/figure7", sheetreplace firstrow(varlabels)
	restore

** Figure 8
*** Duration (quarters) of unemployment (actual)
	g qunempb = 0 if jstwks>0 & jstwks<=12
	forvalues i = 1/12 {
		replace qunempb = `i' if jstwks>12*`i' & jstwks<=12*`i'+12
	}
	replace qunempb = . if unemp!=1

	reg suitprob i.qunempb if unemp == 1, r
	outreg2 using "$excel/figure8", ctitle(Top panel) nocons stats(coef) noaster excel replace
	outreg2 using "$excel/figure8", ctitle(Top panel) nocons stats(ci_low) excel append
	outreg2 using "$excel/figure8", ctitle(Top panel) nocons stats(ci_high) excel append
	coefplot, vertical drop(_cons)

	xtreg suitprob i.qunempb if unemp == 1, fe
	outreg2 using "$excel/figure8", ctitle(Bottom panel) nocons stats(coef) noaster excel append
	outreg2 using "$excel/figure8", ctitle(Bottom panel) nocons stats(ci_low) excel append
	outreg2 using "$excel/figure8", ctitle(Bottom panel) nocons stats(ci_high) excel append
	coefplot, vertical drop(_cons)

save as long-file-cleaned