** From Section 4 onwards - Relationship between unemployment and household spending
cd "<place directory here>\excel"
use "<place directory here>\data\long-file-cleaned.dta", clear

** Figure 9

	tempname figure9
	postfile `figure9' t coeff lower upper using figure9.dta, replace
	forval x = 1(1)6 {
		qui xtreg lnconsall unemp`x' rpersons i.wave if head`x'==1, fe cluster(xwaveid)
		post `figure9' (4-`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}
	postclose `figure9' 

	preserve
	clear
	use "figure9"
	twoway line  coeff lower upper t, title("Grocery Expenditure") subtitle("years relative to unemployment")
	replace coeff = coeff*100
	replace lower = lower*100
	replace upper = upper*100
	table t, c(mean coeff mean lower mean upper)
	sort t
	export excel using "figure9", sheetreplace firstrow(varlabels)
	restore

** Figure 10

	tempname figure10a
	postfile `figure10a' t coeff lower upper using figure10a.dta, replace
	forval x = 1(1)7 {
		 qui xtreg lngroc unemp`x' rpersons i.wave if head`x'==1, fe cluster(xwaveid)
		post `figure10a' (4-`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}

	postclose `figure10a'

	tempname figure10b
	postfile `figure10b' t coeff lower upper using figure10b.dta, replace
	forval x = 1(1)7 {
		qui xtreg lngroc awagesh unemp`x' rpersons i.wave if head`x'==1, fe cluster(xwaveid)
		post `figure10b' (4-`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}
	postclose `figure10b'

	preserve
	clear
	use "figure10b"
	gen wages = 1
	append using "figure10a"
	replace wages = 0 if wages ==.
	replace coeff = coeff*100
	replace lower = lower*100
	replace upper = upper*100
	table t, c(mean coeff mean lower mean upper)
	sort wages t
	export excel using "figure10", sheetreplace firstrow(varlabels)
	twoway line  coeff lower upper t if wages == 1, title("Expenditure on Groceries - with Wage Controls") subtitle("years relative to unemployment") || line  coeff lower upper t if wages == 0
	restore

** Figure 11

	tempname figure11a
	postfile `figure11a' t coeff lower upper using figure11a.dta, replace
	forval x = 1(1)7 {
		 qui xtreg aeatout unemp`x' rpersons i.wave if head`x'==1, fe cluster(xwaveid)
		post `figure11a' (4-`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}

	postclose `figure11a'

	tempname figure11b
	postfile `figure11b' t coeff lower upper using figure11b.dta, replace
	forval x = 1(1)7 {
		qui xtreg aeatout awagesh unemp`x' rpersons i.wave if head`x'==1, fe cluster(xwaveid)
		post `figure11b' (4-`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}
	postclose `figure11b'

	preserve
	clear
	use "figure11b"
	gen wages = 1
	append using "figure11a"
	replace wages = 0 if wages ==.
	replace coeff = coeff*100
	replace lower = lower*100
	replace upper = upper*100
	table t, c(mean coeff mean lower mean upper)
	sort wages t
	export excel using "figure11", sheetreplace firstrow(varlabels)
	twoway line  coeff lower upper t if wages == 1, title("Expenditure on Eating out - with Wage Controls") subtitle("years relative to unemployment") || line  coeff lower upper t if wages == 0
	restore
	
** Figure 12
	
	tempname figure12a
	postfile `figure12a' t coeff lower upper using figure12a.dta, replace
	forval x = 1(1)7 {
		qui xtreg lnhousing unemp`x' rpersons i.wave if head`x'==1, fe cluster(xwaveid)
		post `figure12a' (4-`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}
	postclose `figure12a' 

	** controlling for wages

	tempname figure12b
	postfile `figure12b' t coeff lower upper using figure12b.dta, replace
	forval x = 1(1)7 {
		qui xtreg lnhousing unemp`x' rpersons awagesh i.wave if head`x'==1, fe cluster(xwaveid)
		post `figure12b' (4-`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}
	postclose `figure12b' 

	preserve
	clear
	use "figure12b"
	gen wages = 1
	append using "figure12a"
	replace wages = 0 if wages ==.
	twoway line  coeff lower upper t if wages == 1, title("Expenditure on Housing - with Wage Controls") subtitle("years relative to unemployment") || line  coeff lower upper t if wages == 0
	replace coeff = coeff*100
	replace lower = lower*100
	replace upper = upper*100
	sort wages t
	export excel using "figure12", sheetreplace firstrow(varlabels)
	table t if wages == 1, c(mean coeff mean lower mean upper)
	table t if wages == 0, c(mean coeff mean lower mean upper)
	restore

** Table 2 

	xtreg lngroci rpersons unemp##c.l.firedprob1, fe cluster(xwaveid)
	outreg2 using table2, ctitle("Groceries") dec(2) nocons drop(rpersons) excel replace
	xtreg aeatout rpersons unemp##c.l.firedprob1, fe cluster(xwaveid)
	outreg2 using table2, ctitle("Meals eaten out") dec(2) nocons drop(rpersons) excel append 
	xtreg lnconsall rpersons unemp##c.l.firedprob1, fe cluster(xwaveid)
	outreg2 using table2, ctitle("Total Expenditure") dec(2) nocons drop(rpersons) excel append 
	
** Figure 13
	tempname figure13
	postfile `figure13' t coeff lower upper using figure13.dta, replace
		 xtreg lfcons f.unemphtm rpersons i.wave if head==1 & htm==1, fe cluster(xwaveid)
		post `figure13' (1) (`=_b[f1.unemphtm]') (`=_b[f1.unemphtm]'-`=_se[f1.unemphtm]'*1.96) (`=_se[f1.unemphtm]'*1.96+`=_b[f1.unemphtm]')
		qui xtreg lfcons unemphtm rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure13' (2) (`=_b[unemphtm]') (`=_b[unemphtm]'-`=_se[unemphtm]'*1.96) (`=_se[unemphtm]'*1.96+`=_b[unemphtm]')
		qui xtreg lfcons f.unempnhtm rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure13' (3) (`=_b[f1.unempnhtm]') (`=_b[f1.unempnhtm]'-`=_se[f1.unempnhtm]'*1.96) (`=_se[f1.unempnhtm]'*1.96+`=_b[f1.unempnhtm]')
		qui xtreg lfcons unempnhtm rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure13' (4) (`=_b[unempnhtm]') (`=_b[unempnhtm]'-`=_se[unempnhtm]'*1.96) (`=_se[unempnhtm]'*1.96+`=_b[unempnhtm]')
	postclose `figure13'

	preserve
	clear
	use "figure13.dta"
	sort t
	foreach x in coeff lower upper {
		replace `x'=`x'*100	
	}
	table t, c(mean coeff mean lower mean upper)
	sort t
	export excel using "figure13", sheetreplace firstrow(varlabels)
	twoway scatter coeff lower upper t, title("HTM - food expenditure") subtitle("Before and during unemployment")
	restore
	
** Figure 14
	tempname figure14
	postfile `figure14' t coeff lower upper using figure14.dta, replace
		qui xtreg lfcons f.unempmyop rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure14' (1) (`=_b[f1.unempmyop]') (`=_b[f1.unempmyop]'-`=_se[f1.unempmyop]'*1.96) (`=_se[f1.unempmyop]'*1.96+`=_b[f1.unempmyop]')
		qui xtreg lfcons unempmyop rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure14' (2) (`=_b[unempmyop]') (`=_b[unempmyop]'-`=_se[unempmyop]'*1.96) (`=_se[unempmyop]'*1.96+`=_b[unempmyop]')
		qui xtreg lfcons f.unempnmyop rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure14' (3) (`=_b[f1.unempnmyop]') (`=_b[f1.unempnmyop]'-`=_se[f1.unempnmyop]'*1.96) (`=_se[f1.unempnmyop]'*1.96+`=_b[f1.unempnmyop]')
		qui xtreg lfcons unempnmyop rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure14' (4) (`=_b[unempnmyop]') (`=_b[unempnmyop]'-`=_se[unempnmyop]'*1.96) (`=_se[unempnmyop]'*1.96+`=_b[unempnmyop]')
	postclose `figure14'

	preserve
	clear
	use "figure14.dta"
	sort t
	foreach x in coeff lower upper {
		replace `x'=`x'*100	
	}
	table t, c(mean coeff mean lower mean upper)
	twoway scatter coeff lower upper t, title("Myopia - food expenditure") subtitle("Before and during unemployment")
	sort t
	export excel using "figure14", sheetreplace firstrow(varlabels)
	restore
	
** Figure 15
	tempname figure15
	postfile `figure15' t coeff lower upper using figure15.dta, replace
		qui xtreg lnconsall f.unempmyop rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure15' (1) (`=_b[f1.unempmyop]') (`=_b[f1.unempmyop]'-`=_se[f1.unempmyop]'*1.96) (`=_se[f1.unempmyop]'*1.96+`=_b[f1.unempmyop]')
		qui xtreg lnconsall unempmyop rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure15' (2) (`=_b[unempmyop]') (`=_b[unempmyop]'-`=_se[unempmyop]'*1.96) (`=_se[unempmyop]'*1.96+`=_b[unempmyop]')
		qui xtreg lnconsall f.unempnmyop rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure15' (3) (`=_b[f1.unempnmyop]') (`=_b[f1.unempnmyop]'-`=_se[f1.unempnmyop]'*1.96) (`=_se[f1.unempnmyop]'*1.96+`=_b[f1.unempnmyop]')
		qui xtreg lnconsall unempnmyop rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure15' (4) (`=_b[unempnmyop]') (`=_b[unempnmyop]'-`=_se[unempnmyop]'*1.96) (`=_se[unempnmyop]'*1.96+`=_b[unempnmyop]')
	postclose `figure15'

	preserve
	clear
	use "figure15.dta"
	sort t
	foreach x in coeff lower upper {
		replace `x'=`x'*100	
	}
	table t, c(mean coeff mean lower mean upper)
	twoway scatter coeff lower upper t, title("Myopia - food expenditure") subtitle("Before and during unemployment")
	sort t
	export excel using "figure15", sheetreplace firstrow(varlabels)
	restore
	
** Figure 16
	tempname figure16
	postfile `figure16' t coeff lower upper using figure16.dta, replace
		qui xtreg lfcons f.unempdisc rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure16' (1) (`=_b[f1.unempdisc]') (`=_b[f1.unempdisc]'-`=_se[f1.unempdisc]'*1.96) (`=_se[f1.unempdisc]'*1.96+`=_b[f1.unempdisc]')
		qui xtreg lfcons unempdisc rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure16' (2) (`=_b[unempdisc]') (`=_b[unempdisc]'-`=_se[unempdisc]'*1.96) (`=_se[unempdisc]'*1.96+`=_b[unempdisc]')
		qui xtreg lfcons f.unempnodisc rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure16' (3) (`=_b[f1.unempnodisc]') (`=_b[f1.unempnodisc]'-`=_se[f1.unempnodisc]'*1.96) (`=_se[f1.unempnodisc]'*1.96+`=_b[f1.unempnodisc]')
		qui xtreg lfcons unempnodisc rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure16' (4) (`=_b[unempnodisc]') (`=_b[unempnodisc]'-`=_se[unempnodisc]'*1.96) (`=_se[unempnodisc]'*1.96+`=_b[unempnodisc]')
	postclose `figure16'

	preserve
	clear
	use "figure16.dta"
	sort t
	foreach x in coeff lower upper {
		replace `x'=`x'*100	
	}
	table t, c(mean coeff mean lower mean upper)
	twoway scatter coeff lower upper t, title("Discouraged - food expenditure") subtitle("Before and during unemployment")
	sort t
	export excel using "figure16", sheetreplace firstrow(varlabels)
	restore
	
** Figure 17
	tempname figure17
	postfile `figure17' t coeff lower upper using figure17.dta, replace
		qui xtreg lnconsall f.unempdisc rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure17' (1) (`=_b[f1.unempdisc]') (`=_b[f1.unempdisc]'-`=_se[f1.unempdisc]'*1.96) (`=_se[f1.unempdisc]'*1.96+`=_b[f1.unempdisc]')
		qui xtreg lnconsall unempdisc rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure17' (2) (`=_b[unempdisc]') (`=_b[unempdisc]'-`=_se[unempdisc]'*1.96) (`=_se[unempdisc]'*1.96+`=_b[unempdisc]')
		qui xtreg lnconsall f.unempnodisc rpersons i.wave if head==1, fe cluster(xwaveid)
		post `figure17' (3) (`=_b[f1.unempnodisc]') (`=_b[f1.unempnodisc]'-`=_se[f1.unempnodisc]'*1.96) (`=_se[f1.unempnodisc]'*1.96+`=_b[f1.unempnodisc]')
		qui xtreg lnconsall unempnodisc rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figure17' (4) (`=_b[unempnodisc]') (`=_b[unempnodisc]'-`=_se[unempnodisc]'*1.96) (`=_se[unempnodisc]'*1.96+`=_b[unempnodisc]')
	postclose `figure17'

	preserve
	clear
	use "figure17.dta"
	sort t
	foreach x in coeff lower upper {
		replace `x'=`x'*100	
	}
	table t, c(mean coeff mean lower mean upper)
	sort t
	export excel using "figure17", sheetreplace firstrow(varlabels)
	twoway scatter coeff lower upper t, title("Discouraged - total expenditure") subtitle("Before and during unemployment")
	restore
	
** Figure 18
	tempname figure18a
	postfile `figure18a' t coeff lower upper using figure18a.dta, replace
	forvalues x =  0(8)32{
		qui xtreg lnconsall unempw`x' rpersons i.wave, fe
		post `figure18a' (`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}
	postclose `figure18a' 

	preserve
	clear
	use "figure18a.dta"
	twoway line  coeff lower upper t, title("Total spending") subtitle("% of year unemployed")
	replace coeff = coeff*100
	replace lower = lower*100
	replace upper = upper*100
	export excel using "figure18a", sheetreplace firstrow(varlabels)
	table t, c(mean coeff mean lower mean upper)
	restore
	
	tempname figure18b
	postfile `figure18b' t coeff lower upper using figure18b.dta, replace
	forvalues x =  0(8)32{
		qui xtreg lngroc unempw`x' rpersons i.wave, fe
		post `figure18b' (`x') (`=_b[unemp]') (`=_b[unemp]'-`=_se[unemp]'*1.96) (`=_se[unemp]'*1.96+`=_b[unemp]')
	}
	postclose `figure18b' 

	preserve
	clear
	use "figure18b.dta"
	twoway line  coeff lower upper t, title("Grocery spending") subtitle("% of year unemployed")
	replace coeff = coeff*100
	replace lower = lower*100
	replace upper = upper*100
	sort t
	export excel using "figure18b", sheetreplace firstrow(varlabels)
	table t, c(mean coeff mean lower mean upper)
	restore
	
** Figure 19
	preserve
	xtreg lngroc i.year##unemp rpersons i.year if l.head == 1, fe
	outreg2 using figure19, ctitle(Top panel) nocons stats(coef) noaster excel replace
	outreg2 using figure19, ctitle(Top panel) nocons stats(ci_low) excel append
	outreg2 using figure19, ctitle(Top panel) nocons stats(ci_high) excel append
	resore
	
	** (Here we test controlling for income - not included in paper)
		xtreg lngroc wave##unemp awagesh rpersons i.wave if l.head == 1, fe
	** (Here we test for k=2 and k=1 effects - not included in paper)
		xtreg lngroc wave##l.unemp rpersons i.wave if l.head == 1, fe
		xtreg lngroc wave##l2.unemp rpersons i.wave if l.head == 1, fe