********************************************************************************                                 *
* Purpose of the progam:										               *
* ======================                                                       *
* This program creates an unbalanced and a balanced longitudinal data file,    *
* using the the combined files. The new data files are in Stata's long format. *
* Please note that we use 'tempfile tempdata_w' to create a macro (local) that *
* allows us to access a temporary data file which will be automatically        *
* deleted when this do-file ends.                                              *
********************************************************************************


**** Variables chosen for subjective labour market indicators survey ****
clear all
set more off
set maxvar 30000

// Specify directories (use "." to point to current directory)

local origdatadir "<place directory here>\stata"    // Location of original HILDA data files
local newdatadir  "<place directory here>"     // Location to which to write new data files


// CREATING AN UNBALANCED DATASET (LONG-FORMAT)
// The following code uses the combined files. Since we want the final
// file to be in long format, we need to remove the alphabetic wave
// indicator from the variable names and a create a variable containing
// the numeric wave indicator. For that we use a loop to make things easier.
// Usually not all variables are required. Therefore, in the code we just
// select a few before saving the temporary data file.

local varstokeep jbmplej jbmploj jbmpgi jomsf jbmssec jpjljrea jpmsemp jomwf /// Subjective indicators
				ujljt jbocct hhid hhpid hhstate lefrd lejob lfne lfnew capune esbrd esdtl sex yob jbmi06 /// Descriptives
				xpgrocs xpgroca xpalc xpcig xpciga xppubt xppubta xpwmeo xpwmeoa /// Expenditure person level
				xpmvf xpmvfa xpmcf xpmcfa xpwcf xpwcfa xpccf xpccfa xpteli xptelia ///
				xpphi xpphia xpoi xpoia xphltp xphltpa xpphrm xpphtma xputil xputila /// 
				xphmrn xphmrna xpmvr xpmvra xpeduc xpeduca rjspsuit ///
				hxygroc hxyalc hxycig hxypubt hxymeal hxymvf hxymcf hxywcf hxyccf /// Expenditure household level
				hxyteli hxyphi hxyoi hxyhltp hxyphrm hxyutil hxyhmrn hxymvr hxyeduc ///
				hxygrci hxyalci hxycigi hxypbti hxymli hxymvfi hxyphii hxyhmri hxymvri ///
				hxyedci hxyutli hxymcfi hxywcfi hxyccfi hxytlii hxyoii hxyhlpi hxyphmi ///
				hxygrcf hxyalcf hxycigf hxypbtf hxymlf hxymvff hxyphif hxyutlf hxyhmrf ///
				hxymvrf hxyedcf hxymcff hxywcff hxyccff hxytlif hxyoif hxyhlpf hxyphmf hwtbani hweqini hwtbani hwccdti ///
				xpgroci xpfoodi xposmli xpgrocf xpfoodf xposmlf xpgroc xpfood xposml hsmgpd hhpers hhadult tifditp tifditn ///
				hsrnti hsmgi hssli hxygrci hxyalci hxycigi hxypbti hxymli hxymvfi hxyphii hxyedci hxymcfi hxywcfi hicapi /// imputed variables 
				xpgrocs xpgroca xpalc xpalca xpcig xycigi xpciga xppubt xppubti xppubta xpwmeo xpwmeoa jbmo06 jbmwpsz jbmsvsr jbmi62 hglth edhigh1 ///
				xpmvf xpmvfa xpmvfi xpmcf xpmcfa xpwcf xpwcfa xpccf xpccfa xpteli xptelia xpphi es ///
				xpphia xpphii xphmrni xpmvri xpeduci xpoi xpoia xphltp xphltpa xpphrm xpphrma xputil xputila xphmrn xphmrn xphmrna ///
				xpmvr xpmvra xpeduc xpeduca hiconii hifonii hicisi oifrsv oifrsva oifoiri oifoirf jstwks ///
				oifrsvi jbmi61 pjsemp lshremp jbmcnt xpncara lefnw jbmpgj jbmsall jbmspay pjorea pjljrea pjotrea jspsuit ///
				hibifip hibifin hifmkin hifmkip hifpiip hifpiin hifdip hifdin hicisi hifisi hifditp hhwth hhwtsc /// Income
				xpyfurn xpywg xpytvav xpycomp xpyucar xpyncar xpyeduc xpymvr xpyhmrn xpyutil xpyphrm xpyhltp xpyoi ///
				xpyphi xpyhol xpyteli xpfurna xpfurn xpwga xpwg xptvava xptvav xpcompa xpcomp xpucara xpucar xpncara hges jbempt ///
				xpncar xpeduca xpwmeoi xpmcfi xpwcfi xpccfi xptelii xpoii xphltpi xputili xpeduc xpmvra xpmvr xphmrna xphmrn xputila xputil xpphrma xpphrm xphola xphol ///
				hxywgf hxytvf hxycmpf hxyucrf hxyncrf hxyphmf hxyhlpf hxyoif hxyfrni hxywgi hxytvi hxycmpi hxyucri hxyncri hxyfrnf jbhruc jbmhruc jbmemsz ///
				hxyhmri hxyphii hxyholi hxymvfi hxymli hxypbti hxycigi hxyalci hxygrci hxyfurn hxywg hxytvav hxycomp hxyucar gh11c ///
				hxyncar hxyeduc hxymvr hxyhmrn hxyutil hxyphrm hxyhltp hxyoi hxyphi hxyhol hxyteli hsrnti hsmgi hssli hsmgfg hiwscei helv10 ///
				lefrdq1 lefrdq2 lefrdq3 lefrdq4 lejobq1 lejobq2 lejobq3 lejobq4 losateo jbmsflx jbmshrs jbmswrk hsslfg hsmg hssl ehtjbyr esrtcr rpsfd ///
				fiprbmr wscei wsfnk wsfga jsminws jspsuit hhwthm jsreadm ancobn edcoq leprm lertr hhura hhmsr lebth hgage1 edhigh1 helv15m helths dtoplh losatfs fiprbfh eswkafw ///
				jbmtuea hgsex1 firisk firiska jbprhr jbpmfhr jbawmhr jbmshrs hifditp hifditn hgage1 hgage2 hgage3 hgage4 hgage5 hgage6 hgage7 fiprosp rpsfd  ///
				lemvdq4 lemvdq3 lemvdq2 lemvdq1 hsmguse hsvalui hsmgowe hsmgsch hsmgfin hsvalue mrclc ordf mhreapo prlcpyr fisav rg02_01 rg03_01 rg04_01 rg05_01 hstenr tchere gh2 /// housing indicators
				hwdebt hwtpdi hwbusdi hwccdti hwhecdi hwothdi hwnetwp hwnetwn hweqinv hwcaini hwtrust hwtbank hwhmval hwobdt fisave fisavep mdhesa /// debt
   
local i = 0
foreach w in a b c d e f g h i j k l m n o p q r s {
	use "`origdatadir'\Combined_`w'190u"

	renpfix `w'      // Strip off wave prefix
	local i = `i'+1  // Increase (wave) counter by 1
 	gen wave = `i'   // Create wave indicator (1, 2, ...)

	// select variables needed
	if ("`varstokeep'"!="") {
		local tokeep                                 // empty to keep list
		foreach var of local varstokeep {            // loop over all selected variables
			capture confirm variable `var'           // check whether variable exists in current wave
			if (!_rc) local tokeep `tokeep' `var'    // mark for inclusion if variable exists
			}
		keep xwaveid wave `tokeep' // keep selected variables
        }

	// Save temporary data file
	tempfile tempdata_`w'
	save "`tempdata_`w''"
}

// The following code appends the temporary data files for each wave to create
// an unbalanced panel.
clear
foreach w in a b c d e f g h i j k l m n o p q r s{
	append using "`tempdata_`w''"
	}
order xwaveid wave
sort  xwaveid wave

// Save new data set
save "`newdatadir'\long-file-unbalanced", replace

