
# Generates the model settings for things that should not change in a typical model run
default_settings_F <- function() {
  pmtrs <- list()

  pmtrs$hist_window <- 70
  pmtrs$banks_list <- c("ANZ", "CBA", "NAB", "WBC", "BEN", "BQL", "MBL", "MET", "ING")
  pmtrs$banks_listformat <- list("ANZ", "CBA", "NAB", "WBC", "BEN", "BQL", "MBL", "MET", 
                                 "ING")
  pmtrs$banks_level1 <- c("ING")
  pmtrs$irb_banks <- c("ANZ", "CBA", "NAB", "WBC","ING", "MBL")
  pmtrs$stand_banks <- c("BEN", "BQL", "MET")
  
  # Marginal effect on capital-sensitive funding spreads of capital ratio.
  pmtrs$min_cet1ratio <- 0.045
  pmtrs$min_tier1ratio <- 0.06
  pmtrs$min_totcapratio <- 0.08
  pmtrs$cap_cons_buffer <- 0.035
  pmtrs$target_cet1ratio <- pmtrs$min_cet1ratio + pmtrs$cap_cons_buffer
  pmtrs$div_cap_buffer <- 0.01
  pmtrs$cash_rate_start <- 0.0075
  pmtrs$cash_rate_lower_bound <- 0.0025
  pmtrs$asset_purch_cap_buffer <-  0.01
  pmtrs$AT1_conv_trigger <- 0.05125
  pmtrs$foreclosure_cost_hp <- 0.1
  pmtrs$mort_gross_flows <- 0.02
  pmtrs$min_mort_pd <- 0.3/100
  pmtrs$max_lvr <- 2.5
  pmtrs$min_LVR_for_foreclosure <- 0 
  pmtrs$LMI_recovery_rate <- 0.66 
  pmtrs$pd_coeff_URchange <- 0.08/100  
  pmtrs$ME_of_LGD_on_RW <- 0.5
  pmtrs$irb_rw_starting_weight <- 0.9 
  pmtrs$max_RW_rise <- 0.5 
  
  pmtrs$provisioning_qtrs <- 4
  
  pmtrs$return_LVR_dist <- FALSE
  
  
  pmtrs$tax_rate <- 0.3
  pmtrs$div_ratio_normal <- 0.8
  pmtrs$div_ratio_recovery <- 0.4
  
  # Funding and liquidity effects
  pmtrs$cap_fund_rate_feedback <- FALSE
  pmtrs$ME_of_cap_on_fund_rate <- 0.15
  pmtrs$fund_contagion_weight <- 0.5
  pmtrs$gdp_fund_rate_feedback <- TRUE
  pmtrs$ME_of_fund_rate_gdp <- -0.8
  
  # Marginal effect on capital-sensitive funding spreads of capital ratio.
  pmtrs$fund_rate_contagion <- FALSE 
  pmtrs$cet1_thresh_endog_fund_cost <- pmtrs$target_cet1ratio
  pmtrs$fire_sales <- FALSE
  pmtrs$prob_fire_sale <- FALSE 
  pmtrs$cet1_thresh_funding_run <- 0.06
  pmtrs$cet1_thresh_funding_run_prob <- 0.08 
  pmtrs$ppt_liab_run_for_ppt_cet1_gap <- 5  
  pmtrs$total_AGS_mkt <- 1e12  
  pmtrs$mkt_depth_coef <- 0.85  
  pmtrs$liq_asset_replenish_rate <- 0.1
  
  
  ### Parameters for business losses
  pmtrs$pd_coeff_GDP_ye_change_large_business <- -0.004162  
  pmtrs$pd_coeff_GDP_ye_change_medium_business <- -0.004729  
  pmtrs$pd_coeff_GDP_ye_change_small_business <- -0.005252
  pmtrs$credit_line_drawdown <- TRUE
  pmtrs$credit_line_drawdown_rate <- 0.1
  pmtrs$lgd_coeff_partially_secured <- 0.5 
  pmtrs$lgd_coeff_unsecured <- 0.5
  pmtrs$lgd_coeff_credit_line_drawdowns <- 1
  pmtrs$foreclosure_cost_cre <- 0.2

  #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  # Input coefficients for the credit loss part
  CLM_coeffs <- list()
  ACs_ln <- c("AC_ln_dom_res_mort", "AC_ln_os_res_mort", "AC_ln_creditcards", 
              "AC_ln_dom_oth_personal", "AC_ln_dom_sov", "AC_ln_dom_business", 
              "AC_ln_dom_fincorp", "AC_ln_dom_cp", "AC_ln_os_cp", "AC_ln_os_oth_loans")
  CLM_coeffs$macro_pd_coeff <- matrix(0, ncol=length(ACs_ln), nrow=3)
  rownames(CLM_coeffs$macro_pd_coeff) <- c('UR', 'GDP', 'CRE')
  colnames(CLM_coeffs$macro_pd_coeff) <- ACs_ln
  CLM_coeffs$macro_lgd_coeff <- CLM_coeffs$macro_pd_coeff
  CLM_coeffs$macro_pd_coeff["UR","AC_ln_creditcards"] <- 0.004
  CLM_coeffs$macro_pd_coeff["UR","AC_ln_dom_oth_personal"] <- 0.004
  CLM_coeffs$ACs_to_apply_mean <- c('AC_ln_os_oth_loans')
  CLM_coeffs$ACs_ln <- ACs_ln
  
  #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  # Income shocks
  income_shocks <- data.frame(quarter=1:50,
                         other_inc_growth=0,
                         op_exp_growth=0,
                         rwa_growth=0,
                         avg_lend_spr_shockpath=0,
                         avg_fund_spr_shockpath=0)
  
  return(list(pmtrs=pmtrs, CLM_coeffs=CLM_coeffs, income_shocks=income_shocks))
}
