# Projection_functions_high_level.R
###======================================================================================
proj_multi_period_F <- function(pmtrs, AC_losses_fxd, income_shocks, data_start_L, 
                                LVR_data_L, macro_inputs, multipliers, LVR_dist_bus_L) {
  data_series_L <- lapply(data_start_L, 
                          function(x) cbind(date=pmtrs$proj_dates[1], x))
  LVR_dist_L <- lapply(LVR_data_L, function(x) x[, c('LVR', 'lvr_dist')])
  LVR_dist_bus_L <- LVR_dist_bus_L
  LVR_pmtrs_L <- lapply(LVR_data_L, 
                        function(x) x[, c('LVR', 'lvr_flow_dist', 'multiplier')])
  LVR_dist_output <- vector('list', length=pmtrs$proj_window)
  LVR_dist_bus_output <- vector('list', length = pmtrs$proj_window)
  for(period in 1:pmtrs$proj_window) {
    proj_results_L <- 
      proj_single_period_F(pmtrs,
                           income_shocks,
                           data_series_L,
                           LVR_dist_L,
                           LVR_pmtrs_L,
                           period,
                           macro_inputs, 
                           multipliers, 
                           LVR_dist_bus_L)
    LVR_dist_L <- proj_results_L$LVR_dist_L
    LVR_dist_bus_L <- as.data.table(proj_results_L$LVR_dist_bus_L[1])
    colnames(LVR_dist_bus_L) <- c("fully_secured_cp", "fully_secured_hp")
    LVR_dist_output[[period]] <- proj_results_L$LVR_dist_L
    LVR_dist_bus_output[[period]] <- proj_results_L$LVR_dist_bus_L
    proj_results_L <-  proj_results_L$data_close_L
    data_series_L <- mapply(new_rbind_F, data_series_L, proj_results_L, SIMPLIFY=FALSE)
  }
  results_summary <- cet1_breakdown_F(data_series_L)
  print('Results waterfall across all banks:')
  print(results_summary)
  if(pmtrs$return_LVR_dist) {
    return(list(output=data_series_L, LVR_dist=LVR_dist_output))
  } else {
    return(data_series_L)
  }
}
###======================================================================================
new_rbind_F <- function(previous, new) {
  empty <- matrix(NA, nrow=nrow(previous), ncol=ncol(new))
  colnames(empty) <- colnames(new)
  new <- rbind(empty, new)
  new[1:nrow(previous), colnames(previous)] <- previous
  return(new)
}
###======================================================================================
proj_single_period_F <- function(pmtrs, income_shocks, data_series_L,
                                 LVR_dist_L, LVR_pmtrs_L, period, macro_inputs, 
                                 multipliers, LVR_dist_bus_L) {
  data_start_L <- lapply(data_series_L, function(x) x[1, -1])
  data_open_L <- lapply(data_series_L, function(x) x[period, -1])
  data_close_L <- data_open_L
  income_shocks_q <- subset(income_shocks, quarter == period, select=-quarter)
  macro_q <- macro_format_F(macro_inputs, period, pmtrs)
  if(pmtrs$fire_sales & period > 1) {
    data_close_L <- fire_sales_F(data_open_L, data_close_L, pmtrs, period)
  }
  asset_losses_L <-
    mapply(asset_losses_F, data_start_L, data_open_L, data_close_L, 
           LVR_dist_L, LVR_pmtrs_L,
           MoreArgs=list(pmtrs, macro_inputs, macro_q, period, multipliers, 
                         LVR_dist_bus_L),
           SIMPLIFY=FALSE)
  LVR_dist_L <- lapply(asset_losses_L, function(x) x$LVR_dist)
  LVR_dist_bus_L <- lapply(asset_losses_L, function(x) x$LVR_dist_bus)
  data_close_L <- lapply(asset_losses_L, function(x) x$close)
  rm(asset_losses_L)
  endog_effects <- sapply(data_open_L, endog_funding_costs_F, pmtrs)
  data_close_L <- mapply(profit_tax_dividends_F, data_start_L, data_open_L, data_close_L,
                         endog_effects,
                         MoreArgs=list(income_shocks_q, pmtrs, endog_effects, macro_inputs,
                                       period), SIMPLIFY=FALSE)
  data_close_L <- mapply(profit_effect_on_cap_F, data_open_L, data_close_L, 
                         SIMPLIFY=FALSE)
  data_close_L <- mapply(asset_changes_from_shock_and_income_F, data_start_L,
                         data_open_L, data_close_L,
                         MoreArgs=list(pmtrs), SIMPLIFY=FALSE)
  data_close_L <- 
    mapply(update_avg_RW_F, data_start_L, data_open_L, data_close_L,
           pmtrs$banks_listformat,
           MoreArgs=list(income_shocks_q, pmtrs, macro_inputs, period), 
           SIMPLIFY=FALSE)
  
  data_close_L <- mapply(asset_reinvestment_F, data_start_L, data_open_L, data_close_L,
                         MoreArgs=list(pmtrs), SIMPLIFY=FALSE)
  
  data_close_L <- mapply(update_RWA_then_cap_F, data_start_L, data_open_L, 
                          data_close_L, MoreArgs = list(pmtrs, income_shocks_q),
                         SIMPLIFY=FALSE)

  data_close_L <- lapply(data_close_L, 
                         function(x) cbind(date=pmtrs$proj_dates[[period]], x))
  return(list(data_close_L=data_close_L, LVR_dist_L=LVR_dist_L, 
              LVR_dist_bus_L = LVR_dist_bus_L))
}
###======================================================================================
# Called by proj_single_period_F. 
macro_format_F <- function(macro_inputs, period, pmtrs) {
  macro_WO_q <- writeoff_macro_inputs_F(macro_inputs, period)
  # Allow banks to end the projection with only minimum provision balances
  prov_qtrs <- min(pmtrs$provisioning_qtrs, pmtrs$proj_window - period)
  macro_PR_q <- 
    provisioning_macro_inputs_F(macro_inputs, period, prov_qtrs)
  return(list(macro_WO_q=macro_WO_q, macro_PR_q=macro_PR_q))
}
###======================================================================================
# Called by proj_single_period_F.
fire_sales_F <- function(open_L, close_L, pmtrs, period) {
  fire_sale_objects_F <- function(open, pmtrs) {
    y <- c()
    if(pmtrs$prob_fire_sale){
      y$cet1_gap <- max(0, pmtrs$cet1_thresh_funding_run_prob - open$cap_ratio_cet1)
      if(y$cet1_gap <= 0){y$run_prob <- 0}
      if(y$cet1_gap > 0 & y$cet1_gap <= 0.03){y$run_prob <- 0.05}
      if(y$cet1_gap > 0.03){y$run_prob <- 0.12}
      y$rand <- runif(n = 1, min = 0, max = 1)
      if(y$rand <= y$run_prob){y$run_ind <- 1} else{y$run_ind <- 0}
      y$liq_gap <- y$cet1_gap * pmtrs$ppt_liab_run_for_ppt_cet1_gap * 
        (open$bsh_total_AC - open$bsh_total_equity)*y$run_ind
    } else{
      y$cet1_gap <- max(0, pmtrs$cet1_thresh_funding_run - open$cap_ratio_cet1)
      y$liq_gap <- y$cet1_gap * pmtrs$ppt_liab_run_for_ppt_cet1_gap * 
        (open$bsh_total_AC - open$bsh_total_equity)
    }
    y$liq_open <- unlist(c(open[, c('AC_oth_cash', 'AC_sec_AGS', 'AC_sec_semis')],
                           sum(open[, grepl('^AC_sec', colnames(open))]) -
                             sum(open[, c('AC_sec_AGS', 'AC_sec_semis')])))
    names(y$liq_open) <- c('cash', 'AGS', 'semis', 'othsec')
    y$liq_left <- y$liq_open
    cash_used <- min(y$liq_gap, y$liq_open['cash'])
    y$liq_gap_left <- y$liq_gap - cash_used
    y$liq_left['cash'] <- y$liq_open['cash'] - cash_used
    return(y)
  }
  fs_obj_L <- lapply(open_L, fire_sale_objects_F, pmtrs)
  gen_df_for_secprice_solution_F <- function(fs_obj, sec) {
    onebank_F <- function(obj, sec) {
      y <- c(obj$liq_left[sec], obj$liq_gap_left, obj$liq_gap_left / obj$liq_left[sec])
      names(y) <- c('sec_hld', 'liq_nd', 'res_p')
      if(is.na(y['res_p'])) y['res_p'] <- 0
      if(y['res_p'] > 1.01) y['res_p'] <- 1.01  
      return(y)
    }
    df <- do.call(rbind, lapply(fs_obj, onebank_F, sec)) %>% data.frame 
    df <- df[order(df$res_p, decreasing=TRUE), ]
    return(df)
  }
  eq_price_F <- function(p, df, pmtrs, extra_sold=0) {
    if(p >= df$res_p[1]) q_sold <- sum(df$liq_nd) / p
    if(p <= tail(df$res_p, 1)) q_sold <- sum(df$sec_hld) 
    if(p < df$res_p[1] & p > tail(df$res_p, 1)) {
      p_toolow <- p < df$res_p
      p_ok <- p >= df$res_p
      q_sold <- sum(df$liq_nd[p_ok])/p + sum(df$sec_hld[p_toolow]) 
    }
    excess_sales <- q_sold - 
      (pmtrs$mkt_depth_coef * pmtrs$total_AGS_mkt * sqrt(1 - p) - extra_sold)
    return(excess_sales)
  }
  update_fs_obj_F <- function(fs_obj, sec, eq_p) {
    update_one_bank_F <- function(x, sec, eq_p) {
      if(x$liq_gap_left > 0) {
        q_sold <- min(x$liq_left[sec], x$liq_gap_left/eq_p)
        x$liq_left[sec] <- x$liq_left[sec] - q_sold
        x$liq_gap_left <- x$liq_gap_left - eq_p * q_sold
      }
      return(x)
    }
    fs_obj <- lapply(fs_obj, update_one_bank_F, sec, eq_p)
    return(fs_obj)
  }
  p_ags <- 1
  p_semis <- 1 
  p_oth <- 1
  df_ags <- gen_df_for_secprice_solution_F(fs_obj_L, 'AGS')
  p_ags <- uniroot(eq_price_F, interval=c(1, 0.01), df_ags, pmtrs)$root
  fs_obj_L <- update_fs_obj_F(fs_obj_L, 'AGS', p_ags)
  tot_ags_sold <- sum(sapply(fs_obj_L, 
                             function(x) x$liq_open['AGS'] - x$liq_left['AGS']))
  if(sum(sapply(fs_obj_L, function(x) x$liq_gap_left)) > 0) {
    df_semis <- gen_df_for_secprice_solution_F(fs_obj_L, 'semis')
    p_semis <- uniroot(eq_price_F, interval=c(1, 0), 
                       df_semis, pmtrs, extra_sold=tot_ags_sold)$root
    fs_obj_L <- update_fs_obj_F(fs_obj_L, 'semis', p_semis)
    tot_semis_sold <- 
      sum(sapply(fs_obj_L, function(x) x$liq_open['semis'] - x$liq_left['semis']))
  }
  if(sum(sapply(fs_obj_L, function(x) x$liq_gap_left)) > 0) {
    df_oth <- gen_df_for_secprice_solution_F(fs_obj_L, 'othsec')
    p_oth <- uniroot(eq_price_F, interval=c(1, 0), 
                     df_oth, pmtrs, extra_sold = tot_ags_sold + tot_semis_sold)$root
    fs_obj_L <- update_fs_obj_F(fs_obj_L, 'othsec', p_oth)
  }
  if(sum(sapply(fs_obj_L, function(x) x$liq_gap_left)) > 0) {
    failures <- names(fs_obj_L)[sapply(fs_obj_L, function(x) x$liq_gap_left) > 0]
    print(cbind(paste(failures, 'failed in period', period, 'due to illiquidity!')))
    stop('Model set up to stop if bank fails.')
  }
  p_firesale <- list(p_ags, p_semis, p_oth)
  names(p_firesale) <- c("p_ags", "p_semis", "p_oth")
  if(any(names(fs_obj_L) != names(close_L))) {
    stop('At end of fire sale function, object names not aligned')
  }
  store_firesale_results_F <- function(close, fs_obj, p_firesale) {
    close$firesale_run_liabilities <- fs_obj$liq_gap
    close$firesale_lost_cash <- fs_obj$liq_open['cash'] - fs_obj$liq_left['cash']
    close$firesale_lost_AGS <- (fs_obj$liq_open['AGS'] - fs_obj$liq_left['AGS']) + 
      (fs_obj$liq_left['AGS'] - fs_obj$liq_left['AGS'] * p_firesale$p_ags)
    close$firesale_lost_semis <- (fs_obj$liq_open['semis'] - fs_obj$liq_left['semis']) + 
      (fs_obj$liq_left['semis'] - fs_obj$liq_left['semis'] * p_firesale$p_semis)
    close$firesale_lost_othsec <- (fs_obj$liq_open['othsec'] - fs_obj$liq_left['othsec'])+
      (fs_obj$liq_left['othsec'] - fs_obj$liq_left['othsec'] * p_firesale$p_oth)
    close$pnl_firesale_loss <- round(sum(close[, grepl('^firesale_lost', colnames(close))]) -
      close$firesale_run_liabilities,0) 
    return(close)
  }
  close_L <- mapply(store_firesale_results_F, close_L, fs_obj_L, 
                    MoreArgs = list(p_firesale), SIMPLIFY=FALSE)
  return(close_L)
} 
###======================================================================================
# Called by proj_single_period_F in mapply.
asset_losses_F <- function(start, open, close, LVR_dist, LVR_pmtrs,
                           pmtrs, macro_inputs, macro_q, period, multipliers, 
                           LVR_dist_bus) {
  macro_WO_q <- macro_q$macro_WO_q
  macro_PR_q <- macro_q$macro_PR_q
  ACs_ln <- grep('^AC_ln_', colnames(start), value=TRUE)
  mort_writeoff_outputs <- 
    mortgage_losses_F(start, open, LVR_dist, LVR_pmtrs, pmtrs, macro_WO_q)
  bus_writeoff_outputs <- business_losses_F(start, open, LVR_dist_bus,
                                            multipliers, macro_WO_q, 
                                            pmtrs)
  loan_writeoff_output <- loan_losses_F(start, open, close, mort_writeoff_outputs, 
                                        bus_writeoff_outputs, pmtrs, macro_inputs,
                                        macro_WO_q, period, provisioning=FALSE)
  LVR_dist <- loan_writeoff_output$LVR_dist
  LVR_dist_bus <- loan_writeoff_output$LVR_dist_bus
  close <- loan_writeoff_output$close
  close[, gsub('AC_ln', 'writeoff', ACs_ln)] <- loan_writeoff_output$asset_losses
  if(length(macro_PR_q) != 0) {  
    mort_provision_outputs <- 
      mortgage_losses_F(start, open, LVR_dist, LVR_pmtrs, pmtrs, macro_PR_q)
    bus_provision_outputs <- 
      business_losses_F(start, open, LVR_dist_bus, multipliers, macro_PR_q, pmtrs)
    required_provisions <- 
      loan_losses_F(start, open, close, mort_provision_outputs, bus_provision_outputs,
                    pmtrs, macro_inputs, macro_PR_q, period, provisioning=TRUE)
  } else { 
    required_provisions <- loan_writeoff_output$asset_losses
    required_provisions[required_provisions != 0] <- 0
  }
  pref_F <- function(prefix) gsub('AC_ln_', prefix, ACs_ln)
  close[, pref_F('incrPR_')] <- open[, pref_F('minPR_')] + 
    required_provisions[, ACs_ln] - open[, pref_F('PR_')]
  close[, pref_F('loss_')] <- close[, pref_F('writeoff_')] + close[, pref_F('incrPR_')]
  close$bsh_provisions_total <- sum(close[, grepl('^PR_', colnames(close))])
  return(list(close=close, LVR_dist=LVR_dist, LVR_dist_bus = LVR_dist_bus))
}

###======================================================================================
# Called by proj_single_period_F
endog_funding_costs_F <- function(open, pmtrs) {
  cet1_gap <- max(0, pmtrs$cet1_thresh_endog_fund_cost - open$cap_ratio_cet1)
  endog_effect <- cet1_gap * pmtrs$ME_of_cap_on_fund_rate
  return(endog_effect)
}
###======================================================================================
# Called by proj_single_period_F
profit_tax_dividends_F <- function(start, open, close, bank_endog_effect, 
                                   income_shocks_q, pmtrs, all_endog_effects, macro_inputs, 
                                   period) {
  if(pmtrs$cap_fund_rate_feedback) {
    close$pnl_cap_fund_rate_fdbk <- bank_endog_effect
  } else {
    close$pnl_cap_fund_rate_fdbk <- 0
  }
  if(pmtrs$fund_rate_contagion) {
    close$pnl_fund_rate_contagion <- pmtrs$fund_contagion_weight * 
      (max(all_endog_effects) - bank_endog_effect)
  } else {
    close$pnl_fund_rate_contagion <- 0
  }
  if(pmtrs$gdp_fund_rate_feedback) {
    gdp <- macro_inputs$macro_data$gdp_growth[macro_inputs$macro_data$quarter == period] -
      macro_inputs$macro_data$gdp_growth[macro_inputs$macro_data$quarter == 0]
    close$pnl_gdp_fund_rate_feedback <- max(pmtrs$ME_of_fund_rate_gdp * gdp/100, 0)
  } else {
    close$pnl_gdp_fund_rate_feedback <- 0
  }
  close$pnl_avg_fund_rate <- start$pnl_avg_fund_rate + 
    income_shocks_q$avg_fund_spr_shockpath + start$bsh_prpn_fund_whlsale * 
      (close$pnl_cap_fund_rate_fdbk + close$pnl_fund_rate_contagion + 
         close$pnl_gdp_fund_rate_feedback) 
  close$pnl_int_exp <- 
    (close$pnl_avg_fund_rate/4)*(close$bsh_total_AC - close$bsh_total_equity)
  close$pnl_avg_lend_rate <- 
    start$pnl_avg_lend_rate + income_shocks_q$avg_lend_spr_shockpath
  close$pnl_int_inc <- (close$pnl_avg_lend_rate/4)*close$bsh_total_AC
  close$pnl_net_int_inc <- close$pnl_int_inc - close$pnl_int_exp
  close$pnl_net_int_margin <- (close$pnl_net_int_inc*4)/close$bsh_total_AC
  close$pnl_other_inc <- open$pnl_other_inc * 
    (1 + income_shocks_q$other_inc_growth)^(1/4) * (1 + open$bsh_growth)
  close$pnl_op_exp <- close$pnl_op_exp * (1 + income_shocks_q$op_exp_growth)^(1/4) * 
    (1 + open$bsh_growth)
  close$pnl_BDD_charge <- sum(close[, grepl('^loss_', colnames(close))])
  DTA_contr_to_profit <- max(0, sum(close[, grepl('^incrPR_', colnames(close))]))
  close$pnl_tax <- pmtrs$tax_rate * 
    max(0, close$pnl_net_int_inc + close$pnl_other_inc - close$pnl_op_exp - 
          close$pnl_BDD_charge - close$pnl_firesale_loss + DTA_contr_to_profit)
  close$pnl_npat <- close$pnl_net_int_inc + close$pnl_other_inc - close$pnl_op_exp - 
    close$pnl_BDD_charge - close$pnl_firesale_loss - close$pnl_tax
  if(is.na(close$pnl_npat)) stop('NPAT is producing NA - use browser() to investigate')
  if(pmtrs$no_dividend_payments) {
    close$pnl_div_paid <- 0
  } else {
    close$pnl_div_paid <- dividend_paid_F(close, pmtrs)
  }
  close$profit_ret <- close$pnl_npat - close$pnl_div_paid
  return(close)
}
###======================================================================================
# Called by proj_single_period_F
profit_effect_on_cap_F <- function(open, close) {
  close$cap_cet1 <- close$cap_cet1 + close$profit_ret
  close$bsh_total_equity <- close$bsh_total_equity + close$profit_ret
  close$cap_growth <- close$cap_cet1 / open$cap_cet1 - 1
  close$cap_tier1 <- close$cap_tier1 * (1 + close$cap_growth)
  close$cap_tier2 <- close$cap_tier2 * (1 + close$cap_growth)
  return(close)
}
###======================================================================================
# Called by proj_single_period_F
asset_changes_from_shock_and_income_F <- function(start, open, close, pmtrs) {
  ACs_ln <- grep('^AC_ln_', colnames(close), value=TRUE)
  init_comp <- start[, ACs_ln]/sum(start[, ACs_ln])
  pref_F <- function(prefix) gsub('AC_ln_', prefix, ACs_ln)
  close[, ACs_ln] <- close[, ACs_ln] - close[, pref_F('loss_')]
  if(any(close[, ACs_ln] < 0)) {  # Give warning about any negative balances
    msg <- paste0(ACs_ln[close[, ACs_ln] < 0], ' is going negative. ')
    close[, ACs_ln][close[, ACs_ln] < 0] <- 0
    warning(msg) 
  }
  close[, pref_F('PR_')] <- close[, pref_F('PR_')] + close[, pref_F('incrPR_')]
  if(close$pnl_firesale_loss > 0 | close$firesale_lost_cash > 0) {
    hqla_ids <- c('AC_oth_cash', 'AC_sec_AGS', 'AC_sec_semis')
    othsec_B <- grepl('^AC_sec', colnames(close)) &  # Indexes all the other securities
      !colnames(close) %in% c('AC_sec_AGS', 'AC_sec_semis')
    close[, hqla_ids] <- open[, hqla_ids] -
      close[, paste0('firesale_lost_', c('cash', 'AGS', 'semis'))]
    close[, othsec_B] <- close[, othsec_B] *
      (1 - close$firesale_lost_othsec/sum(close[, othsec_B]))
  }
  hqla_ids <- c('AC_oth_cash', 'AC_sec_AGS', 'AC_sec_semis')
  if(sum(close[,hqla_ids]) < sum(start[,hqla_ids]) ){
    close[, hqla_ids] <-
      pmin(close[, hqla_ids] + pmtrs$liq_asset_replenish_rate * start[, hqla_ids],
           start[, hqla_ids])
  }
  net_cashflow <- close$profit_ret + close$pnl_BDD_charge
  if(net_cashflow > 0) {
    close[, ACs_ln] <- close[, ACs_ln] + 
      min(close$pnl_BDD_charge, net_cashflow) * init_comp
  } else {
    close$AC_oth_cash <- close$AC_oth_cash + net_cashflow
  }
  close$bsh_total_AC <- sum(close[, grepl("^AC_", colnames(close))])
  return(close)
}
  
 
###======================================================================================
# Called by proj_single_period_F
update_avg_RW_F <- function(start, open, close, bank_list, income_shocks_q, pmtrs, 
                                   macro_inputs, period) {
  open$names <- bank_list
  if(open$names %in% c(pmtrs$stand_banks)) {
    ACs_ln <- grep('^AC_ln_', colnames(start), value=TRUE)
     close$rwa_avg_lnRW <- start$rwa_total/sum(start[, ACs_ln])
  }
  if(open$names %in% c(pmtrs$irb_banks)){
    ACs_ln <- grep('^AC_ln_', colnames(start), value=TRUE)
    pref_F <- function(prefix) gsub('AC_ln_', prefix, ACs_ln)
    start_LGDs <- start[, pref_F('LGD_ln_')]
    close_LGDs <- close[, pref_F('LGD_ln_')]
    close_LGDs[, c('LGD_ln_dom_res_mort', 'LGD_ln_os_res_mort')] <-
      max(start$LGD_ln_dom_res_mort, close$LGD_ln_dom_res_mort)
    start_PD_agg <- sum(start[, ACs_ln] * start[, pref_F('PD_ln_')])/sum(start[, ACs_ln])
    start_LGD_agg <- sum(start[, ACs_ln] * start_LGDs)/sum(start[, ACs_ln])
    open_PD_agg <- (1-pmtrs$irb_rw_starting_weight) *
      (sum(open[, ACs_ln] * open[, pref_F('PD_ln_')])/sum(open[, ACs_ln])) +
      (pmtrs$irb_rw_starting_weight  * start_PD_agg)
    open_LGDs <- open[, pref_F('LGD_ln_')]
    open_LGDs[, c('LGD_ln_dom_res_mort', 'LGD_ln_os_res_mort')] <-
      max(start$LGD_ln_dom_res_mort, open$LGD_ln_dom_res_mort)
    open_LGD_agg <- (1-pmtrs$irb_rw_starting_weight) *
      (sum(open[, ACs_ln] * open_LGDs)/sum(open[, ACs_ln])) +
      (pmtrs$irb_rw_starting_weight  * start_LGD_agg)
    close$PD_agg <-
      (1-pmtrs$irb_rw_starting_weight) *
      (sum(close[, ACs_ln] * close[, pref_F('PD_ln_')])/sum(close[, ACs_ln])) +
      (pmtrs$irb_rw_starting_weight  * start_PD_agg)
    close$LGD_agg <-
      (1-pmtrs$irb_rw_starting_weight) *
      (sum(close[, ACs_ln] * close_LGDs)/sum(close[, ACs_ln])) +
      (pmtrs$irb_rw_starting_weight  * start_LGD_agg)
    open$rwa_avg_RW <- open$rwa_total/open$bsh_total_AC
    open_RW <- risk_weight_F(open_PD_agg, open_LGD_agg)
    close_RW <- risk_weight_F(close$PD_agg, close$LGD_agg)
    open$rwa_avg_lnRW <- open$rwa_total/sum(open[, ACs_ln])
    close$rwa_avg_lnRW <- open$rwa_avg_lnRW * ((close_RW / open_RW - 1) + 1)
    close$rwa_avg_lnRW <- min(close$rwa_avg_lnRW,
                              (start$rwa_total/sum(start[, ACs_ln])) *
                                (1 + pmtrs$max_RW_rise))
    close$rwa_avg_lnRW <- max(close$rwa_avg_lnRW, start$rwa_total/sum(start[, ACs_ln]))
  }
  close$rwa_total <-  close$rwa_avg_lnRW * sum(close[, ACs_ln])
  return(close)
}

###======================================================================================
# Called by proj_single_period_F
asset_reinvestment_F <- function(start, open, close, pmtrs) {
  ACs_ln <- grep('^AC_ln_', colnames(start), value=TRUE) 
  init_comp <- start[, ACs_ln]/sum(start[, ACs_ln])
if(close$profit_ret > 0) {
  purch_amount <- expenditure_on_releveraging_F(start, close, pmtrs)
  close[, ACs_ln] <- close[, ACs_ln] + purch_amount * init_comp
}

close$bsh_total_AC <- sum(close[, grepl("^AC_", colnames(close))])
infeasibly_negative_growth <- -1e6
if(pmtrs$asset_grth_floor > infeasibly_negative_growth) {
  more_growth <- (1 + pmtrs$asset_grth_floor)/(close$bsh_total_AC/open$bsh_total_AC)
  if(more_growth > 1) {
    close[, grepl("^AC_", colnames(close))] <- more_growth * 
      close[, grepl("^AC_", colnames(close))]
    close$bsh_total_AC <- sum(close[, grepl("^AC_", colnames(close))])
  }
}
close$bsh_growth <- close$bsh_total_AC / open$bsh_total_AC - 1
return(close)
}

###======================================================================================
# Called by proj_single_period_F
update_RWA_then_cap_F <- function(start, open, close, pmtrs, income_shocks_q){
  ACs_ln <- grep('^AC_ln_', colnames(start), value=TRUE)
  close$rwa_total <-  close$rwa_avg_lnRW * sum(close[, ACs_ln])
  if(pmtrs$RWA_growth) {
    close$rwa_total <- close$rwa_total * (1 + income_shocks_q$rwa_growth)
  }
  close$rwa_avg_RW <- close$rwa_total/close$bsh_total_AC
  trigger_cet1 <- close$rwa_total * pmtrs$AT1_conv_trigger
  if(close$cap_cet1 < trigger_cet1) {
    conv_cet1 <- close$cap_tier1 - close$cap_cet1
    close$cap_cet1 <- close$cap_cet1 + conv_cet1
    close$cap_tier1 <- close$cap_cet1
    close$bsh_dom_equity <- close$bsh_dom_equity + conv_cet1
    close$bsh_total_equity <- close$bsh_total_equity + conv_cet1
  }
  close$cap_ratio_cet1 <- close$cap_cet1 / close$rwa_total
  close$cap_ratio_cet1_lag <- open$cap_ratio_cet1
  close$cap_ratio_tier1 <- close$cap_tier1 / close$rwa_total
  close$cap_ratio_total <- (close$cap_tier1 + close$cap_tier2) / close$rwa_total
return(close)

}



