###======================================================================================
mortgage_losses_F <- function(start, open, LVR_dist, LVR_pmtrs, pmtrs, macro_q) {
  
  new_LVR <- LVR_dist$LVR/(1 + macro_q['HP']/100)  
  new_LVR <- new_LVR * (1 - pmtrs$mort_gross_flows)  
  new_dist_LVR_F <- function(old_LVR_bkt, new_LVR) {
    sum(LVR_dist$lvr_dist[new_LVR <= old_LVR_bkt & new_LVR > old_LVR_bkt - 0.01])
  }
  if(round(pmtrs$mort_gross_flows + macro_q['HP']/100, 2) == 0) {
    new_dist_LVR <- LVR_dist$lvr_dist
  } else {
    new_dist_LVR <- sapply(LVR_dist$LVR, new_dist_LVR_F, new_LVR)
    new_dist_LVR[LVR_dist$LVR == pmtrs$max_lvr] <- 
      sum(LVR_dist$lvr_dist[new_LVR >= pmtrs$max_lvr])
  }
  mort_inflow <- pmtrs$mort_gross_flows + max(0, pmtrs$asset_grth_floor)
  new_dist_LVR <- new_dist_LVR + mort_inflow * LVR_pmtrs$lvr_flow_dist
  LVR_dist$lvr_dist <- new_dist_LVR/sum(new_dist_LVR)  
  foreclosure_cost_LVR <-  
    ifelse(LVR_pmtrs$LVR < pmtrs$min_LVR_for_foreclosure, 
           0, pmtrs$foreclosure_cost_hp)
 
  lgd_LVR_before_foreclosure_costs <- pmax(1 - 1/LVR_pmtrs$LVR, 0)
  LMI_coverage <- min(start$bsh_outs_res_mort_LMI/sum(start$bsh_outs_res_mort_LVR80to85, 
                                                  start$bsh_outs_res_mort_LVR85to90, 
                                                  start$bsh_outs_res_mort_LVR90to95, 
                                                  start$bsh_outs_res_mort_LVR95up),1)
  lgd_LVR_before_foreclosure_costs[81:(pmtrs$max_lvr*100 +1)] <- 
    lgd_LVR_before_foreclosure_costs[81:(pmtrs$max_lvr*100 +1)] * 
    (1- pmtrs$LMI_recovery_rate) * LMI_coverage + lgd_LVR_before_foreclosure_costs[81:(pmtrs$max_lvr*100 +1)] * (1- LMI_coverage)
  lgd_LVR <- lgd_LVR_before_foreclosure_costs + foreclosure_cost_LVR 
  DR_baseline_LVR <- start$PD_ln_dom_res_mort/4 * LVR_pmtrs$multiplier
  pd_LVR <- pmax(DR_baseline_LVR + 
                   macro_q['UR'] * pmtrs$pd_coeff_URchange * LVR_pmtrs$multiplier, 
                 pmtrs$min_mort_pd)
  loss_rate_LVR <- pd_LVR * lgd_LVR  # Loss rates by LVR
  loss_rate_agg <- sum(loss_rate_LVR * LVR_dist$lvr_dist)  # Aggregated loss rate
  lgd <- sum(LVR_dist$lvr_dist * lgd_LVR)  # Aggregated LGD
  pd <- loss_rate_agg / lgd
  LVR_dist$lvr_dist <- LVR_dist$lvr_dist * (1 - pd_LVR)
  LVR_dist$lvr_dist <- LVR_dist$lvr_dist/sum(LVR_dist$lvr_dist)
  return(list(pd=pd, lgd=lgd, LVR_dist=LVR_dist))
}
###======================================================================================
business_losses_F <- function(start, open, LVR_dist_bus_L, multipliers, macro_q, pmtrs) {
  bsh_dom_business <- start[grep("^bsh_dom_business_", 
                                 names(start), 
                                 value = TRUE)][c(
                                   multipliers$ST_variable_name)]
  bsh_dom_business[grep("^bsh_dom_business_large_finance", names(bsh_dom_business))] <- 0
  bsh_dom_business[grep("^bsh_dom_business_medium_finance", 
                        names(bsh_dom_business))] <- 0
  bsh_dom_business[grep("^bsh_dom_business_small_finance", names(bsh_dom_business))] <- 0
  bsh_dom_business_large <- bsh_dom_business[grep("^bsh_dom_business_large", 
                                                  names(bsh_dom_business), value = TRUE)]
  bsh_dom_business_large_prop <- bsh_dom_business_large/sum(bsh_dom_business_large)
  bsh_dom_business_large_drawdown <-  bsh_dom_business_large_prop * 
    start$business_credit_drawdowns
  bsh_dom_business[grep("^bsh_dom_business_large", 
                        names(bsh_dom_business), value = TRUE)] <- 
    bsh_dom_business[grep("^bsh_dom_business_large", names(bsh_dom_business), 
                          value = TRUE)] + bsh_dom_business_large_drawdown
  bsh_dom_business_prop <- bsh_dom_business/sum(bsh_dom_business)
  pd_by_size <- data.frame(
    pd_change_large = pmtrs$pd_coeff_GDP_ye_change_large_business * macro_q["GDP_YE"],
    pd_change_medium = pmtrs$pd_coeff_GDP_ye_change_medium_business * macro_q["GDP_YE"],
    pd_change_small = pmtrs$pd_coeff_GDP_ye_change_small_business * macro_q["GDP_YE"],
    row.names = NULL)
  multipliers$pd_chg[grep("^bsh_dom_business_large", 
                          multipliers$ST_variable_name)] <- pd_by_size$pd_change_large
  multipliers$pd_chg[grep("^bsh_dom_business_medium", 
                          multipliers$ST_variable_name)] <- pd_by_size$pd_change_medium
  multipliers$pd_chg[grep("^bsh_dom_business_small", 
                          multipliers$ST_variable_name)] <- pd_by_size$pd_change_small
  weighted_pd <- (start$PD_ln_dom_business +  sum(bsh_dom_business_prop * multipliers$pd_chg)) * 
    sum(bsh_dom_business_prop * multipliers$Multiplier)
  pd <- max(start$PD_ln_dom_business,  weighted_pd)
  bsh_dom_business_col <- start[grep("business_credit_drawdowns|secured_coll$", 
                                     names(start))]
  bsh_dom_business_col_prop <- bsh_dom_business_col/sum(bsh_dom_business_col)
  LVR_dist_bus_L$fully_secured_cp <- LVR_dist_bus_L$fully_secured_cp/(1+macro_q["CRE_BUS"]
                                                                      /100) 
  LVR_dist_bus_L$fully_secured_hp <- LVR_dist_bus_L$fully_secured_hp/(1+macro_q["HP"]/100)
  foreclosure_cost_hp <-  # Set foreclosure costs to zero for low enough LVRs for hp 
    ifelse(LVR_dist_bus_L$fully_secured_hp < pmtrs$min_LVR_for_foreclosure, 
           0, pmtrs$foreclosure_cost_hp)
  foreclosure_cost_cre <- #set foreclosure costs to zero for low enough LVRs for CP
    ifelse(LVR_dist_bus_L$fully_secured_cp < pmtrs$min_LVR_for_foreclosure, 
           0, pmtrs$foreclosure_cost_cre)
  LGD_large_fully_secured <- mean(max(1 - 1/LVR_dist_bus_L$fully_secured_cp, 0) + 
                                    foreclosure_cost_cre)
  LGD_small_fully_secured <- mean(max(1 - 1/LVR_dist_bus_L$fully_secured_hp, 0) +
                                    foreclosure_cost_hp)
  LGD_medium_fully_secured <- (LGD_large_fully_secured + LGD_small_fully_secured)/2
  LGD_large_paritally_secured <- max(pmtrs$lgd_coeff_partially_secured, 
                                     LGD_large_fully_secured)
  LGD_large_unsecured <- max(pmtrs$lgd_coeff_unsecured, 
                             LGD_large_fully_secured)
  LGD_medium_partially_secured <- max(pmtrs$lgd_coeff_partially_secured, 
                                      LGD_medium_fully_secured)
  LGD_medium_unsecured <- max(pmtrs$lgd_coeff_unsecured, 
                              LGD_medium_fully_secured)
  LGD_small_partially_secured <- max(pmtrs$lgd_coeff_partially_secured, 
                                     LGD_small_fully_secured) 
  LGD_small_unsecured <- max(pmtrs$lgd_coeff_unsecured, 
                             LGD_small_fully_secured) 
  LGD_business_credit_drawdown <- pmtrs$lgd_coeff_credit_line_drawdowns
  LGDs <- rbind(LGD_business_credit_drawdown, 
                LGD_large_fully_secured, 
                LGD_large_paritally_secured, 
                LGD_large_unsecured, 
                LGD_medium_fully_secured, 
                LGD_medium_partially_secured, 
                LGD_medium_unsecured, 
                LGD_small_fully_secured, 
                LGD_small_partially_secured, 
                LGD_small_unsecured)
  weighted_lgd <- sum(LGDs * bsh_dom_business_col_prop)
  return(list(pd = pd, lgd = weighted_lgd, LVR_dist_bus = LVR_dist_bus_L))
}
###======================================================================================
writeoff_macro_inputs_F <- function(macro_inputs, period) {
  macro <- macro_inputs$macro_data  # Shorten name of data to neaten code
  macro_WO_q <- c(UR=NA, GDP=NA, CRE=NA, CRE_BUS = NA, HP=NA, GDP_YE = NA)
  macro_WO_q['UR'] <- macro$un_rate[macro$quarter == period] - 
    macro$un_rate[macro$quarter == 0]
  macro_WO_q['GDP'] <- macro$gdp_growth[macro$quarter == period] - 
    macro$gdp_growth[macro$quarter == 0]
  macro_WO_q['GDP_YE'] <- macro$gdp_growth_ye[macro$quarter == period] - 
    macro$gdp_growth_ye[macro$quarter == 0]
  CRE_cum_prpn_chng <- prod(macro$cp_growth[macro$quarter %in% 1:period]/100 + 1)
  macro_WO_q['CRE'] <- 100*(CRE_cum_prpn_chng - 1)
  macro_WO_q['CRE_BUS'] <- macro$cp_growth[macro$quarter == period]
  macro_WO_q['HP'] <- macro$hp_growth[macro$quarter == period]
  return(macro_WO_q)
}
###======================================================================================
provisioning_macro_inputs_F <- function(macro_inputs, period, horizon) {
  if(horizon == 0) {
    return(NULL)
  } else {
    macro <- macro_inputs$macro_data  
    macro_PR_q <- c(UR=NA, GDP=NA, CRE=NA, CRE_BUS = NA, HP=NA, GDP_YE = NA)
    h_interval <- (period + 1):(period + horizon)
    macro <- macro[c(1:nrow(macro), rep(nrow(macro), horizon)), ]
    macro$quarter <- 0:(nrow(macro) - 1)
    macro_PR_q['UR'] <- sum(macro$un_rate[macro$quarter %in% h_interval] - 
                              macro$un_rate[macro$quarter == 0])
    macro_PR_q['GDP'] <- sum(macro$gdp_growth[macro$quarter %in% h_interval] - 
                               macro$gdp_growth[macro$quarter == 0])
    macro_PR_q['GDP_YE'] <- sum(macro$gdp_growth_ye[macro$quarter %in% h_interval] - 
                                  macro$gdp_growth_ye[macro$quarter == 0])
    CRE_obs <- macro$cp_growth[macro$quarter %in% 1:(period + horizon)]
    macro_PR_q['CRE'] <- sum((100*(cumprod(CRE_obs/100 + 1) - 1))[h_interval])
    macro_PR_q['HP'] <- 
      min(100*(cumprod(1 + macro$hp_growth[macro$quarter %in% h_interval]/100) - 1))
    macro_PR_q['CRE_BUS'] <- 
      min(100*(cumprod(1 + macro$cp_growth[macro$quarter %in% h_interval]/100) - 1))
    return(macro_PR_q)
  }
}
###======================================================================================
loan_losses_F <- function(start, open, close, mort_loss_outputs,  bus_loss_outputs,
                          pmtrs, macro_inputs, macro_q, period, 
                          provisioning) {
  ACs_ln <- colnames(start)[grepl('^AC_ln_', colnames(start))]
  ACs_to_apply_mean <- macro_inputs$ACs_to_apply_mean
  ACs_to_forecast <- ACs_ln[!ACs_ln %in% ACs_to_apply_mean]
  asset_balances <- open[, ACs_ln]
  macro_obs <- as.numeric(macro_q[rownames(macro_inputs$macro_pd_coeff)])
  pd_change <- macro_obs %*% macro_inputs$macro_pd_coeff[, ACs_ln]
  lgd_change <- macro_obs %*% macro_inputs$macro_lgd_coeff[, ACs_ln]
  pd_start <- start[, gsub('AC_', 'PD_', ACs_ln)]
  pd_min <- start[, gsub('AC_', 'minPD_', ACs_ln)]
  lgd_start <- start[, gsub('AC_', 'LGD_', ACs_ln)]
  lgd_min <- start[, gsub('AC_', 'minLGD_', ACs_ln)]
  pd <- pmax(pd_start + pd_change, pd_min)
  lgd <- pmax(lgd_start + lgd_change, lgd_min)
  pd[, c('PD_ln_dom_res_mort', 'PD_ln_os_res_mort')] <- mort_loss_outputs$pd * 4
  lgd[, c('LGD_ln_dom_res_mort', 'LGD_ln_os_res_mort')] <- mort_loss_outputs$lgd
  LVR_dist <- mort_loss_outputs$LVR_dist
  pd[, c('PD_ln_dom_business')] <- bus_loss_outputs$pd 
  lgd[, c('LGD_ln_dom_business')] <- bus_loss_outputs$lgd
  LVR_dist_bus <- bus_loss_outputs$LVR_dist_bus
  pd[, c('PD_ln_dom_cp')] <- bus_loss_outputs$pd 
  lgd[, c('LGD_ln_dom_cp')] <- bus_loss_outputs$lgd
  pd[, c('PD_ln_os_cp')] <- bus_loss_outputs$pd
  lgd[, c('LGD_ln_os_cp')] <- bus_loss_outputs$lgd
  pd[, gsub('AC_', 'PD_', ACs_to_apply_mean)] <- 
    rowMeans(pd[, gsub('AC_', 'PD_', ACs_to_forecast)])
  lgd[, gsub('AC_', 'LGD_', ACs_to_apply_mean)] <- 
    rowMeans(lgd[, gsub('AC_', 'LGD_', ACs_to_forecast)])
  close[, colnames(pd)] <- pd
  close[, colnames(lgd)] <- lgd
  loss_rates <-  pd * lgd / 4
  loss_rates[is.na(loss_rates)] <- 0  
  names(loss_rates) <- gsub('AC_', 'LR_', ACs_ln)
  asset_losses <- asset_balances[, ACs_ln] * loss_rates
  if(provisioning) {
    return(asset_losses)
  } else {
    return(list(asset_losses=asset_losses, LVR_dist=LVR_dist, LVR_dist_bus = LVR_dist_bus, 
                close=close))
  }
}
###======================================================================================
# Called by profit_tax_dividends_F
dividend_paid_F <- function(close, pmtrs) {
  AT1_shortfall <- max((pmtrs$min_tier1ratio - pmtrs$min_cet1ratio) - 
                         (close$cap_ratio_tier1 - close$cap_ratio_cet1), 0)
  tier2_shortfall <- max((pmtrs$min_totcapratio - pmtrs$min_tier1ratio) - 
                           (close$cap_ratio_total - close$cap_ratio_tier1), 0)
  cet1_spare <- 
    (close$cap_ratio_cet1 - AT1_shortfall - tier2_shortfall) - pmtrs$min_cet1ratio
  CCB <- pmtrs$cap_cons_buffer
  if(close$pnl_npat <= 0 | (close$pnl_npat > 0 & cet1_spare <= 0.25*CCB)) div_max <- 0
  if(close$pnl_npat > 0) {
    if(cet1_spare > 0.25*CCB & cet1_spare <=  0.5*CCB) div_max <- 0.2
    if(cet1_spare >  0.5*CCB & cet1_spare <= 0.75*CCB) div_max <- 0.4
    if(cet1_spare > 0.75*CCB & cet1_spare <=    1*CCB) div_max <- 0.6
    if(cet1_spare > CCB) div_max <- Inf
  }
  if(div_max > 0) {  
    low_cet1_thresh <- pmtrs$min_cet1ratio + 0.25*CCB
    hgh_cet1_thresh <- pmtrs$target_cet1ratio + pmtrs$div_cap_buffer
    if(close$cap_ratio_cet1 > hgh_cet1_thresh) {
      payout_ratio <- pmtrs$div_ratio_normal
    } else {
      payout_ratio <- pmtrs$div_ratio_recovery + 
        (pmtrs$div_ratio_normal - pmtrs$div_ratio_recovery) *
        (close$cap_ratio_cet1 - low_cet1_thresh)/(hgh_cet1_thresh - low_cet1_thresh)
    }
  } else payout_ratio <- 0
  dividend <- min(payout_ratio, div_max) * close$pnl_npat
  return(dividend)
}
###======================================================================================
expenditure_on_releveraging_F <- function(start, close, pmtrs) {
  cap_buffers <- pmtrs$cap_cons_buffer + pmtrs$asset_purch_cap_buffer
  ACs_ln <- grep('^AC_ln_', colnames(start), value=TRUE)
  cap_ratio_cet1 <- close$cap_cet1 / close$rwa_total
  if(cap_ratio_cet1 >= pmtrs$min_cet1ratio + cap_buffers) {
    purch_amount <- close$profit_ret * (1/close$rwa_avg_lnRW) * (start$rwa_total/start$cap_cet1) 
  }
  if(cap_ratio_cet1 >= pmtrs$min_cet1ratio &
     cap_ratio_cet1 < pmtrs$min_cet1ratio + cap_buffers) {
    purch_amount <- close$profit_ret
  }
  if(cap_ratio_cet1 < pmtrs$min_cet1ratio) purch_amount <- 0
  return(purch_amount)
}
###======================================================================================
risk_weight_F <- function(pd, lgd, R=0.15) {
  K <- lgd * pnorm((qnorm(pd) + sqrt(R) * qnorm(0.999))/sqrt(1 - R)) - pd * lgd
  return(K * 12.5)
}
###======================================================================================
cet1_breakdown_F <- function(output) {
  agg_cet1 <- rowSums(sapply(output, function(x) x$cap_cet1))
  agg_rwa <- rowSums(sapply(output, function(x) x$rwa_total))
  agg_bsh <- rowSums(sapply(output, function(x) x$bsh_total_AC))
  agg_losses <- rowSums(sapply(output, function(x) x$pnl_BDD_charge))
  agg_mort_loss <- rowSums(sapply(output, function(x) x$loss_dom_res_mort + 
                                    x$loss_os_res_mort))
  agg_bus_loss <- rowSums(sapply(output, function(x) x$loss_dom_business))
  agg_cre_loss <- rowSums(sapply(output, function(x) x$loss_dom_cp + x$loss_os_cp))
  agg_oth_loss <- agg_losses - agg_mort_loss - agg_bus_loss - agg_cre_loss
  
  agg_rev <- rowSums(sapply(output, function(x) x$profit_ret)) + agg_losses
  
  agg_cet1_ratio <- agg_cet1 / agg_rwa
  agg_RW <- agg_rwa / agg_bsh
  agg_cet1_ratio_const_RW <- agg_cet1/(agg_bsh * agg_RW[1])
  y <- c()
  y$start_cet1 <- agg_cet1_ratio[1]
  y$troughperiod <- which(agg_cet1_ratio == min(agg_cet1_ratio))
  y$min_cet1 <- agg_cet1_ratio[y$troughperiod]
  y$decline_cet1 <- y$start_cet1 - y$min_cet1
  
  y$mort_loss_cont <- -sum(agg_mort_loss[2:y$troughperiod]) / agg_rwa[1]
  y$bus_loss_cont <- -sum(agg_bus_loss[2:y$troughperiod]) / agg_rwa[1]
  y$cre_loss_cont <- -sum(agg_cre_loss[2:y$troughperiod]) / agg_rwa[1]
  y$oth_loss_cont <- -sum(agg_oth_loss[2:y$troughperiod]) / agg_rwa[1]
  y$credit_loss_cont <- sum(y$mort_loss_cont, y$bus_loss_cont, y$cre_loss_cont, 
                            y$oth_loss_cont)
  
  y$rev_cont <- sum(agg_rev[2:y$troughperiod]) / agg_rwa[1]
  
  y$rw_cont <- agg_cet1[y$troughperiod]/(agg_bsh[1]*agg_RW[y$troughperiod]) - 
    agg_cet1[y$troughperiod]/(agg_bsh[1]*agg_RW[1])
  y$bsh_gr_cont <- agg_cet1[y$troughperiod]/(agg_bsh[y$troughperiod]*agg_RW[y$troughperiod]) -
    agg_cet1[y$troughperiod]/(agg_bsh[1]*agg_RW[y$troughperiod])
  y$troughperiod <- y$troughperiod - 1
  
  return(round(do.call(rbind, y), 4))
}
