% Compute bounds of identified set using numerical optimisation in cases
% where the identified set is determined to be unbounded.

clear variables
close all
clc

addpath('auxFunctions');

% Load data.
load('ACRUhlig_results.mat');

% Options for optimisation step in Algorithm 1.
optimOptions = optimoptions('fmincon');
optimOptions.Display = 'off'; % Do not display optimisation output
% Provide analytical gradient of objective function.
%optimOptions.GradObj = 'on'; 
% Provide analytical gradient of nonlinear constraint.
optimOptions.SpecifyConstraintGradient = true; 
optimOptions.CheckGradients = false; % Check provided gradients numerically

% % Identify indices of draws yielding an unbounded identified set.
% inds = find(unbounded==1);

sd_lb = zeros(opt.nonEmpty,opt.H+1,length(opt.ivar));
sd_ub = sd_lb;
unit_lb = zeros(opt.nonEmpty,opt.H+1,length(opt.ivar));
unit_ub = unit_lb;

tic

for ii = 1:opt.nonEmpty
    
    phi.B = B(:,ii);
    phi.Sigmatr = Sigmatr(:,:,ii);
    phi.Sigmatrinv = phi.Sigmatr\eye(n);
    
    % Generate coefficients in orthogonal reduced-form VMA representation.
    [phi.vma,~] = genVMA(phi,opt);
    
    % Check if identified set is nonempty.
    [empty,restr.F,restr.S,Sbar,r,K,c0] = checkEmptyIS_Read(restr,phi);
    
    % Draw qs from uniform distribution over space of unit-length
    % vectors satisfying identifying restrictions. These can be used as 
    % initial values in optimisation step.
    q0 = drawqGibbs(Sbar,r,K,c0,5,3,2);
    
    % Compute bounds of identified sets for impulse responses (to both
    % standard-deviation and unit shocks) using interior-point algorithm.
    [sd_lb(ii,:,:),sd_ub(ii,:,:)] = ...
           numericalBounds(restr,phi,q0,opt,optimOptions);
    [unit_lb(ii,:,:),unit_ub(ii,:,:)] = ...
           numericalBoundsUnit(restr,phi,q0,opt,optimOptions);
      
      if mod(opt.nonEmpty-ii,opt.dispIter) == 0
              
       fprintf('\n%d draws with non-empty identified set remaining...',...
       opt.nonEmpty-ii);
               
      end   
       
       
end

runTimeOpt = toc;

% Compute sets of posterior means.
etaMeanlb = permute(mean(sd_lb,1),[2 3 1]);
etaMeanub = permute(mean(sd_ub,1),[2 3 1]);
etaUnitMeanlb = permute(mean(unit_lb,1),[2 3 1]);
etaUnitMeanub = permute(mean(unit_ub,1),[2 3 1]);

% Compute sets of posterior medians.
etaMedlb = permute(median(sd_lb,1),[2 3 1]);
etaMedub = permute(median(sd_ub,1),[2 3 1]);
etaUnitMedlb = permute(median(unit_lb,1),[2 3 1]);
etaUnitMedub = permute(median(unit_ub,1),[2 3 1]);

% Compute robust credible intervals.
etaUnitRClb = squeeze(quantile(unit_lb,(1-opt.aalpha)/2,1));
etaUnitRCub = squeeze(quantile(unit_ub,(1+opt.aalpha)/2,1));

% Export results to Excel for graphing.
cd(resultsDir);

% Create table of results for impulse responses.
for ii = 1:length(opt.ivar)
    
    TT1 = table((0:opt.H)',etaUnitMed(:,ii),etaUnitCredlb(:,ii),etaUnitCredub(:,ii),...
        etaUnitMedlb(:,ii),etaUnitMedub(:,ii),etaUnitRClb(:,ii),etaUnitRCub(:,ii));
    TT1.Properties.VariableNames = {'Horizon','Median','CREDLB','CREDUB','MEDLB','MEDUB','RCREDLB','RCREDUB'};
    writetable(TT1,'FigureData.xlsx','Sheet',strcat(varNames{ii},'_ACRUhligOptim'));
    
end

save('ACRUhlig_results_optim.mat');

cd(oldFolder);
