function [irf] = genIRFUnit(q,vma,normir,neg)
% Generate IRF of the ith variable to the first structural shock at the hth
% horizon under unit-effect normaliastion.
% Inputs:
% q: first column of Q
% vma: row vector of coefficients in orthogonal reduced-form VMA 
% representation for ith variable at hth horizon
% normir: row vector of coefficients in orthogonal reduced-form VMA
% representation for first variable on impact (i.e. normalising impulse).
% neg: if neg = -1, return negative of IRF; if neg = 1, return positive

irf = neg*(vma*q)/(normir*q); % IRF of ith variable to first shock

end