function [irfMin,irfMax] = numericalBoundsUnit(restr,phi,q0,opt,optimOptions)
% Function uses a constrained optimisation routine to find the upper and
% lower bounds of identified set for impulse responses.
% Inputs are:
% - restr: structure representing restrictions
% - phi: structure containing reduced-form VAR parameters
% - q0: values of q satisfying identifying restrictions
% - opt: structure containing model information and options
% - optimOptions: structure containing optimisation option

F = restr.F;
S = restr.S;
vma = phi.vma;
H = opt.H;
ivar = opt.ivar;

% Set equality constraint for optimisation (Aeq*q = beq).
Aeq = F;
beq = zeros(size(F,1),1);

% Set inequality constraints for optimisation (Aineq*q <= b).
Aineq = -S;
bineq = zeros(size(S,1),1);

qDraws = size(q0,2); % Number of initial values for optimisation

irfMin = zeros(H+1,length(opt.ivar),qDraws);
irfMax = irfMin;
LB = [];
UB = [];

normir = phi.Sigmatr(1,:);

parfor kk = 1:qDraws

for hh = 1:H+1 % For each horizon
    
    [irfMin(hh,:,kk),irfMax(hh,:,kk)] = genBoundsUnit(q0,ivar,vma(:,:,hh),normir,...
        Aineq,bineq,Aeq,beq,LB,UB,optimOptions)
    
end

end

irfMax = -irfMax; % Max obtained by minimising negative of objective

% Take optima over different initial values.
irfMin = min(irfMin,[],3);
irfMax = max(irfMax,[],3);

end